/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.client.data.RTFTranslationKeys;
import raccoonman.reterraforged.client.gui.screen.page.BisectedPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetConfigScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetWidgets;
import raccoonman.reterraforged.client.gui.screen.presetconfig.RenderMode;
import raccoonman.reterraforged.client.gui.widget.Slider;
import raccoonman.reterraforged.client.gui.widget.ValueButton;
import raccoonman.reterraforged.concurrent.cache.CacheManager;
import raccoonman.reterraforged.config.PerformanceConfig;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;
import raccoonman.reterraforged.data.worldgen.preset.settings.SpawnType;
import raccoonman.reterraforged.data.worldgen.preset.settings.WorldSettings;
import raccoonman.reterraforged.registries.RTFRegistries;
import raccoonman.reterraforged.world.worldgen.GeneratorContext;
import raccoonman.reterraforged.world.worldgen.cell.Cell;
import raccoonman.reterraforged.world.worldgen.cell.heightmap.Levels;
import raccoonman.reterraforged.world.worldgen.densityfunction.tile.Tile;
import raccoonman.reterraforged.world.worldgen.noise.NoiseUtil;
import raccoonman.reterraforged.world.worldgen.noise.module.Noise;
import raccoonman.reterraforged.world.worldgen.util.PosUtil;

public abstract class PresetEditorPage
extends BisectedPage<PresetConfigScreen, AbstractWidget, AbstractWidget> {
    private Slider zoom;
    private CycleButton<RenderMode> renderMode;
    private ValueButton<Integer> seed;
    private Preview preview;
    protected PresetListPage.PresetEntry preset;

    public PresetEditorPage(PresetConfigScreen screen, PresetListPage.PresetEntry preset) {
        super(screen);
        this.preset = preset;
    }

    protected void regenerate() {
        this.preview.regenerate();
    }

    @Override
    public void init() {
        super.init();
        if (this.preview != null) {
            try {
                this.preview.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.zoom = PresetWidgets.createIntSlider(Optional.ofNullable(this.zoom).map(Slider::getLerpedValue).orElse(68.0).intValue(), 1, 100, RTFTranslationKeys.GUI_SLIDER_ZOOM, (slider, value) -> {
            this.regenerate();
            return value;
        });
        this.renderMode = PresetWidgets.createCycle(ImmutableList.copyOf((Object[])RenderMode.values()), this.renderMode != null ? (RenderMode)((Object)this.renderMode.m_168883_()) : RenderMode.BIOME_TYPE, Optional.empty(), (button, value) -> this.regenerate(), Enum::name);
        this.seed = PresetWidgets.createRandomButton(RTFTranslationKeys.GUI_BUTTON_SEED, (int)((PresetConfigScreen)this.screen).getSettings().f_244272_().m_245499_(), i -> {
            ((PresetConfigScreen)this.screen).setSeed(i.intValue());
            this.regenerate();
        });
        this.preview = new Preview();
        this.preview.regenerate();
        this.right.addWidget(this.zoom);
        this.right.addWidget(this.renderMode);
        this.right.addWidget(this.seed);
        this.right.addWidget(this.preview);
    }

    @Override
    public void onClose() {
        super.onClose();
        try {
            this.preset.save();
            this.preview.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDone() {
        super.onDone();
        try {
            ((PresetConfigScreen)this.screen).applyPreset(this.preset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class Preview
    extends Button {
        private static final int FACTOR = 4;
        public static final int SIZE = 256;
        private static final float[] LEGEND_SCALES = new float[]{1.0f, 0.9f, 0.75f, 0.6f};
        private DynamicTexture texture;
        private ResourceLocation textureId;
        private Tile tile;
        private int centerX;
        private int centerZ;
        private String hoveredCoords;
        private String[] legendValues;
        private Component[] legendLabels;
        private int offsetX;
        private int offsetZ;

        public Preview() {
            super(-1, -1, -1, -1, CommonComponents.f_237098_, b -> {
                Preview self;
                System.out.println("clicked");
                Minecraft mc = Minecraft.m_91087_();
                MouseHandler mouse = mc.f_91067_;
                if (b instanceof Preview && (self = (Preview)b).updateLegend((int)mouse.m_91589_(), (int)mouse.m_91594_()) && !self.hoveredCoords.isEmpty()) {
                    self.m_7435_(Minecraft.m_91087_().m_91106_());
                    ((PresetConfigScreen)((PresetEditorPage)raccoonman$reterraforged$client$gui$screen$presetconfig$PresetEditorPage$this).screen).f_96541_.f_91068_.m_90911_(self.hoveredCoords);
                }
            }, f_252438_);
            this.texture = new DynamicTexture(new NativeImage(256, 256, false));
            this.textureId = Minecraft.m_91087_().m_91097_().m_118490_("reterraforged-preview-framebuffer", this.texture);
            this.hoveredCoords = "";
            this.legendValues = new String[]{"", "", ""};
            this.legendLabels = new Component[]{Component.m_237115_((String)RTFTranslationKeys.GUI_LABEL_PREVIEW_AREA), Component.m_237115_((String)RTFTranslationKeys.GUI_LABEL_PREVIEW_TERRAIN), Component.m_237115_((String)RTFTranslationKeys.GUI_LABEL_PREVIEW_BIOME)};
        }

        public void regenerate() {
            WorldCreationContext settings = ((PresetConfigScreen)PresetEditorPage.this.screen).getSettings();
            RegistryAccess.Frozen registries = settings.m_246480_();
            HolderLookup.Provider provider = PresetEditorPage.this.preset.getPreset().buildPatch((RegistryAccess)registries);
            HolderLookup.RegistryLookup presets = provider.m_255025_(RTFRegistries.PRESET);
            HolderLookup.RegistryLookup noises = provider.m_255025_(RTFRegistries.NOISE);
            Preset preset = (Preset)presets.m_255043_(Preset.KEY).m_203334_();
            WorldSettings world = preset.world();
            WorldSettings.Properties properties = world.properties;
            try {
                CacheManager.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PerformanceConfig config = PerformanceConfig.read(PerformanceConfig.DEFAULT_FILE_PATH).resultOrPartial(arg_0 -> ((Logger)RTFCommon.LOGGER).error(arg_0)).orElseGet(PerformanceConfig::makeDefault);
            GeneratorContext generatorContext = GeneratorContext.makeUncached(preset, (HolderGetter<Noise>)noises, (int)settings.f_244272_().m_245499_(), 4, 0, config.batchCount());
            this.centerX = 0;
            this.centerZ = 0;
            if (preset.world().properties.spawnType == SpawnType.CONTINENT_CENTER) {
                long nearestContinentCenter = generatorContext.lookup.getHeightmap().continent().getNearestCenter(this.offsetX, this.offsetZ);
                this.centerX = PosUtil.unpackLeft(nearestContinentCenter);
                this.centerZ = PosUtil.unpackRight(nearestContinentCenter);
            } else {
                this.centerX = 0;
                this.centerZ = 0;
            }
            this.tile = generatorContext.generator.generateZoomed(this.centerX, this.centerZ, this.getZoom(), false).join();
            RenderMode renderMode = (RenderMode)((Object)PresetEditorPage.this.renderMode.m_168883_());
            Levels levels = new Levels(properties.terrainScaler(), properties.seaLevel);
            int stroke = 2;
            int width = this.tile.getBlockSize().size();
            NativeImage pixels = this.texture.m_117991_();
            this.tile.iterate((cell, x, z) -> {
                if (x < stroke || z < stroke || x >= width - stroke || z >= width - stroke) {
                    pixels.m_84988_(x, z, Color.BLACK.getRGB());
                } else {
                    pixels.m_84988_(x, z, renderMode.getColor(cell, levels));
                }
            });
            this.texture.m_117985_();
        }

        public void close() throws Exception {
            this.texture.close();
            try {
                CacheManager.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            this.f_93619_ = this.m_5711_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            guiGraphics.m_280163_(this.textureId, x, y, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            this.updateLegend(mx, my);
            this.renderLegend(guiGraphics, mx, my, this.legendLabels, this.legendValues, x, y + this.f_93618_, 10, 0xFFFFFF);
        }

        private boolean updateLegend(int mx, int my) {
            if (this.tile != null) {
                int left = this.m_252754_();
                int top = this.m_252907_();
                float size = this.f_93618_;
                int zoom = this.getZoom();
                int width = Math.max(1, this.tile.getBlockSize().size() * zoom);
                int height = Math.max(1, this.tile.getBlockSize().size() * zoom);
                this.legendValues[0] = width + "x" + height;
                if (mx >= left && (float)mx <= (float)left + size && my >= top && (float)my <= (float)top + size) {
                    float fx = (float)(mx - left) / size;
                    float fz = (float)(my - top) / size;
                    int ix = NoiseUtil.round(fx * (float)this.tile.getBlockSize().size());
                    int iz = NoiseUtil.round(fz * (float)this.tile.getBlockSize().size());
                    Cell cell = this.tile.lookup(ix, iz);
                    this.legendValues[1] = Preview.getTerrainName(cell);
                    this.legendValues[2] = Preview.getBiomeName(cell);
                    int dx = (ix - this.tile.getBlockSize().size() / 2) * zoom;
                    int dz = (iz - this.tile.getBlockSize().size() / 2) * zoom;
                    this.hoveredCoords = this.centerX + dx + ":" + (this.centerZ + dz);
                    return true;
                }
                this.hoveredCoords = "";
            }
            return false;
        }

        private float getLegendScale() {
            int index = (Integer)((PresetConfigScreen)((PresetEditorPage)PresetEditorPage.this).screen).f_96541_.f_91066_.m_231928_().m_231551_() - 1;
            if (index < 0 || index >= LEGEND_SCALES.length) {
                index = LEGEND_SCALES.length - 1;
            }
            return LEGEND_SCALES[index];
        }

        private void renderLegend(GuiGraphics guiGraphics, int mx, int my, Component[] labels, String[] values, int left, int top, int lineHeight, int color) {
            float scale = this.getLegendScale();
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)left + 3.75f * scale, (float)top - (float)lineHeight * (3.2f * scale), 0.0f);
            pose.m_85841_(scale, scale, 1.0f);
            Minecraft mc = Minecraft.m_91087_();
            Font renderer = mc.f_91062_;
            int spacing = 0;
            for (Component s : labels) {
                spacing = Math.max(spacing, renderer.m_92852_((FormattedText)s));
            }
            float maxWidth = (float)(this.f_93618_ - 4) / scale;
            for (int i = 0; i < labels.length && i < values.length; ++i) {
                Component label = labels[i];
                String value = values[i];
                while (value.length() > 0 && (float)(spacing + renderer.m_92895_(value)) > maxWidth) {
                    value = value.substring(0, value.length() - 1);
                }
                guiGraphics.m_280430_(renderer, label, 0, i * lineHeight, color);
                guiGraphics.m_280488_(renderer, value, spacing, i * lineHeight, color);
            }
            pose.m_85849_();
            if (!this.hoveredCoords.isEmpty()) {
                guiGraphics.m_280137_(renderer, this.hoveredCoords, mx, my - 10, 0xFFFFFF);
            }
        }

        private int getZoom() {
            return NoiseUtil.round(1.5f * (101.0f - (float)PresetEditorPage.this.zoom.getLerpedValue()));
        }

        private static String getTerrainName(Cell cell) {
            if (cell.terrain.isRiver()) {
                return "river";
            }
            return cell.terrain.getName().toLowerCase();
        }

        private static String getBiomeName(Cell cell) {
            String terrain = cell.terrain.getName().toLowerCase();
            if (terrain.contains("ocean")) {
                if (cell.temperature < 0.3f) {
                    return "cold_" + terrain;
                }
                if (cell.temperature > 0.6f) {
                    return "warm_" + terrain;
                }
                return terrain;
            }
            if (terrain.contains("river")) {
                return "river";
            }
            return cell.biome.name().toLowerCase();
        }
    }
}

