/*
 * Decompiled with CFR 0.152.
 */
package raccoonman.reterraforged.client.gui.screen.presetconfig;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.apache.commons.io.file.PathUtils;
import raccoonman.reterraforged.RTFCommon;
import raccoonman.reterraforged.client.gui.screen.page.LinkedPageScreen;
import raccoonman.reterraforged.client.gui.screen.presetconfig.PresetListPage;
import raccoonman.reterraforged.data.worldgen.Datapacks;
import raccoonman.reterraforged.data.worldgen.preset.settings.Preset;

public class PresetConfigScreen
extends LinkedPageScreen {
    private CreateWorldScreen parent;

    public PresetConfigScreen(CreateWorldScreen parent) {
        this.parent = parent;
        this.currentPage = new PresetListPage(this);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void setSeed(long seed) {
        this.parent.m_267748_().m_267692_(this.getSettings().m_246527_(options -> new WorldOptions(seed, options.m_247749_(), options.m_245100_())));
    }

    public WorldCreationContext getSettings() {
        return this.parent.m_267748_().m_267573_();
    }

    public void applyPreset(PresetListPage.PresetEntry preset) throws IOException {
        Pair path = this.parent.m_267637_(this.parent.m_267748_().m_267573_().f_243842_());
        Path exportPath = ((Path)path.getFirst()).resolve("reterraforged-preset.zip");
        this.exportAsDatapack(exportPath, preset);
        PackRepository repository = (PackRepository)path.getSecond();
        repository.m_10506_();
        if (repository.m_275855_("file/" + exportPath.getFileName())) {
            this.parent.m_269443_(repository, false, data -> {});
        }
    }

    public void exportAsDatapack(Path outputPath, PresetListPage.PresetEntry presetEntry) throws IOException {
        Path datagenPath = Files.createTempDirectory("datagen-target-", new FileAttribute[0]);
        Path datagenOutputPath = datagenPath.resolve("output");
        RegistryAccess.Frozen registryAccess = this.getSettings().m_246480_();
        Preset preset = presetEntry.getPreset();
        Component presetName = presetEntry.getName();
        DataGenerator dataGenerator = Datapacks.makePreset(preset, (RegistryAccess)registryAccess, datagenPath, datagenOutputPath, presetName.getString());
        dataGenerator.m_123917_();
        PresetConfigScreen.copyToZip(datagenOutputPath, outputPath);
        PathUtils.deleteDirectory((Path)datagenPath);
        RTFCommon.LOGGER.info("Exported datapack to {}", (Object)outputPath);
    }

    private static void copyToZip(Path input, Path output) {
        ImmutableMap env = ImmutableMap.of((Object)"create", (Object)"true");
        URI uri = URI.create("jar:" + output.toUri());
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            PathUtils.copyDirectory((Path)input, (Path)fs.getPath("/", new String[0]), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

