vec2 OffsetDist(float x) {
	float n = fract(x * 8.0) * 3.1415;
    return vec2(cos(n), sin(n)) * x;
}

float AmbientOcclusion(float dither) {
	if(texCoord.x < 0.0 || texCoord.x > 1.0 || texCoord.y < 0.0 || texCoord.y > 1.0) return 1.0;

	float ao = 0.0;
	
	float d = texture2D(depthtex0, texCoord).r;
	if(d >= 1.0) return 1.0;

	float hand = float(d < 0.56);
	d = GetLinearDepth(d);

	#if AA == 2
	dither = fract(dither + frameTimeCounter * 8.0);
	#endif

	float currentStep = 0.2 * dither + 0.2;

	float radius = 0.35;
	float fovScale = gbufferProjection[1][1] / 1.37;
	float distScale = max((far - near) * d + near, 5.0);
	vec2 scale = radius * vec2(1.0 / aspectRatio, 1.0) * fovScale / distScale;

	float sampleDepth = 0.0, sample = 0.0, angle = 0.0, dist = 0.0;

	for(int i = 0; i < 4; i++) {
		vec2 offset = OffsetDist(currentStep) * scale;
		float mult = (0.7 / radius) * (far - near) * (hand > 0.5 ? 1024.0 : 1.0);

		sampleDepth = GetLinearDepth(texture2D(depthtex0, texCoord + offset).r);
		sample = (d - sampleDepth) * mult;
		angle = clamp(0.5 - sample, 0.0, 1.0);
		dist = clamp(0.25 * sample - 1.0, 0.0, 1.0);

		sampleDepth = GetLinearDepth(texture2D(depthtex0, texCoord - offset).r);
		sample = (d - sampleDepth) * mult;
		angle += clamp(0.5 - sample, 0.0, 1.0);
		dist += clamp(0.25 * sample - 1.0, 0.0, 1.0);
		
		ao += clamp(angle + dist, 0.0, 1.0);
		currentStep += 0.2;
	}
	ao *= 0.25;
	
	return ao;
}