package objmodel;


public class Vertex
{
    public float x, y, z;

    public Vertex(float x, float y)
    {
        this(x, y, 0F);
    }

    public Vertex(float x, float y, float z)
    {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void normalize()
    {
        double d = Math.sqrt(x*x + y*y + z*z);
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public void add(Vertex v)
    {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public boolean equal(Vertex v)
    {
        return this.x==v.x && this.y==v.y && this.z==v.z;
    }
}