package objmodel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IModelCustom
{
    String getType();
    @OnlyIn(Dist.CLIENT)
    void renderAll(VertexConsumer tessellator, PoseStack poseStack);
    @OnlyIn(Dist.CLIENT)
    void renderOnly(VertexConsumer tessellator, PoseStack poseStack, String... groupNames);
    @OnlyIn(Dist.CLIENT)
    void renderPart(VertexConsumer tessellator, PoseStack poseStack, String partName);
    @OnlyIn(Dist.CLIENT)
    void renderAllExcept(VertexConsumer tessellator, PoseStack poseStack, String... excludedGroupNames);
}