package objmodel;

import java.util.ArrayList;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;



@OnlyIn(Dist.CLIENT)
public class GroupObject_mqo
{
	public String name;
	public ArrayList<Face_mqo> faces = new ArrayList<Face_mqo>();
	public int glDrawingMode;

	public GroupObject_mqo()
	{
		this("");
	}

	public GroupObject_mqo(String name)
	{
		this(name, -1);
	}

	public GroupObject_mqo(String name, int glDrawingMode)
	{
		this.name = name;
		this.glDrawingMode = glDrawingMode;
	}

	/*public void render()
	{
		if (faces.size() > 0)
		{
			Tessellator2 tessellator = Tessellator2.instance;
			tessellator.startDrawing(glDrawingMode);
			render(tessellator);
			tessellator.draw();
		}
	}*/

	public void render(VertexConsumer tessellator, PoseStack poseStack)
	{
		if (faces.size() > 0)
		{
			for (Face_mqo face : faces)
			{
				face.addFaceForRender(tessellator, poseStack);
			}
		}
	}
}