package objmodel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class Face
{
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;
    public static PoseStack posestack = null;
    public static int lightmap = 150;//15
    public static final Vector4f v4f = new Vector4f(1.0F, 1.0F, 0.0F, 0.0F);
    public static Vector4f uvOperator = v4f;

    /*@OnlyIn(Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator, PoseStack poseStack)
    {
        addFaceForRender(tessellator, poseStack, 0.0005F);
    }

    @OnlyIn(Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator, PoseStack poseStack, float textureOffset)
    {
        VertexConsumer VC = tessellator;
        PoseStack.Pose posestack$pose = poseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        if (faceNormal == null)
        {
            faceNormal = this.calculateFaceNormal();
        }
        //Matrix4f transform = posestack.last().pose();
        VC.normal(matrix3f, faceNormal.x, faceNormal.y, faceNormal.z);//tessellator.setNormal(faceNormal.x, faceNormal.y, faceNormal.z);

        float averageU = 0F;
        float averageV = 0F;

        if ((textureCoordinates != null) && (textureCoordinates.length > 0))
        {
            for (int i = 0; i < textureCoordinates.length; ++i)
            {
                averageU += textureCoordinates[i].u;
                averageV += textureCoordinates[i].v;
            }

            averageU = averageU / textureCoordinates.length;
            averageV = averageV / textureCoordinates.length;
        }

        float offsetU, offsetV;

        for (int i = 0; i < vertices.length; ++i)
        {
            VC.vertex(matrix4f, vertices[i].x, vertices[i].y, vertices[i].z);
            VC.color(255,255,255,255);

            if ((textureCoordinates != null) && (textureCoordinates.length > 0))
            {
                offsetU = textureOffset;
                offsetV = textureOffset;

                float textureU = (this.textureCoordinates[i]).u * uvOperator.x() + uvOperator.z();
                float textureV = (this.textureCoordinates[i]).v * uvOperator.y() + uvOperator.w();

                if (textureCoordinates[i].u > averageU)//if (textureU > averageU)
                {
                    offsetU = -offsetU;
                }
                if (textureCoordinates[i].v > averageV)//if (textureV > averageV)
                {
                    offsetV = -offsetV;
                }

                if(this.vertexNormals!=null && i<this.vertexNormals.length)
                {
                    VC.normal(matrix3f, this.vertexNormals[i].x, this.vertexNormals[i].y, this.vertexNormals[i].z);//tessellator.setNormal(this.vertexNormals[i].x, this.vertexNormals[i].y, this.vertexNormals[i].z);
                }

                //tessellator.addVertexWithUV(vertices[i].x, vertices[i].y, vertices[i].z, textureCoordinates[i].u + offsetU, textureCoordinates[i].v + offsetV);
                //VC.vertex(vertices[i].x, vertices[i].y, vertices[i].z);
                VC.uv(textureCoordinates[i].u + offsetU, textureCoordinates[i].v + offsetV);
                //VC.uv(textureU + offsetU, textureV + offsetV);
            }
            else
            {
                //VC.vertex(vertices[i].x, vertices[i].y, vertices[i].z);//tessellator.addVertex(vertices[i].x, vertices[i].y, vertices[i].z);
                VC.uv(0.0F, 0.0F);
            }
            VC.uv2(lightmap);
            VC.overlayCoords(OverlayTexture.NO_OVERLAY);

            VC.endVertex();
        }
    }*/

    /*public Vertex calculateFaceNormal()
    {
        Vec3 v1 = Vec3.createVectorHelper(vertices[1].x - vertices[0].x, vertices[1].y - vertices[0].y, vertices[1].z - vertices[0].z);
        Vec3 v2 = Vec3.createVectorHelper(vertices[2].x - vertices[0].x, vertices[2].y - vertices[0].y, vertices[2].z - vertices[0].z);
        Vec3 normalVector = null;

        normalVector = v1.crossProduct(v2).normalize();

        return new Vertex((float) normalVector.xCoord, (float) normalVector.yCoord, (float) normalVector.zCoord);
    }*/

    public Face copy()
    {
        Face f = new Face();

        return f;
    }

    public void addFaceForRender(VertexConsumer tessellator, PoseStack poseStack)
    {
        addFaceForRender(tessellator, poseStack, 0.0005F);
    }

    public void addFaceForRender(VertexConsumer tessellator, PoseStack poseStack, float textureOffset)
    {


        PoseStack.Pose posestack$pose = poseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        if (faceNormal == null)
        {
            faceNormal = this.calculateFaceNormal();
        }
        //Matrix4f transform = posestack.last().pose();
        //tessellator.setNormal(faceNormal.x, faceNormal.y, faceNormal.z);

        float averageU = 0F;
        float averageV = 0F;

        if ((textureCoordinates != null) && (textureCoordinates.length > 0))
        {
            for (int i = 0; i < textureCoordinates.length; ++i)
            {
                averageU += textureCoordinates[i].u;
                averageV += textureCoordinates[i].v;
            }

            averageU = averageU / textureCoordinates.length;
            averageV = averageV / textureCoordinates.length;
        }

        float offsetU, offsetV;

        for (int i = 0; i < vertices.length; ++i)
        {
            //	VertexConsumer VC = tessellator;
            //	VC.normal(matrix3f, faceNormal.x, faceNormal.y, faceNormal.z);
            //	VC.vertex(matrix4f, vertices[i].x, vertices[i].y, vertices[i].z);
            //	VC.color(255,255,255,255);


            float u = 0;
            float v = 0;

            float nx = faceNormal.x;
            float ny = faceNormal.y;
            float nz = faceNormal.z;

            if ((textureCoordinates != null) && (textureCoordinates.length > 0)) {
                offsetU = textureOffset;
                offsetV = textureOffset;

                float textureU = (this.textureCoordinates[i]).u * uvOperator.x() + uvOperator.z();
                float textureV = (this.textureCoordinates[i]).v * uvOperator.y() + uvOperator.w();

                if (textureCoordinates[i].u > averageU)//if (textureU > averageU)
                {
                    offsetU = -offsetU;
                }
                if (textureCoordinates[i].v > averageV)//if (textureV > averageV)
                {
                    offsetV = -offsetV;
                }

                if (this.vertexNormals != null && i < this.vertexNormals.length) {
                    //			VC.normal(matrix3f, this.vertexNormals[i].x, this.vertexNormals[i].y, this.vertexNormals[i].z);//tessellator.setNormal(this.vertexNormals[i].x, this.vertexNormals[i].y, this.vertexNormals[i].z);
                    nx = this.vertexNormals[i].x;
                    ny = this.vertexNormals[i].y;
                    nz = this.vertexNormals[i].z;
                }

                //tessellator.addVertexWithUV(vertices[i].x, vertices[i].y, vertices[i].z, textureCoordinates[i].u + offsetU, textureCoordinates[i].v + offsetV);
                //VC.vertex(vertices[i].x, vertices[i].y, vertices[i].z);
                //		VC.uv(textureCoordinates[i].u + offsetU, textureCoordinates[i].v + offsetV);
                //VC.uv(textureU + offsetU, textureV + offsetV);
                u = textureCoordinates[i].u + offsetU;
                v = textureCoordinates[i].v + offsetV;
            } else {
                //VC.vertex(vertices[i].x, vertices[i].y, vertices[i].z);//tessellator.addVertex(vertices[i].x, vertices[i].y, vertices[i].z);
                //		VC.uv(0.0F, 0.0F);
            }
            //	VC.uv2(lightmap);
            //	VC.overlayCoords(OverlayTexture.WHITE_OVERLAY_V);

            //	VC.endVertex();
            {
                //Vector4f vector4f = new Vector4f(vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].z);
                //vector4f.transform(matrix4f);

                this.vertex(matrix4f, matrix3f, tessellator,
                        vertices[i].x, vertices[i].y, vertices[i].z, u, v, nx, ny, nz, lightmap);
            }
        }
    }

    public void vertex(Matrix4f mx4, Matrix3f mx3, VertexConsumer vc,
                       float vx, float vy, float vz, float u, float v,
                       float nx, float ny, float nz, int lightmap) {
        vc
                .vertex(mx4, (float)vx, (float)vy, (float)vz)
                .color(255, 255, 255, 255)
                .uv(u, v)
                .overlayCoords(OverlayTexture.NO_OVERLAY)
                .uv2(lightmap)
                .normal(mx3, (float)nx, (float)ny, (float)nz)
                .endVertex();
    }

    public Vertex calculateFaceNormal()
    {
        Vec3 v1 = Vec3.createVectorHelper(vertices[1].x - vertices[0].x, vertices[1].y - vertices[0].y, vertices[1].z - vertices[0].z);
        Vec3 v2 = Vec3.createVectorHelper(vertices[2].x - vertices[0].x, vertices[2].y - vertices[0].y, vertices[2].z - vertices[0].z);
        Vec3 normalVector = null;

        normalVector = v1.crossProduct(v2).normalize();

        return new Vertex((float) normalVector.xCoord, (float) normalVector.yCoord, (float) normalVector.zCoord);
    }
}