package kettenkrad;


import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(mod_Kettenkrad.MOD_ID)
public class mod_Kettenkrad {
    public static final String MOD_ID = "kettenkrad";
    private static final Logger LOGGER = LogManager.getLogger();

    public static RegistryObject<Item> item_kettenkrad;
    //public static EntityType<EntityKettenkrad> ENTITY_KETTENKRAD;

    // Create a Deferred Register to hold CreativeModeTabs which will all be registered under the "examplemod" namespace
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS
            = DeferredRegister.create(Registries.CREATIVE_MODE_TAB, MOD_ID);
    // Creates a creative tab with the id "examplemod:example_tab" for the example item, that is placed after the combat tab
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB
            = CREATIVE_MODE_TABS.register("kettenkrad_tab", () -> CreativeModeTab.builder().
            title(Component.translatable("item_tab." + mod_Kettenkrad.MOD_ID))
            .withTabsBefore(CreativeModeTabs.INGREDIENTS)
            .icon(() -> item_kettenkrad.get().getDefaultInstance())
            .displayItems((parameters, output) -> {
                output.accept(item_kettenkrad.get());
            }).build());


    
    public mod_Kettenkrad() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());


        MinecraftForge.EVENT_BUS.register(this);
        modEventBus.addListener(this::initClient);

        CREATIVE_MODE_TABS.register(modEventBus);

        if (FMLLoader.getDist().isClient()) {
        	
        }else{
            MinecraftForge.EVENT_BUS.register(new RegistryEvents2());
        }
    }

    private void initClient(FMLClientSetupEvent event) {
    //	RenderingRegistry.registerEntityRenderingHandler(ENTITY_KETTENKRAD, RenderKettenkrad::new);
      }

    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create(ForgeRegistries.ENTITY_TYPES, MOD_ID);
    public static final RegistryObject<EntityType<EntityKettenkrad>> ENTITY_KETTENKRAD
            = ENTITIES.register("entitykettenkrad", () -> EntityType.Builder.of(EntityKettenkrad::new, MobCategory.CREATURE)
            .sized(1.5F, 1.5F)
            .setShouldReceiveVelocityUpdates(false)
            .build("entitykettenkrad"));

    @EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents
    {
    	@SubscribeEvent
    	public static void onItemsRegistry(RegisterEvent event) {
    		{
                item_kettenkrad = RegistryObject.create(new ResourceLocation(MOD_ID,"item_kettenkrad"), ForgeRegistries.ITEMS);
                event.register(ForgeRegistries.Keys.ITEMS,
                        helper -> {
                            helper.register(new ResourceLocation(MOD_ID,"item_kettenkrad"),
                                    new ItemKettenkrad(new Item.Properties()));
                        }
                );
    		}
    	}

        @SubscribeEvent
        public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(ENTITY_KETTENKRAD.get(), RenderKettenkrad::new);
        }
    }

    @EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents2
    {
        public static boolean returnflag = false;
        @SubscribeEvent
        public static void entityAttributCreation(EntityAttributeCreationEvent event) {
            if(returnflag)return;

            LOGGER.info("EntityAttributeCreationEvent");
            if (FMLLoader.getDist().isClient())LOGGER.info("EntityAttributeCreationEvent_client");
            event.put(ENTITY_KETTENKRAD.get(), EntityKettenkrad.createAttributes().build());
            returnflag = true;
        }
    }
    
}//end