package kettenkrad;

//import org.lwjgl.opengl.GL11;
//import org.lwjgl.opengl.GL12;

import com.mojang.blaze3d.platform.GlStateManager;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import objmodel.AdvancedModelLoader;
import objmodel.IModelCustom;

@OnlyIn(Dist.CLIENT)
public class RenderKettenkrad extends MobRenderer<EntityKettenkrad, ModelKettenkrad<EntityKettenkrad>> {
   //private static final ResourceLocation PIG_TEXTURES = new ResourceLocation("textures/entity/pig/pig.png");
   
   private static final ResourceLocation TEXTURES = new ResourceLocation("kettenkrad:textures/model/kettenkrad.png");
   private static final IModelCustom MODEL = AdvancedModelLoader.loadModel(new ResourceLocation("kettenkrad:textures/model/kettenkrad.mqo"));

   public RenderKettenkrad(EntityRendererProvider.Context renderManagerIn) {
	   super(renderManagerIn, new ModelKettenkrad(renderManagerIn.bakeLayer(ModelLayers.BEE)), 1.0F);
	   this.shadowStrength = 1.5F;
   }

   
  
   /*
   @SuppressWarnings("deprecation")
public void render(EntityKettenkrad entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
	   
	   super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
	   
	   matrixStackIn.pushPose();
	  // this.bindEntityTexture(entityIn);
	   GL11.glPushMatrix();
	   GL11.glEnable(GL11.GL_DEPTH_TEST);
	   Minecraft mc = Minecraft.getInstance();
	   Minecraft.getInstance().getEntityRenderDispatcher().textureManager.bind(TEXTURES);
	   EntityRenderer<? super EntityKettenkrad> entityrenderer = this.entityRenderDispatcher.getRenderer(entityIn);
	   ActiveRenderInfo activeRenderInfoIn = Minecraft.getInstance().getEntityRenderDispatcher().camera;
	   activeRenderInfoIn.setup(mc.level, (Entity)(mc.getCameraEntity() == null ? mc.player : mc.getCameraEntity()), 
			   !mc.options.getCameraType().isFirstPerson(), mc.options.getCameraType().isMirrored(), partialTicks);
	   Vector3d avector3d = activeRenderInfoIn.getPosition();
	      double camx = avector3d.x();
	      double camy = avector3d.y();
	      double camz = avector3d.z();
	   
	      double d0 = MathHelper.lerp((double)partialTicks, entityIn.xOld, entityIn.getX());
	      double d1 = MathHelper.lerp((double)partialTicks, entityIn.yOld, entityIn.getY());
	      double d2 = MathHelper.lerp((double)partialTicks, entityIn.zOld, entityIn.getZ());
	      
	      double xIn = d0 - camx;
	      double yIn = d1 - camy;
	      double zIn = d2 - camz;
	  
	   
	   Vector3d vector3d = entityrenderer.getRenderOffset(entityIn, partialTicks);
	   
	   double d2x = xIn + vector3d.x();
       double d3x = yIn + vector3d.y();
       double d0x = zIn + vector3d.z();
       
       net.minecraftforge.client.event.EntityViewRenderEvent.CameraSetup cameraSetup 
       = net.minecraftforge.client.ForgeHooksClient.onCameraSetup(mc.gameRenderer, activeRenderInfoIn, partialTicks);
       activeRenderInfoIn.setAnglesInternal(cameraSetup.getYaw(), cameraSetup.getPitch());
       GL11.glRotatef(cameraSetup.getRoll(), 0.0F, 0.0F, 1.0F);
       GL11.glRotatef(activeRenderInfoIn.getXRot(), 1.0F, 0.0F, 0.0F);
       GL11.glRotatef(activeRenderInfoIn.getYRot() + 180.0F, 0.0F, 1.0F, 0.0F);
       GL11.glTranslatef((float) xIn, (float) yIn, (float) zIn);
     //  matrixStackIn.translate(d2x, d3x, d0x);
	   
		GL11.glRotatef(180F, 0.0F, 1.0F, 0.0F);
		GL11.glEnable(GL12.GL_RESCALE_NORMAL);
		
//		GlStateManager.enableLighting();
		GL11.glEnable(GL11.GL_LIGHTING);
		//GL11.glEnable(GL11.GL_LIGHT1);
		GL11.glEnable(GL11.GL_COLOR_MATERIAL);
		
		BlockPos blockpos = new BlockPos(entityIn.getLightProbePosition(partialTicks));
		float light_level = entityIn.getCommandSenderWorld().getBrightness(blockpos);
		
		if(entityIn.deathTime > 0) {
			GL11.glColor4f(0.1F, 0.1F, 0.1F, 1F);
		}
		else {
			 GL11.glColor3f(light_level, light_level, light_level);
		}
		
		GL11.glRotatef(180.0F - entityYaw, 0.0F, 1.0F, 0.0F);
		MODEL.renderPart("body");
		//tankk.renderPart("mat2");
		{
			GL11.glPushMatrix();
			GL11.glTranslatef(0F, 0.8F, 0.95F);
			if (entityIn.canBeSteered() && entityIn.getControllingPassenger() != null)
			{
				if(entityIn.getControllingPassenger() instanceof PlayerEntity)
				{
					PlayerEntity entitylivingbase = (PlayerEntity) entityIn.getControllingPassenger();
					if (entitylivingbase.xxa < 0.0F) {
						GL11.glRotatef((180.0F - entityIn.yBodyRot - 30) - (180.0F - entityYaw), 0.0F, 1.0F, 0.0F);
					}
					if (entitylivingbase.xxa > 0.0F) {
						GL11.glRotatef((180.0F - entityIn.yBodyRot + 30) - (180.0F - entityYaw), 0.0F, 1.0F, 0.0F);
					}
					
				}
			}
			GL11.glTranslatef(0F, -0.8F, -0.95F);
			MODEL.renderPart("hand");
			
			GL11.glTranslatef(0F, 0.375F, 1.1F);
			//GL11.glRotatef((float) entity.thpera, 1.0F, 0.0F, 0.0F);
			GL11.glTranslatef(0F, -0.375F, -1.1F);
			MODEL.renderPart("wheel_1");
			GL11.glPopMatrix();
		}
		{
			GL11.glPushMatrix();
			GL11.glTranslatef(0F, 0.375F, -0.8F);
			//GL11.glRotatef((float) entity.thpera, 1.0F, 0.0F, 0.0F);
			GL11.glTranslatef(0F, -0.375F, 0.8F);
			MODEL.renderPart("wheel_2");
			GL11.glPopMatrix();
		}
		GL11.glColor4f(1F, 1F, 1F, 1F);
		
//		GL11.glDisable(GL11.GL_LIGHT1);
//	    GL11.glDisable(GL11.GL_LIGHTING);
//	    GlStateManager.disableLighting();
		
		GL11.glDisable(GL12.GL_RESCALE_NORMAL);
		GL11.glPopMatrix();
		
		
		
	   matrixStackIn.popPose();
	   
   }


    */

	public void render(EntityKettenkrad p_113929_, float p_113930_, float p_113931_, PoseStack p_113932_, MultiBufferSource p_113933_, int p_113934_) {
		p_113932_.pushPose();
		//p_113932_.translate(0.0D, 0.375D, 0.0D);

		p_113932_.mulPose(Axis.YP.rotationDegrees(180.0F));

		p_113932_.mulPose(Axis.YP.rotationDegrees(180.0F - p_113930_));
		VertexConsumer vertexconsumer = p_113933_.getBuffer(RenderTypeKettenkrad.gunrender(getTextureLocation(p_113929_)));


		MODEL.renderPart(vertexconsumer,p_113932_,"body");
		{
			p_113932_.pushPose();
			p_113932_.translate(0F, 0.8F, 0.95F);
			if (p_113929_.canBeControlledByRider() && p_113929_.getControllingPassenger() != null)
			{
				if(p_113929_.getControllingPassenger() instanceof Player)
				{
					Player entitylivingbase = (Player) p_113929_.getControllingPassenger();
					if (entitylivingbase.xxa < 0.0F) {
						p_113932_.mulPose(Axis.YP.rotationDegrees((180.0F - p_113929_.yBodyRot - 30) - (180.0F - p_113930_)));
					}
					if (entitylivingbase.xxa > 0.0F) {
						p_113932_.mulPose(Axis.YP.rotationDegrees((180.0F - p_113929_.yBodyRot + 30) - (180.0F - p_113930_)));
					}

				}
			}
			p_113932_.translate(0F, -0.8F, -0.95F);
			MODEL.renderPart(vertexconsumer,p_113932_,"hand");

			p_113932_.translate(0F, 0.375F, 1.1F);
			//GL11.glRotatef((float) entity.thpera, 1.0F, 0.0F, 0.0F);
			p_113932_.translate(0F, -0.375F, -1.1F);
			MODEL.renderPart(vertexconsumer,p_113932_,"wheel_1");
			p_113932_.popPose();
		}
		{
			p_113932_.pushPose();
			p_113932_.translate(0F, 0.375F, -0.8F);
			//GL11.glRotatef((float) entity.thpera, 1.0F, 0.0F, 0.0F);
			p_113932_.translate(0F, -0.375F, 0.8F);
			MODEL.renderPart(vertexconsumer,p_113932_,"wheel_2");
			p_113932_.popPose();
		}


		p_113932_.popPose();
		super.render(p_113929_, p_113930_, p_113931_, p_113932_, p_113933_, p_113934_);
	}


   /**
    * Returns the location of an entity's texture.
    */
   public ResourceLocation getTextureLocation(EntityKettenkrad entity) {
      return TEXTURES;
   }
}
