package kettenkrad;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;


import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;


public class ItemKettenkrad extends Item {

   public ItemKettenkrad(Item.Properties builder) {
      super(builder);
   }

   public void spawnCreature(Level worldIn, Player playerIn, double par4, double par5, double par6)
   {
	   if (worldIn.isClientSide) return;
	   
	   
		{
			++par5;
			int var12 = Mth.floor((double) (playerIn.getYRot() * 4.0F / 360.0F) + 0.5D) & 3;
			EntityKettenkrad ent = new EntityKettenkrad(mod_Kettenkrad.ENTITY_KETTENKRAD.get(), worldIn);
			ent.moveTo(par4 + 0.5, par5, par6 + 0.5, var12, 0.0F);
			worldIn.addFreshEntity(ent);
		} 
   }
   
   /**
    * Called when this item is used when targetting a Block
    */
   public InteractionResult useOn(UseOnContext context) {
      Level world = context.getLevel();
      if (world.isClientSide) {
         return InteractionResult.SUCCESS;
      } else {
         ItemStack itemstack = context.getItemInHand();
     	if (!context.getPlayer().getAbilities().instabuild)
        {
     		itemstack.shrink(1);
        }
     	BlockPos pos = context.getClickedPos();
    	spawnCreature(world, context.getPlayer(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());

         
         return InteractionResult.SUCCESS;
      }
   }

   /**
    * Called to trigger the item's "innate" right click behavior. To handle when this item is used on a Block, see
    * .
    */
   public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
      ItemStack itemstack = playerIn.getItemInHand(handIn);
      if (worldIn.isClientSide) {
         return InteractionResultHolder.pass(itemstack);
      } else {
          HitResult hitresult = getPlayerPOVHitResult(worldIn, playerIn, ClipContext.Fluid.SOURCE_ONLY);
         if (hitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.success(itemstack);
         } else {
             BlockHitResult blockraytraceresult = (BlockHitResult)hitresult;
            BlockPos blockpos = blockraytraceresult.getBlockPos();
            if (!(worldIn.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
               return InteractionResultHolder.pass(itemstack);
            } else if (worldIn.mayInteract(playerIn, blockpos) && playerIn.mayUseItemAt(blockpos, blockraytraceresult.getDirection(), itemstack)) {
            	spawnCreature(worldIn, playerIn, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ());
            	 if (!playerIn.getAbilities().instabuild) {
                     itemstack.shrink(1);
                  }

                  playerIn.awardStat(Stats.ITEM_USED.get(this));
                  return InteractionResultHolder.success(itemstack);
            } else {
               return InteractionResultHolder.fail(itemstack);
            }
         }
      }
   }

   
}