package kettenkrad;

import java.util.List;

import javax.annotation.Nullable;


import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.*;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class EntityKettenkrad extends Animal {

	public EntityKettenkrad(EntityType<? extends Animal> p_i50250_1_, Level p_i50250_2_) {
		super(p_i50250_1_, p_i50250_2_);
	}


	/*public EntityKettenkrad(PlayMessages.SpawnEntity packet, Level worldIn) {
		super(mod_Kettenkrad.ENTITY_KETTENKRAD.get(), worldIn);
	}*/

	/*public Packet<?> getAddEntityPacket() {
		return NetworkHooks.getEntitySpawningPacket(this);
	}*/

	public EntityKettenkrad getBreedOffspring(ServerLevel p_149001_, AgeableMob p_149002_) {
		return mod_Kettenkrad.ENTITY_KETTENKRAD.get().create(p_149001_);
	}

	protected void registerGoals() {
	}

	public static AttributeSupplier.Builder createAttributes() {
		return Mob.createMobAttributes()
				.add(Attributes.MAX_HEALTH, 100.0D)
				.add(Attributes.MOVEMENT_SPEED, (double) 0.2F)
				.add(Attributes.KNOCKBACK_RESISTANCE, (double) 10.0F);
	}

	public double getPassengersRidingOffset() {
		return 0.6D;//0.12D
	}

	/**
	 * returns true if all the conditions for steering the entity are met. For pigs, this is true if it is being ridden
	 * by a player and the player is holding a carrot-on-a-stick
	 */
	public boolean canBeControlledByRider() {
		Entity entity = this.getControllingPassenger();
		if (!(entity instanceof Player)) {
			return false;
		} else {
			//PlayerEntity playerentity = (PlayerEntity)entity;
			return true;
		}
	}

	protected boolean canFitPassenger(Entity passenger) {
		return this.getPassengers().size() < 2;
	}



	/**
	 * Returns true if other Entities should be prevented from moving through this Entity.
	 */
 /*  public boolean canBeCollidedWith() {
      return !this.removed;
   }*/




	/**
	 * For vehicles, the first passenger is generally considered the controller and "drives" the vehicle. For example,
	 * Pigs, Horses, and Boats are generally "steered" by the controlling passenger.
	 */
	@Nullable
	public LivingEntity getControllingPassenger() {
		Entity entity = this.getFirstPassenger();
		LivingEntity livingentity1;
		if (entity instanceof LivingEntity livingentity) {
			livingentity1 = livingentity;
		} else {
			livingentity1 = super.getControllingPassenger();
		}

		return livingentity1;
	}


	protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
		return SoundEvents.IRON_GOLEM_HURT;
	}

	protected SoundEvent getDeathSound() {
		return SoundEvents.IRON_GOLEM_DEATH;
	}

	public boolean onLivingFall(float distance, float damageMultiplier) {
		return false;
	}

	public boolean canDespawn(double distanceToClosestPlayer) {
		return false;
	}

	/**
	 * Returns the volume for the sounds this mob makes.
	 */
	protected float getSoundVolume() {
		return 0.4F;
	}

	public InteractionResult mobInteract(Player p_29489_, InteractionHand p_29490_) {
		if (p_29489_.isCrouching()) {
			if (!this.level().isClientSide)
			{
				this.spawnAtLocation(new ItemStack(mod_Kettenkrad.item_kettenkrad.get()), 0.0F);
				this.discard();
			}
			return InteractionResult.PASS;
		}
		else
		if (!this.isVehicle() && !p_29489_.isSecondaryUseActive()) {
			if (!this.level().isClientSide) {
				p_29489_.startRiding(this);
			}

			return InteractionResult.sidedSuccess(this.level().isClientSide);
		}else{
			return InteractionResult.PASS;
		}
	}


	/**
	 * Applies a velocity to the entities, to push them away from eachother.
	 */
	   /*public void applyEntityCollision(Entity entityIn) {
	      if (entityIn instanceof EntityKettenkrad) {
	         if (entityIn.getBoundingBox().minY < this.getBoundingBox().maxY) {
	            super.applyEntityCollision(entityIn);
	         }
	      } else if (entityIn.getBoundingBox().minY <= this.getBoundingBox().minY) {
	         super.applyEntityCollision(entityIn);
	      }

	   }*/

	public float tro = 0;

	public float maxUpStep() {
		return 1.5F;
	}

	public void tick() {
		super.tick();
		float f1 = this.yHeadRot * (2 * (float) Math.PI / 360);
		float sp = 0.04F;

		//this.maxUpStep() = 1.5F;
		Vec3 motions = this.getDeltaMovement();
		double x = motions.x();
		double y = motions.y();
		double z = motions.z();
		/*if (this.horizontalCollision) {
			x -= Mth.sin(f1) * sp * tro * 2;
			z += Mth.cos(f1) * sp * tro * 2;
//			System.out.println("onGround");
		} else */
		{
			x -= Mth.sin(f1) * sp * tro * 2;
			z += Mth.cos(f1) * sp * tro * 2;
		}
		// x -= MathHelper.sin(f1) * sp * tro;
		// z += MathHelper.cos(f1) * sp * tro;

		//	if(!this.world.isRemote)
		/*if (this.isControlledByLocalInstance())
		{
			this.setDeltaMovement(x, y, z);
			//this.move(MoverType.PLAYER, new Vector3d(x, y, z));
	//		this.move(MoverType.PLAYER, this.getMotion());
		}
		else {
			 this.setDeltaMovement(Vector3d.ZERO);
		}*/






		if (tro != 0) {
			if (tro > 0) {
				tro = tro - 0.05F;
			}
			if (tro < 0) {
				tro = tro + 0.05F;
			}
			if (tro > 0 && tro < 1) {
				x = 0;
				z = 0;
			}
			if (tro < 0 && tro > -0.5F) {
				x = 0;
				z = 0;
			}
		}


		if (tro < -1 || tro > 1) {
			// this.playSound(KKSoundEvent.TANK, 5.0F,1F);
		}

		if (this.canBeControlledByRider() && this.getControllingPassenger() != null) {
			if (this.getControllingPassenger() instanceof Player) {
				Player entitylivingbase = (Player) this.getControllingPassenger();
				float turnspeed = 5;
				if (entitylivingbase.zza > 0.0F) {
					if (tro < 5F) {
						tro = tro + 0.2F;
					}
				}
				if (entitylivingbase.zza < 0.0F) {
					if (tro > -2F) {
						tro = tro - 0.15F;
					}
				}
				// if(tro != 0)
				{
					if (entitylivingbase.xxa < 0.0F) {
						this.yHeadRot = this.yHeadRot + turnspeed;
						this.setYRot(this.getYRot() + turnspeed);
						this.yBodyRot = this.yBodyRot + turnspeed;
						this.yRotO = this.yRotO + turnspeed;
						this.yHeadRotO = this.yHeadRotO + turnspeed;
					}
					if (entitylivingbase.xxa > 0.0F) {
						this.yHeadRot = this.yHeadRot - turnspeed;
						this.setYRot(this.getYRot() - turnspeed);
						this.yBodyRot = this.yBodyRot - turnspeed;
						this.yRotO = this.yRotO - turnspeed;
						this.yHeadRotO = this.yHeadRotO - turnspeed;
					}
				}

			} // player
		}

		//this.setDeltaMovement(x, y, z);
		this.move(MoverType.PLAYER, new Vec3(x, y, z));

		/**/
	}

	/**
	 * Applies this entity's orientation (pitch/yaw) to another entity. Used to update passenger orientation.
	 */
	@OnlyIn(Dist.CLIENT)
	public void applyOrientationToEntity(Entity entityToUpdate) {
		this.clampRotation(entityToUpdate);
	}

	float deltaRotation = 0;

	protected Vector3f getPassengerAttachmentPoint(Entity p_299070_, EntityDimensions p_299244_, float p_298802_) {
		float f = this.getSinglePassengerXOffset();
		if (this.getPassengers().size() > 1) {
			int i = this.getPassengers().indexOf(p_299070_);
			if (i == 0) {
				f = 0.2F;
			} else {
				f = -0.6F;
			}

			if (p_299070_ instanceof Animal) {
				f += 0.2F;
			}
		}

		return new Vector3f(0.0F, p_299244_.height / 3.0F, f);
	}

	protected float getSinglePassengerXOffset() {
		return 0.0F;
	}

	/**
	 * Applies this boat's yaw to the given entity. Used to update the orientation
	 * of its passenger.
	 */
	protected void clampRotation(Entity p_38322_) {
		p_38322_.setYBodyRot(this.getYRot());
		float f = Mth.wrapDegrees(p_38322_.getYRot() - this.getYRot());
		float f1 = Mth.clamp(f, -105.0F, 105.0F);
		p_38322_.yRotO += f1 - f;
		p_38322_.setYRot(p_38322_.getYRot() + f1 - f);
		p_38322_.setYHeadRot(p_38322_.getYRot());
	}

	protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
		return 1.3F;
	}


/*
	@Override
	public EntityKettenkrad getBreedOffspring(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
		return mod_Kettenkrad.ENTITY_KETTENKRAD.create(p_241840_1_);
	}*/
}
