// priority: 0

// Visit the wiki for more info - https://kubejs.com/

console.info('Hello, World! (Loaded startup scripts)')

StartupEvents.registry("item", event => {
  event.create("ruby")
  event.create("dirt_ball")
  event.create("old_book")
  event.create("sand_ball")
  event.create("living_matter")
  event.create("saltpeter")
  event.create("inspiration")
  event.create("mixed_ore")
  event.create("mixed_mineral")
  event.create("mirage")
  event.create("steel_ingot")
  event.create("pre_special_steel_sheet", "create:sequenced_assembly")
  event.create("pre_steel_ingot", "create:sequenced_assembly")
  event.create("pre_military_sheet", "create:sequenced_assembly")
  event.create("military_sheet")
  event.create("license")
  event.create("brick")
  event.create("string_extractor")
  event.create("solid_food")
  event.create("magnet")
  event.create("magnet_bucket").maxDamage(48)
  event.create("steel_ball")
  event.create("steel_rings")
  event.create("bearing_mechanism")
  event.create('magic_cigarette', 'basic')
    .useDuration(itemstack => 100)
    .use((level, player, hand) => true)
    .unstackable()
    .finishUsing((itemstack, level, entity) => {
        if (entity && entity.potionEffects) {
            entity.potionEffects.add("minecraft:mining_fatigue", 60 * 20, 0, false, false)
            entity.potionEffects.add("youkaisfeasts:drunk", 60 * 20, 4, false, false)
            entity.potionEffects.add("minecraft:nausea", 60 * 20, 4, false, false)
            if (entity.isPlayer()) {
                entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run damage @p 16 minecraft:generic`)
                entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run mentalhealth add @p -10`)
                entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run stopsound @p player`)
                entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run stopsound @p record`)
                entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run playsound kubejs:overdose player @p`)
                entity.server.scheduleInTicks(20, () => {
                  entity.server.runCommandSilent(`/execute positioned ${entity.x} ${entity.y} ${entity.z} run emotion set @p 6`)
                })
            }
            itemstack.shrink(1)
        }
    })
})

StartupEvents.registry("block", event => {
  event.create("milled_coarse_dirt")
  event.create("hot_sandbag")
    .textureAll("kubejs:block/hot_sandbag_side")
    .textureSide("up", "kubejs:block/hot_sandbag_top")
    .textureSide("down", "kubejs:block/hot_sandbag_bottom")
    .randomTick(event => {
      let block = event.block
      let around = [block.getDown()]
      if (Math.random() < 0.12) {
        for (let i = 0; i < around.length; i++) {
          if (around[i].hasTag("farmersdelight:heat_sources")) {
            return;
          }
          else {
            block.set("kubejs:sandbag")
            event.server.runCommandSilent(`/playsound minecraft:block.lava.extinguish block @a ${event.block.x} ${event.block.y} ${event.block.z} 4`)
            return;
          }
        }

      }
    }
    )
  event.create("sandbag")
    .textureAll("kubejs:block/sandbag_side")
    .textureSide("up", "kubejs:block/sandbag_top")
    .textureSide("down", "kubejs:block/sandbag_bottom")
    .randomTick(event => {
      let block = event.block
      let around = [block.getDown()]
      for (let i = 0; i < around.length; i++) {
        if (around[i].hasTag("farmersdelight:heat_sources")) {
          block.set("kubejs:hot_sandbag")
          return;
        }
      }
    }
    )
})
