ServerEvents.recipes((event) => {
  //使鼓风机能够熔炼出混杂的合金
  event.remove({ id: 'crafttweaker:mineral_mixed' })
  //修改kettenkrad的配方
  event.remove({ mod: 'kettenkrad' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "ABA",
      "A A"
    ],
    key: {
      A: [
        {
          item: "create:iron_sheet",
        },
      ],
      B: [
        {
          item: "minecraft:minecart",
        },
      ],
    },
    result: {
      item: "kettenkrad:item_kettenkrad",
    },
    acceptMirrored: true,
  });
  //沙砾洗涤配方修改
  event.remove({ id: 'create:splashing/gravel' })
  event.recipes.createSplashing([
    'minecraft:flint',
    Item.of('minecraft:iron_nugget').withChance(0.25)//概率的表示方法
  ], 'minecraft:gravel')
  //泡影缠魂获得末影珍珠
  event.recipes.createHaunting([
    Item.of('minecraft:ender_pearl').withChance(0.25),
  ], 'kubejs:mirage')
  //皮革水袋粉碎获得皮革
  event.recipes.createCrushing([
    'minecraft:leather', 'minecraft:leather', 'minecraft:leather', 'minecraft:leather', 'minecraft:leather',
  ], 'homeostatic:leather_flask')
  //粉碎下界石英矿石获得石英砂
  event.remove({ id: 'zombiekit:quartz_sand' })
  event.remove({ id: 'create:crushing/nether_quartz_ore' })
  event.custom({
    "type": "create:crushing",
    "ingredients": [
      {
        "item": "minecraft:nether_quartz_ore"
      }
    ],
    "processingTime": 350,
    "results": [
      {
        "count": 2,
        "item": "minecraft:quartz"
      },
      {
        "chance": 0.75,
        "item": "zombiekit:quartz_sand"
      },
      {
        "chance": 0.75,
        "item": "create:experience_nugget"
      },
      {
        "chance": 0.125,
        "item": "minecraft:netherrack"
      }
    ]
  })
  //滴水石块粉碎成滴水石锥
  event.recipes.createCrushing([
    'minecraft:pointed_dripstone', 'minecraft:pointed_dripstone',
  ], 'minecraft:dripstone_block')
  //凝灰岩粉碎成坚硬的“石块”
  event.remove({ id: 'create:crushing/tuff_recycling'})
  event.remove({ id: 'create:crushing/tuff'})
  event.recipes.createCrushing([
    Item.of('kubejs:mixed_ore').withChance(0.25),
  ], '#create:stone_types/tuff')
  //重写可可豆相关配方
  event.remove({ id: 'bakeries:integration/create/milling/cocoa_powder' })
  event.remove({ id: 'create:milling/cocoa_beans' })
  event.recipes.createCrushing([
    'bakeries:cocoa_powder', 'minecraft:brown_dye', Item.of('minecraft:brown_dye').withChance(0.1),
  ], 'minecraft:cocoa_beans')
  event.recipes.createMilling([
    'bakeries:cocoa_powder', 'minecraft:brown_dye', Item.of('minecraft:brown_dye').withChance(0.1),
  ], 'minecraft:cocoa_beans')
  //修改传动杆配方
  event.remove({ id: 'create:cutting/andesite_alloy' })
  event.recipes.createCutting('create:shaft', 'create:andesite_alloy')
  //切割回收掠夺者的枪
  event.recipes.createCutting(['2x kubejs:military_sheet', Item.of('tetra:forged_bolt').withChance(0.2), Item.of('tetra:forged_beam').withChance(0.2)], 'pillagers_gun:pistol')
  event.recipes.createCutting(['3x kubejs:military_sheet', Item.of('2x tetra:forged_bolt').withChance(0.2), Item.of('tetra:forged_beam').withChance(0.4)], 'pillagers_gun:shotgun')
  event.recipes.createCutting(['4x kubejs:military_sheet', Item.of('2x tetra:forged_bolt').withChance(0.25), Item.of('tetra:forged_beam').withChance(0.5)], 'pillagers_gun:assault_rifle')
  event.recipes.createCutting(['4x kubejs:military_sheet', Item.of('2x tetra:forged_bolt').withChance(0.25), Item.of('tetra:forged_beam').withChance(0.5)], 'pillagers_gun:snipers_rifle')
  //添加火药配方
  event.recipes.createCompacting('2x minecraft:gunpowder', ['3x minecraft:sugar', '3x kubejs:saltpeter'])
  //修改傀儡胚料配方
  event.remove({ id: 'modulargolems:metal_golem_template' })
  event.custom({
    type: "create:filling",
    ingredients: [
      {
        item: "minecraft:clay"
      },
      {
        amount: 500,
        fluid: "create:potion",
        nbt: { Potion: "minecraft:healing" }
      }
    ],
    results: [
      {
        item: "modulargolems:metal_golem_template"
      }
    ]
  })
  event.recipes.createCompacting('modulargolems:metal_golem_template', ['16x kubejs:living_matter', 'minecraft:clay'])
  //岩浆注入圆石变成岩浆块
  event.custom({
    type: "create:filling",
    ingredients: [
      {
        item: "minecraft:cobblestone"
      },
      {
        amount: 1000,
        fluid: "minecraft:lava",
        nbt: {}
      }
    ],
    results: [
      {
        item: "minecraft:magma_block"
      }
    ]
  })
  //修改机身的配方
  event.remove({ id: 'immersive_aircraft:hull' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "AAAAA",
      "BBBBB",
      "     ",
      "BBBBB",
      "AAAAA"
    ],
    key: {
      A: [
        {
          item: "create:andesite_casing",
        },
      ],
      B: [
        {
          item: "zombiekit:plastics",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:hull",
    },
    acceptMirrored: true,
  });
  //修改螺旋桨的配方
  event.remove({ id: 'immersive_aircraft:propeller' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "A AAA",
      "A A  ",
      "AABAA",
      "  A A",
      "AAA A"
    ],
    key: {
      A: [
        {
          item: "create:iron_sheet",
        },
      ],
      B: [
        {
          item: "create:propeller",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:propeller",
    },
    acceptMirrored: true,
  });
  //修改锅炉的配方
  event.remove({ id: 'immersive_aircraft:boiler' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "AAAAA",
      "ABBBA",
      "ABDBA",
      "ABCBA"
    ],
    key: {
      A: [
        {
          item: "create:brass_sheet",
        },
      ],
      B: [
        {
          item: "create:sturdy_sheet",
        },
      ],
      C: [
        {
          item: "create:blaze_burner",
        },
      ],
      D: [
        {
          item: "create:schedule",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:boiler",
    },
    acceptMirrored: true,
  });
  //修改矿车装配站的配方
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "AABAA",
      "ADDDA",
      "ACDCA",
      "A C A"
    ],
    key: {
      A: [
        {
          item: "create:sturdy_sheet",
        },
      ],
      B: [
        {
          item: "born_in_chaos_v1:dark_metal_ingot",
        },
      ],
      C: [
        {
          item: "create:precision_mechanism",
        },
      ],
      D: [
        {
          item: "create:electron_tube",
        },
      ],
    },
    result: {
      item: "create:cart_assembler",
    },
    acceptMirrored: true,
  });
  //修改固定旋翼机的配方
  event.remove({ id: 'immersive_aircraft:gyrodyne' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  DA  ",
      "  DA  ",
      "  DA  ",
      "AAAABC",
      "  DA  ",
      "  DA  ",
      "  DA  "
    ],
    key: {
      A: [
        {
          item: "immersive_aircraft:hull",
        },
      ],
      B: [
        {
          item: "create:controls",
        },
      ],
      C: [
        {
          item: "create:propeller",
        },
      ],
      D: [
        {
          item: "immersive_aircraft:sail",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:gyrodyne",
    },
    acceptMirrored: true,
  });
  //修改双翼机的配方
  event.remove({ id: 'immersive_aircraft:biplane' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AA  ",
      "  AA  ",
      "  AA  ",
      "AADABC",
      "  AA  ",
      "  AA  ",
      "  AA  "
    ],
    key: {
      A: [
        {
          item: "immersive_aircraft:hull",
        },
      ],
      B: [
        {
          item: "create:controls",
        },
      ],
      C: [
        {
          item: "create:propeller",
        },
      ],
      D: [
        {
          item: "immersive_aircraft:engine",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:biplane",
    },
    acceptMirrored: true,
  });
  //修改飞艇的配方
  event.custom({
    type: "create:mechanical_crafting",
    pattern: ["SSSSS", " ~ ~ ", " H_EP", " HHH "],
    key: {
      H: [
        {
          item: "immersive_aircraft:hull",
        },
      ],
      E: [
        {
          item: "immersive_aircraft:engine",
        },
      ],
      P: [
        {
          item: "create:propeller",
        },
      ],
      S: [
        {
          item: "immersive_aircraft:sail",
        },
      ],
      "~": [
        {
          item: "minecraft:string",
        },
      ],
      _: [
        {
          item: "create:red_seat",
        },
      ],
    },
    result: {
      item: "immersive_aircraft:airship",
    },
    acceptMirrored: true,
  });
  //修改车身的配方
  event.remove({ id: 'car:oak_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:oak_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:oak_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:spruce_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:spruce_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:spruce_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:birch_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:birch_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:birch_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:jungle_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:jungle_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:jungle_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:acacia_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:acacia_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:acacia_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:dark_oak_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:dark_oak_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:dark_oak_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:crimson_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:crimson_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:crimson_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:warped_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAA ",
      "  ABBA ",
      "AAAAAAA",
      "AAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:warped_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:warped_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_oak_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:oak_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_oak_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_spruce_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:spruce_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_spruce_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_birch_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:birch_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_birch_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_jungle_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:jungle_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_jungle_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_acacia_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:acacia_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_acacia_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_dark_oak_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:dark_oak_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_dark_oak_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_crimson_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:crimson_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_crimson_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:big_warped_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:warped_planks",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
    },
    result: {
      item: "car:big_warped_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:white_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:white_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:white_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:orange_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:orange_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:orange_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:magenta_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:magenta_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:magenta_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_blue_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:light_blue_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:yellow_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:yellow_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:yellow_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:lime_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:lime_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:lime_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:pink_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:pink_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:pink_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:gray_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:gray_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_gray_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:light_gray_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:cyan_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:cyan_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:cyan_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:purple_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:purple_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:purple_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:blue_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:blue_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:brown_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:brown_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:brown_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:red_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:red_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:red_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:black_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:black_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:black_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:green_suv_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "  AAAAAA ",
      "  ABBABA ",
      "AAAAAAAAA",
      "CCCCCCCCC"
    ],
    key: {
      A: [
        {
          item: "minecraft:green_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:green_suv_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:white_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:white_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:white_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:orange_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:orange_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:orange_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:magenta_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:magenta_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:magenta_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_blue_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:light_blue_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:yellow_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:yellow_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:yellow_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:lime_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:lime_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:lime_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:pink_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:pink_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:pink_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:gray_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:gray_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_gray_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:light_gray_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:cyan_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:cyan_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:cyan_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:purple_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "      AAAA",
      "      ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:purple_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:purple_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:blue_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:blue_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:brown_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:brown_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:brown_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:red_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:red_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:red_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:black_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:black_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:black_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:green_transporter_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "     AAAA",
      "     ABBA",
      "CCCCCAAAA",
      "AAAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:green_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "kubejs:military_sheet",
        },
      ],
    },
    result: {
      item: "car:green_transporter_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:white_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:white_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:white_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:orange_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:orange_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:orange_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:magenta_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:magenta_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:magenta_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_blue_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:light_blue_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:yellow_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:yellow_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:yellow_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:lime_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:lime_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:lime_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:pink_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:pink_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:pink_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:gray_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:gray_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:light_gray_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:light_gray_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:light_gray_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:cyan_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:cyan_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:cyan_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:purple_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:purple_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:purple_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:blue_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:blue_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:blue_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:brown_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:brown_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:brown_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:red_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:red_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:red_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:black_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:black_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:black_sport_body",
    },
    acceptMirrored: true,
  });
  event.remove({ id: 'car:green_sport_body' })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "C     A ",
      "CABBBBAC",
      "AAAAAAAA"
    ],
    key: {
      A: [
        {
          item: "minecraft:green_concrete",
        },
      ],
      B: [
        {
          item: "create:framed_glass_pane",
        },
      ],
      C: [
        {
          item: "snowyspirit:glow_lights_prismatic",
        },
      ],
    },
    result: {
      item: "car:green_sport_body",
    },
    acceptMirrored: true,
  });
  //装配重机枪子弹
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('6x zombiekit:heavy_machine_gun_ammo').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:copper_sheet',
    [
      //每步的配方
      event.recipes.create.deploying('create:copper_sheet', ['create:copper_sheet', 'minecraft:gunpowder']),
      event.recipes.create.pressing('create:copper_sheet', ['create:copper_sheet']),
      event.recipes.create.cutting('create:copper_sheet', ['create:copper_sheet']),
    ]).transitionalItem('create:copper_sheet').loops(1)//分别为循环装配的物品id和装配次数
  //修改移动式存储接口的配方
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('create:portable_storage_interface').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:andesite_casing',
    [
      //每步的配方
      event.recipes.create.deploying('create:andesite_casing', ['create:andesite_casing', 'immersive_aircraft:gyroscope']),
      event.recipes.create.deploying('create:andesite_casing', ['create:andesite_casing', 'create:content_observer']),
      event.recipes.create.deploying('create:andesite_casing', ['create:andesite_casing', 'create:chute']),
    ]).transitionalItem('create:andesite_casing').loops(1)//分别为循环装配的物品id和装配次数
  //修改移动式流体接口的配方
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('create:portable_fluid_interface').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:copper_casing',
    [
      //每步的配方
      event.recipes.create.deploying('create:copper_casing', ['create:andesite_casing', 'immersive_aircraft:gyroscope']),
      event.recipes.create.deploying('create:copper_casing', ['create:andesite_casing', 'create:content_observer']),
      event.recipes.create.deploying('create:copper_casing', ['create:andesite_casing', 'create:chute']),
    ]).transitionalItem('create:copper_casing').loops(1)//分别为循环装配的物品id和装配次数
  //锻钢
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('kubejs:steel_ingot').withChance(8.0),//这个是权重
    //随机废料：
    Item.of('8x tetra:metal_scrap').withChance(2.0),
  ],
    //输入物品：
    'minecraft:iron_ingot',
    [
      //每步的配方
      event.custom({"type": "vintageimprovements:hammering","hammerBlows": 1,"ingredients": [{"item": "minecraft:iron_ingot"},{"item":"spelunkery:coal_lump"}],"results": [{"item": "minecraft:iron_ingot"}]}),
      event.recipes.create.filling('minecraft:iron_ingot', ['minecraft:iron_ingot', Fluid.of('minecraft:lava', 1000)]),
      event.custom({"type": "vintageimprovements:hammering","hammerBlows": 9,"ingredients": [{"item": "minecraft:iron_ingot"}],"results": [{"item": "minecraft:iron_ingot"}]}),
      event.recipes.create.filling('minecraft:iron_ingot', ['minecraft:iron_ingot', Fluid.of('minecraft:water', 1000)]),
    ]).transitionalItem('kubejs:pre_steel_ingot').loops(1)//分别为循环装配的物品id和装配次数
  //打造特种钢板
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('zombiekit:special_steel_sheet').withChance(8.0),//这个是权重
    //随机废料：
    Item.of('kubejs:steel_ingot').withChance(2.0),
  ],
    //输入物品：
    'kubejs:steel_ingot',
    [
      //每步的配方
      event.recipes.create.filling('kubejs:steel_ingot', ['kubejs:steel_ingot', Fluid.of('minecraft:lava', 400)]),
      event.custom({"type": "vintageimprovements:hammering","hammerBlows": 7,"ingredients": [{"item": 'kubejs:steel_ingot'},{"item":"create:sturdy_sheet"},{"item":"create:sturdy_sheet"},{"item":"create:sturdy_sheet"},{"item":"zombiekit:quartz_sand"}],"results": [{"item": 'kubejs:steel_ingot'}]}),
      event.recipes.create.filling('kubejs:steel_ingot', ['kubejs:steel_ingot', Fluid.of('minecraft:water', 400)]),
    ]).transitionalItem('kubejs:pre_special_steel_sheet').loops(5)
  //制作螺栓
  event.custom({
	"type":"vintageimprovements:turning",
	"ingredients": [{"item": "minecraft:iron_ingot"}],
	"results": [{"item": "tetra:forged_bolt","count": 1}],
	"processingTime": 200})
    //制作滚珠
  event.custom({
	"type":"vintageimprovements:turning",
	"ingredients": [{"item": "kubejs:steel_ingot"}],
	"results": [{"item": "kubejs:steel_ball","count": 1}],
	"processingTime": 800})
    //制作钢圈
  event.custom({
	"type":"vintageimprovements:turning",
	"ingredients": [{"item": "kubejs:steel_ingot"}],
	"results": [{"item": "kubejs:steel_rings","count": 1}],
	"processingTime": 200})
    //制作轴承构件
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('kubejs:bearing_mechanism').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'kubejs:steel_rings',
    [
      //每步的配方
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:steel_rings', ['kubejs:steel_rings', "kubejs:steel_ball"]),
      event.recipes.create.deploying('kubejs:bearing_mechanism', ['kubejs:steel_rings', "kubejs:steel_ball"]),
    ]).transitionalItem("kubejs:steel_rings").loops(1)
//修改风车轴承
  event.remove({ id: "create:crafting/kinetics/windmill_bearing" })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "A",
      "B",
      "C"
    ],
    key: {
      A: [{tag: "minecraft:wooden_slabs"}],
      B: [{item: "create_connected:freewheel_clutch"}],
      C: [{item: "create:shaft"}],
    },
    result: {
      item: "create:windmill_bearing"
    },
    acceptMirrored: true,
  });
//修改动力轴承
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      " A ",
      " B ",
      "ECE",
      " D "
    ],
    key: {
      A: [{tag: "minecraft:wooden_slabs"}],
      B: [{item: "kubejs:bearing_mechanism"}],
      C: [{item: "create:precision_mechanism"}],
      D: [{item: "create:shaft"}],
      E: [{item: "create:electron_tube"}],
    },
    result: {
      item: "create:mechanical_bearing"
    },
    acceptMirrored: true,
  });
//修改黄铜手部零件
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "AAAAA",
      "BBBBB",
      "CCCCC",
      "FEDEF",
      " HGH "
    ],
    key: {
      A: [{item: "create:brass_ingot"}],
      B: [{item: "vintageimprovements:small_golden_spring"}],
      C: [{item: "kubejs:steel_ball"}],
      D: [{item: "tetra:planar_stabilizer"}],
      E: [{item: "create:electron_tube"}],
      F: [{item: "kubejs:living_matter"}],
      G: [{item: "create:precision_mechanism"}],
      H: [{item: "create:brass_sheet"}],
    },
    result: {
      item: "create:brass_hand"
    },
    acceptMirrored: true,
  });
  //制作六气缸发动机
  //轧制军用板材
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('4x kubejs:military_sheet').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'kubejs:steel_ingot',
    [
      //每步的配方
      event.recipes.create.pressing('kubejs:steel_ingot', 'kubejs:steel_ingot'),
      event.recipes.create.pressing('kubejs:steel_ingot', 'kubejs:steel_ingot'),
      event.recipes.create.pressing('kubejs:steel_ingot', 'kubejs:steel_ingot'),
      event.recipes.create.pressing('kubejs:steel_ingot', 'kubejs:steel_ingot'),
      event.recipes.create.cutting('kubejs:steel_ingot', 'kubejs:steel_ingot'),
    ]).transitionalItem('kubejs:pre_military_sheet').loops(1)
  //制作三气缸发动机
  event.remove({ id: 'car:engine_3_cylinder' })
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('car:engine_3_cylinder').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:speedometer',
    [
      //每步的配方
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'create:piston_extension_pole']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'car:engine_piston']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'tetra:forged_bolt']),
    ]).transitionalItem('create:speedometer').loops(3)
  //制作六气缸发动机
  event.remove({ id: 'car:engine_6_cylinder' })
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('car:engine_6_cylinder').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:speedometer',
    [
      //每步的配方
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'minecraft:iron_block']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'create:piston_extension_pole']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'car:engine_piston']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'tetra:forged_bolt']),
    ]).transitionalItem('create:speedometer').loops(6)
  //制作卡车发动机
  event.remove({ id: 'car:engine_truck' })
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('car:engine_truck').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:speedometer',
    [
      //每步的配方
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'minecraft:iron_block']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'create:piston_extension_pole']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'create:piston_extension_pole']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'car:engine_piston']),
      event.recipes.create.deploying('create:industrial_iron_block', ['create:industrial_iron_block', 'tetra:forged_bolt']),
    ]).transitionalItem('create:speedometer').loops(3)
  //装配保险柜
  event.custom({"type": "vintageimprovements:hammering","hammerBlows": 2,"ingredients": [{"item": 'minecraft:barrel'},{"item":"create:sturdy_sheet"}],"results": [{"item": 'create:item_vault'}]}),
  event.remove({ id: 'create_connected:crafting/kinetics/item_silo' })
  //轧制压缩饼干
  event.remove({ id: 'zombiekit:compressed_biscuit' })
  event.recipes.createCompacting('3x zombiekit:compressed_biscuit', ['minecraft:sugar', 'minecraft:egg', '7x create:dough'])
  //压缩饼干打包成军用干粮
  event.recipes.createCompacting('kubejs:solid_food', ['5x zombiekit:compressed_biscuit', 'crabbersdelight:can'])
  //砂土磨成泥土
  event.recipes.createMilling("kubejs:milled_coarse_dirt", "minecraft:coarse_dirt"),
    event.recipes.createMixing("minecraft:dirt", "kubejs:milled_coarse_dirt")
  //加热熬樟脑
  event.remove({ id: 'zombiekit:camphor' }),
    event.recipes.createMixing(Item.of('zombiekit:camphor').withChance(0.5), [Fluid.water(50), '#minecraft:planks', '#minecraft:saplings', '#minecraft:leaves', 'farmersdelight:tree_bark']).heated()
  //自动加工混杂的合金
  event.recipes.createMixing(['create:crushed_raw_copper', '3x minecraft:iron_nugget', '3x minecraft:gold_nugget'], ['kubejs:mixed_mineral'])
  event.recipes.createMixing(['minecraft:copper_ingot', '3x minecraft:iron_nugget', '3x minecraft:gold_nugget'], ['kubejs:mixed_mineral']).heated()
  //布料磨成纤维
  event.recipes.createMilling(["zombiekit:fibre",
    Item.of('minecraft:string').withChance(0.5), Item.of('supplementaries:flax_seeds').withChance(0.02),
  ], "iguanatweaksreborn:cloth")
  //锤版精密构件
  event.recipes.create.sequenced_assembly([
    //成品：
    Item.of('create:precision_mechanism').withChance(1.0),//这个是权重
  ],
    //输入物品：
    'create:golden_sheet',
    [
      //每步的配方
      event.custom({"type": "vintageimprovements:hammering","hammerBlows": 1,"ingredients": [{"item": 'create:golden_sheet'},{"item":"create:cogwheel"},{"item":"vintageimprovements:small_zinc_spring"},{"item":"vintageimprovements:small_zinc_spring"}],"results": [{"item": 'create:golden_sheet'}]}),
      event.custom({"type": "vintageimprovements:hammering","hammerBlows": 800,"ingredients": [{"item": 'create:golden_sheet'},{"item":"rechiseled:iron_block_plated"}],"results": [{"item":'create:precision_mechanism'}]}),
    ]).transitionalItem('create:incomplete_precision_mechanism').loops(1)
//修改鼓风机触媒
  event.remove({ id: "create_connected:crafting/kinetics/empty_fan_catalyst" })
  event.custom({
    type: "create:mechanical_crafting",
    "pattern": [
      "ABA",
      "BCB",
      "ABA"
    ],
    key: {
      A: [{item: "create:brass_ingot"}],
      B: [{item: "minecraft:iron_bars"}],
      C: [{item: "spelunkery:rock_salt"}],
    },
    result: {
      item: "create_connected:empty_fan_catalyst"
    },
    acceptMirrored: true,
  });
})
