/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.entity.projectile;

import com.scarasol.pillagers_gun.compat.guardvillagers.GuardUseGun;
import com.scarasol.pillagers_gun.compat.recruits.RecruitUseGun;
import com.scarasol.pillagers_gun.config.CommonConfig;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Ammo
extends AbstractArrow {
    private int life = 0;

    protected Ammo(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.m_20225_(true);
        this.m_36762_(false);
        this.m_36781_(0.0);
        this.m_20242_(true);
    }

    protected Ammo(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level) {
        super(entityType, x, y, z, level);
        this.m_20225_(true);
        this.m_36762_(false);
        this.m_36781_(0.0);
        this.m_20242_(true);
    }

    protected Ammo(EntityType<? extends AbstractArrow> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
        this.m_20225_(true);
        this.m_36762_(false);
        this.m_36781_(0.0);
        this.m_20242_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_ || this.m_20072_()) {
            this.m_146870_();
        }
        if (++this.life > 200) {
            this.m_146870_();
        }
    }

    public boolean checkFriendlyFire(Entity target, Entity owner) {
        if (((Boolean)CommonConfig.FRIEND_FIRE.get()).booleanValue()) {
            return false;
        }
        if (owner instanceof Raider) {
            return target instanceof Raider || target instanceof Vex;
        }
        if (ForgeRegistries.ENTITY_TYPES.getKey((Object)owner.m_6095_()).toString().contains("guardvillagers")) {
            return GuardUseGun.checkFriendlyFire(target, owner);
        }
        if (ForgeRegistries.ENTITY_TYPES.getKey((Object)owner.m_6095_()).toString().contains("recruits")) {
            return RecruitUseGun.checkFriendlyFire(target, owner);
        }
        return !(owner instanceof Player) && owner.m_6095_() == target.m_6095_() || owner.m_7307_(owner);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockState blockState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        if (blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:glass"))) || blockState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("forge:glass_panes")))) {
            this.m_9236_().m_46953_(blockHitResult.m_82425_(), false, (Entity)this);
        } else {
            this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("pillagers_gun:bullet_hit_ground")), 0.1f, 1.0f);
        }
    }
}

