/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.TagManager;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.platform.Services;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;

public class WetnessHelper {
    public static void updateWetnessInfo(ServerPlayer sp, float moistureLevel, boolean increase) {
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL || sp.m_21023_(MobEffects.f_19608_)) {
            return;
        }
        Services.PLATFORM.getWetnessCapability((Player)sp).ifPresent(data -> {
            WetnessInfo wetnessInfo = new WetnessInfo(data.getWetnessLevel(), data.getMoistureLevel());
            AtomicInteger waterproofing = new AtomicInteger();
            sp.m_6168_().forEach(armor -> {
                CompoundTag tags = armor.m_41783_();
                if (tags != null && tags.m_128441_("waterproof") || armor.m_204117_(TagManager.Items.WATERPROOF_ARMOR)) {
                    waterproofing.addAndGet(5);
                }
            });
            if (increase) {
                wetnessInfo.increaseMoisture(moistureLevel, waterproofing.get());
            } else {
                wetnessInfo.decreaseMoisture(moistureLevel);
            }
            data.setWetnessData(wetnessInfo);
            Services.PLATFORM.syncWetnessData(sp, wetnessInfo);
        });
    }

    public static int getWetness(ServerPlayer sp) {
        AtomicInteger wetness = new AtomicInteger();
        Services.PLATFORM.getWetnessCapability((Player)sp).ifPresent(data -> wetness.set(data.getWetnessLevel()));
        return wetness.get();
    }
}

