/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.Homeostatic;
import homeostatic.network.ForgeDrinkWater;
import homeostatic.network.ForgeTemperatureData;
import homeostatic.network.ForgeThermometerData;
import homeostatic.network.ForgeWaterData;
import homeostatic.network.ForgeWetnessData;
import homeostatic.network.IData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class NetworkHandler {
    private static SimpleChannel instance;
    public static final String PROTOCOL_VERSION = "1";

    public static void init() {
        int id = 0;
        if (instance != null) {
            return;
        }
        instance = NetworkRegistry.newSimpleChannel((ResourceLocation)Homeostatic.loc("main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        NetworkHandler.registerMessage(id++, ForgeDrinkWater.class, ForgeDrinkWater::new);
        NetworkHandler.registerMessage(id++, ForgeTemperatureData.class, ForgeTemperatureData::new);
        NetworkHandler.registerMessage(id++, ForgeThermometerData.class, ForgeThermometerData::new);
        NetworkHandler.registerMessage(id++, ForgeWaterData.class, ForgeWaterData::new);
        NetworkHandler.registerMessage(id++, ForgeWetnessData.class, ForgeWetnessData::new);
    }

    public static SimpleChannel getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Network channel is not initialized. Call NetworkHandler.init() first.");
        }
        return instance;
    }

    private static <T extends IData> void registerMessage(int idx, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        NetworkHandler.getInstance().registerMessage(idx, type, IData::toBytes, decoder, (msg, ctx) -> {
            msg.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }
}

