/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.temperature.BodyTemperature;
import homeostatic.network.IData;
import homeostatic.network.TemperatureData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ForgeTemperatureData
implements IData {
    private final TemperatureData temperatureData;

    public ForgeTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.temperatureData = new TemperatureData(localTemperature, bodyTemperature.getSkinTemperature(), bodyTemperature.getCoreTemperature());
    }

    public ForgeTemperatureData(FriendlyByteBuf buf) {
        this.temperatureData = new TemperatureData(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        this.temperatureData.toBytes(buf);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> this.temperatureData.process((Player)Minecraft.m_91087_().f_91074_, this.temperatureData));
        }
    }
}

