/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.Homeostatic;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.OverlayManager;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="homeostatic", value={Dist.CLIENT})
public class GameOverlayEventHandler {
    private final OverlayManager overlayManager = OverlayManager.INSTANCE;
    public static final GameOverlayEventHandler INSTANCE = new GameOverlayEventHandler();
    private static boolean enabled = false;
    private final IGuiOverlay OVERLAY;
    private final IGuiOverlay WATER_LEVEL_OVERLAY;
    private final IGuiOverlay TEMPERATURE_OVERLAY;
    private final IGuiOverlay ENHANCED_VISUALS_OVERLAY;
    private final IGuiOverlay HYDRATION_OVERLAY;

    public GameOverlayEventHandler() {
        Minecraft mc = Minecraft.m_91087_();
        this.OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (enabled && ConfigHandler.Common.debugEnabled() && !mc.f_91066_.f_92063_) {
                this.overlayManager.renderOverlay(guiGraphics);
            }
        };
        this.WATER_LEVEL_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                this.overlayManager.renderWaterOverlay(guiGraphics, gui.rightHeight);
            }
        };
        this.TEMPERATURE_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                this.overlayManager.renderTemperatureOverlay(guiGraphics);
            }
        };
        this.ENHANCED_VISUALS_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                this.overlayManager.renderEnhancedVisualsOverlay(guiGraphics);
            }
        };
        this.HYDRATION_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                this.overlayManager.renderHydrationOverlay(guiGraphics, gui.rightHeight);
            }
        };
    }

    @SubscribeEvent
    public void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("overlay", GameOverlayEventHandler.INSTANCE.OVERLAY);
        event.registerAbove(VanillaGuiOverlay.MOUNT_HEALTH.id(), "water_level", GameOverlayEventHandler.INSTANCE.WATER_LEVEL_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.MOUNT_HEALTH.id(), "temperature", GameOverlayEventHandler.INSTANCE.TEMPERATURE_OVERLAY);
        event.registerBelowAll("visuals", GameOverlayEventHandler.INSTANCE.ENHANCED_VISUALS_OVERLAY);
        event.registerAbove(Homeostatic.loc("water_level"), "hydration", GameOverlayEventHandler.INSTANCE.HYDRATION_OVERLAY);
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onRegisterOverlays);
    }
}

