/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.integration.patchouli;

import homeostatic.Homeostatic;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.data.integration.patchouli.CustomRecipePageBuilder;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import xyz.brassgoggledcoders.patchouliprovider.AbstractPageBuilder;
import xyz.brassgoggledcoders.patchouliprovider.BookBuilder;
import xyz.brassgoggledcoders.patchouliprovider.CategoryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.EntryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.PatchouliBookProvider;
import xyz.brassgoggledcoders.patchouliprovider.page.CampfirePageBuilder;
import xyz.brassgoggledcoders.patchouliprovider.page.CraftingPageBuilder;
import xyz.brassgoggledcoders.patchouliprovider.page.ImagePageBuilder;
import xyz.brassgoggledcoders.patchouliprovider.page.SmeltingPageBuilder;

public class HomeostaticBookProvider
extends PatchouliBookProvider {
    private final String translationLoc = "info.homeostatic.book";
    private int categorySortNum = -1;
    private int entrySortNum = -1;

    public HomeostaticBookProvider(@NotNull PackOutput packOutput) {
        super(packOutput, "homeostatic", "en_us");
    }

    protected void addBooks(Consumer<BookBuilder> consumer) {
        BookBuilder bookBuilder = this.createBookBuilder("book", "info.homeostatic.book", this.prefix("intro")).setSubtitle(this.prefix("subtitle")).setCustomBookItem(new ItemStack((ItemLike)HomeostaticItems.BOOK)).setCreativeTab("homeostatic.items").setModel("homeostatic:book").setDontGenerateBook(true).setShowProgress(false).setUseBlockyFont(false).setI18n(true).setUseResourcePack(true);
        bookBuilder = this.addGameplay(bookBuilder);
        bookBuilder = this.addEducation(bookBuilder);
        bookBuilder.build(consumer);
    }

    private BookBuilder addGameplay(BookBuilder bookBuilder) {
        CategoryBuilder category = bookBuilder.addCategory("gameplay", this.prefix("gameplay.name"), this.prefix("gameplay.desc"), new ItemStack((ItemLike)Items.f_42383_)).setSortnum(Integer.valueOf(this.categorySortNum++));
        EntryBuilder gameplayEnvironmentEntry = category.addEntry("gameplay/environment", this.prefix("gameplay.environment.name"), new ItemStack((ItemLike)Items.f_42781_)).setSortnum(this.entrySortNum++);
        gameplayEnvironmentEntry.addImagePage(this.bookImage("normal_outside")).setTitle(this.prefix("gameplay.environment.title")).setText(this.prefix("gameplay.environment.intro")).build().addTextPage(this.prefix("gameplay.environment.details")).build();
        EntryBuilder gameplayBodyTempEntry = category.addEntry("gameplay/body_temp", this.prefix("gameplay.body_temp.name"), new ItemStack((ItemLike)Items.f_41878_)).setSortnum(this.entrySortNum++);
        ((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((ImagePageBuilder)((ImagePageBuilder)((ImagePageBuilder)((ImagePageBuilder)gameplayBodyTempEntry.addImagePage(this.bookImage("normal_body")).setTitle(this.prefix("gameplay.body_temp.title")).setText(this.prefix("gameplay.body_temp.intro")).build().addTextPage(this.prefix("gameplay.body_temp.details")).build().addImagePage(this.bookImage("wetness_hud")).setAnchor("wetness")).setTitle(this.prefix("gameplay.body_temp.wetness.title")).setText(this.prefix("gameplay.body_temp.wetness.intro")).build().addTextPage(this.prefix("gameplay.body_temp.wetness.details")).build().addImagePage(this.bookImage("scalding_hud")).setAnchor("scalding")).setTitle(this.prefix("gameplay.body_temp.scalding.title")).setText(this.prefix("gameplay.body_temp.scalding.intro")).build().addImagePage(this.bookImage("hyperthermia_hud")).setAnchor("hyperthermia")).setTitle(this.prefix("gameplay.body_temp.hyperthermia.title")).setText(this.prefix("gameplay.body_temp.hyperthermia.intro")).build().addImagePage(this.bookImage("hypothermia_hud")).setAnchor("hypothermia")).setTitle(this.prefix("gameplay.body_temp.hypothermia.title")).setText(this.prefix("gameplay.body_temp.hypothermia.intro")).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("insulation"), gameplayBodyTempEntry))).setAnchor("insulation")).setTitle(this.prefix("gameplay.body_temp.insulation.title"))).setText(this.prefix("gameplay.body_temp.insulation.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("remove_insulation"), gameplayBodyTempEntry))).setAnchor("remove_insulation")).setTitle(this.prefix("gameplay.body_temp.remove_insulation.title"))).setText(this.prefix("gameplay.body_temp.remove_insulation.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("radiation_protection"), gameplayBodyTempEntry))).setAnchor("radiation_protection")).setTitle(this.prefix("gameplay.body_temp.radiation_protection.title"))).setText(this.prefix("gameplay.body_temp.radiation_protection.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("remove_radiation_protection"), gameplayBodyTempEntry))).setAnchor("remove_radiation_protection")).setTitle(this.prefix("gameplay.body_temp.remove_radiation_protection.title"))).setText(this.prefix("gameplay.body_temp.remove_radiation_protection.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("waterproof"), gameplayBodyTempEntry))).setAnchor("waterproofing")).setTitle(this.prefix("gameplay.body_temp.waterproof.title"))).setText(this.prefix("gameplay.body_temp.waterproof.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("remove_waterproof"), gameplayBodyTempEntry))).setAnchor("remove_waterproofing")).setTitle(this.prefix("gameplay.body_temp.remove_waterproof.title"))).setText(this.prefix("gameplay.body_temp.remove_waterproof.text"))).build();
        EntryBuilder gameplayHydrationEntry = category.addEntry("gameplay/hydration", this.prefix("gameplay.hydration.name"), new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK)).setSortnum(this.entrySortNum++);
        ((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CustomRecipePageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((SmeltingPageBuilder)((SmeltingPageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)((CampfirePageBuilder)((CampfirePageBuilder)((CraftingPageBuilder)((CraftingPageBuilder)gameplayHydrationEntry.addImagePage(this.bookImage("water_bar")).setTitle(this.prefix("gameplay.hydration.title")).setText(this.prefix("gameplay.hydration.intro")).build().addTextPage(this.prefix("gameplay.hydration.details")).build().addCraftingPage(new ResourceLocation("minecraft", "glass_bottle")).setTitle(this.prefix("gameplay.hydration.water_bottle.title"))).setText(this.prefix("gameplay.hydration.water_bottle.text"))).build().addCampfirePage(Homeostatic.loc("campfire_purified_water_bottle")).setTitle(this.prefix("gameplay.hydration.water_bottle.campfire.title"))).setText(this.prefix("gameplay.hydration.water_bottle.campfire.text"))).build().addCraftingPage(Homeostatic.loc("leather_flask")).setTitle(this.prefix("gameplay.hydration.leather_flask.title"))).setText(this.prefix("gameplay.hydration.leather_flask.text"))).build().addSmeltingPage(Homeostatic.loc("furnace_purified_leather_flask")).setTitle(this.prefix("gameplay.hydration.leather_flask.smelting.title"))).setText(this.prefix("gameplay.hydration.leather_flask.smelting.text"))).build().addCraftingPage(Homeostatic.loc("water_filter")).setTitle(this.prefix("gameplay.hydration.water_filter.title"))).setText(this.prefix("gameplay.hydration.water_filter.text"))).build().addPage((AbstractPageBuilder)new CustomRecipePageBuilder(Homeostatic.loc("filtered_water_flask"), gameplayHydrationEntry))).setTitle(this.prefix("gameplay.hydration.leather_flask_water_filter.title"))).setText(this.prefix("gameplay.hydration.leather_flask_water_filter.text"))).build();
        return category.build();
    }

    private BookBuilder addEducation(BookBuilder bookBuilder) {
        return bookBuilder.addCategory("education", this.prefix("education.name"), this.prefix("education.desc"), new ItemStack((ItemLike)Items.f_41997_)).setSortnum(Integer.valueOf(this.categorySortNum++)).addEntry("education/environment", this.prefix("education.environment.name"), new ItemStack((ItemLike)Items.f_42782_)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.environment.intro")).build().build().addEntry("education/body_temp", this.prefix("education.body_temp.name"), new ItemStack((ItemLike)Items.f_41936_)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.body_temp.intro")).build().build().addEntry("education/hydration", this.prefix("education.hydration.name"), new ItemStack((ItemLike)HomeostaticItems.PURIFIED_WATER_BUCKET)).setSortnum(this.entrySortNum++).addTextPage(this.prefix("education.hydration.intro")).build().build().build();
    }

    private String prefix(String name) {
        return "info.homeostatic.book." + name;
    }

    private ResourceLocation bookImage(String id) {
        return new ResourceLocation("homeostatic", "textures/gui/book/" + id + ".png");
    }
}

