/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.common.fluid.FluidInfo;
import homeostatic.common.item.IItemStackFluid;
import homeostatic.platform.Services;
import homeostatic.util.WaterHelper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterContainerItem
extends Item
implements IItemStackFluid {
    protected final int capacity;
    protected final int uses;

    public WaterContainerItem(Item.Properties properties, int capacity, int uses) {
        super(properties.m_41503_(capacity));
        this.capacity = capacity;
        this.uses = uses;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getUses() {
        return this.uses;
    }

    public int getSingleUse() {
        return this.capacity / this.uses;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = WaterContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = hitResult.m_82425_();
        BlockState blockState = level.m_8055_(pos);
        Fluid targetFluid = blockState.m_60819_().m_76152_();
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        FluidInfo fluidInfo = fluidInfoOptional.get();
        boolean isEmpty = fluidInfo.isEmpty();
        if ((isEmpty || fluidInfo.fluid().m_6212_(targetFluid)) && fluidInfo.amount() != (long)this.capacity) {
            BucketPickup bucketPickup;
            Block block;
            if (targetFluid == Fluids.f_76193_) {
                return InteractionResultHolder.m_19090_((Object)this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
            if (WaterHelper.getFluidHydration(targetFluid) != null && (block = blockState.m_60734_()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, pos, blockState).m_41619_()) {
                return InteractionResultHolder.m_19090_((Object)this.getFilledItem(stack, player, targetFluid, this.capacity));
            }
        }
        if (!isEmpty && this.canDrink(player, fluidInfo)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        return Services.PLATFORM.drainFluid(stack, this.getCapacity() / this.getUses());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent textComponent = Component.m_237115_((String)"tooltip.water_container.empty").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, components, tooltipFlag);
        Optional<FluidInfo> fluidInfoOptional = Services.PLATFORM.getFluidInfo(stack);
        if (fluidInfoOptional.isPresent() && fluidInfoOptional.get().amount() > 0L) {
            textComponent = Services.PLATFORM.getDisplayName(fluidInfoOptional.get().fluid());
            long amount = fluidInfoOptional.get().amount();
            components.add((Component)Component.m_237115_((String)(textComponent.getString() + String.format(": %d uses.", amount / (long)this.getSingleUse()))).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        } else {
            components.add((Component)textComponent);
        }
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack getFilledItem(ItemStack stack, Player player, Fluid fluid, int amount) {
        ItemStack copy = WaterHelper.getFilledItem(stack, fluid, amount);
        player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return copy;
    }

    public boolean canDrink(Player player, FluidInfo fluidInfo) {
        AtomicBoolean canDrink = new AtomicBoolean(WaterHelper.getFluidHydration(fluidInfo.fluid()) != null && fluidInfo.amount() >= (long)this.getSingleUse());
        Services.PLATFORM.getWaterCapabilty(player).ifPresent(data -> canDrink.set(canDrink.get() && data.getWaterLevel() < 20));
        return canDrink.get();
    }
}

