/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeData;
import homeostatic.common.biome.BiomeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public record ClimateSettings(Holder<Biome> biome, boolean precipitation, float temperature, Biome.TemperatureModifier modifier, float downfall) {
    private static BiomeData biomeData;

    public ClimateSettings {
        biomeData = BiomeRegistry.getDataForBiome(biome);
    }

    @Override
    public String toString() {
        return "Biome: " + this.biome.toString() + "\nprecipitation_type=" + this.getPrecipitationType() + "\ntemperature=" + this.temperature + "\ntemperatureModifier=" + this.modifier + "\ndownfall=" + this.downfall + "\ndayNightOffset=" + biomeData.getDayNightOffset(this.getPrecipitationType()) + "\nhumidity=" + biomeData.getHumidity(this.getPrecipitationType()) + "\nbiomeCategory=" + BiomeCategoryManager.getBiomeCategory(this.biome);
    }

    public Biome.Precipitation getPrecipitationType() {
        if (!this.precipitation) {
            return Biome.Precipitation.NONE;
        }
        return this.temperature <= 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static BiomeData getBiomeData() {
        return biomeData;
    }
}

