/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public class BiomeRegistry {
    public static final Map<BiomeCategory.Type, BiomeData> BIOMES = new HashMap<BiomeCategory.Type, BiomeData>();
    private static final BiomeData BOG = new BiomeData(0.351f, 60.0, 40.0, 10.0, false);
    private static final BiomeData FROZEN_OCEAN = new BiomeData(0.373f, 20.0, 20.0, 5.0, true);
    private static final BiomeData COLD_OCEAN = new BiomeData(0.373f, 20.0, 20.0, 5.0, false);
    private static final BiomeData COLD_FOREST = new BiomeData(0.373f, 60.0, 40.0, 12.0, false);
    private static final BiomeData COLD_DESERT = new BiomeData(0.395f, 20.0, 40.0, 20.0, false);
    private static final BiomeData DEEP_COLD_OCEAN = new BiomeData(0.44f, 20.0, 20.0, 5.0, false);
    private static final BiomeData ICY = new BiomeData(0.507f, 20.0, 20.0, 5.0, false);
    private static final BiomeData TAIGA = new BiomeData(0.507f, 50.0, 40.0, 10.0, false);
    private static final BiomeData OCEAN = new BiomeData(0.551f, 70.0, 40.0, 10.0, false);
    private static final BiomeData RIVER = new BiomeData(0.551f, 70.0, 40.0, 10.0, false);
    private static final BiomeData DEEP_LUKEWARM_OCEAN = new BiomeData(0.596f, 70.0, 40.0, 10.0, false);
    private static final BiomeData EXTREME_HILLS = new BiomeData(0.618f, 50.0, 40.0, 10.0, false);
    private static final BiomeData MOUNTAIN = new BiomeData(0.618f, 50.0, 40.0, 10.0, false);
    private static final BiomeData LUKEWARM_OCEAN = new BiomeData(0.64f, 70.0, 40.0, 10.0, false);
    private static final BiomeData BEACH = new BiomeData(0.663f, 70.0, 40.0, 10.0, false);
    private static final BiomeData FOREST = new BiomeData(0.663f, 50.0, 40.0, 12.0, false);
    public static final BiomeData UNDERGROUND = new BiomeData(0.663f, 40.0, 40.0, 12.0, false);
    private static final BiomeData SWAMP = new BiomeData(0.685f, 90.0, 40.0, 12.0, false);
    private static final BiomeData MUSHROOM = new BiomeData(0.685f, 70.0, 40.0, 12.0, false);
    private static final BiomeData WARM_OCEAN = new BiomeData(0.73f, 70.0, 40.0, 10.0, false);
    private static final BiomeData PLAINS = new BiomeData(0.774f, 60.0, 40.0, 15.0, false);
    private static final BiomeData MISSING = new BiomeData(0.774f, 40.0, 40.0, 15.0, false);
    private static final BiomeData LUSH_DESERT = new BiomeData(0.886f, 60.0, 40.0, 15.0, false);
    private static final BiomeData DRYLAND = new BiomeData(0.886f, 35.0, 40.0, 15.0, false);
    private static final BiomeData RAINFOREST = new BiomeData(0.886f, 95.0, 40.0, 15.0, false);
    private static final BiomeData JUNGLE = new BiomeData(0.997f, 90.0, 40.0, 15.0, false);
    private static final BiomeData VOLCANIC = new BiomeData(1.04f, 35.0, 40.0, 15.0, false);
    private static final BiomeData DEAD_SEA = new BiomeData(1.04f, 35.0, 40.0, 15.0, false);
    private static final BiomeData SAVANNA = new BiomeData(1.108f, 30.0, 40.0, 15.0, false);
    private static final BiomeData MESA = new BiomeData(1.309f, 20.0, 40.0, 15.0, false);
    private static final BiomeData DESERT = new BiomeData(1.354f, 20.0, 40.0, 20.0, false);
    private static final BiomeData NONE = new BiomeData(0.15f, 40.0, 40.0, 0.0, false);
    private static final BiomeData THEEND = new BiomeData(0.551f, 40.0, 40.0, 0.0, false);
    private static final BiomeData NETHER = new BiomeData(1.666f, 20.0, 40.0, 0.0, false);

    public static BiomeData getDataForBiome(Holder<Biome> biome) {
        BiomeCategory.Type biomeCategory = BiomeCategoryManager.getBiomeCategory(biome);
        return BIOMES.getOrDefault((Object)biomeCategory, MISSING);
    }

    public static void init() {
    }

    static {
        BIOMES.put(BiomeCategory.Type.DEEP_COLD_OCEAN, DEEP_COLD_OCEAN);
        BIOMES.put(BiomeCategory.Type.COLD_DESERT, COLD_DESERT);
        BIOMES.put(BiomeCategory.Type.COLD_FOREST, COLD_FOREST);
        BIOMES.put(BiomeCategory.Type.COLD_OCEAN, COLD_OCEAN);
        BIOMES.put(BiomeCategory.Type.FROZEN_OCEAN, FROZEN_OCEAN);
        BIOMES.put(BiomeCategory.Type.ICY, ICY);
        BIOMES.put(BiomeCategory.Type.OCEAN, OCEAN);
        BIOMES.put(BiomeCategory.Type.WARM_OCEAN, WARM_OCEAN);
        BIOMES.put(BiomeCategory.Type.LUKEWARM_OCEAN, LUKEWARM_OCEAN);
        BIOMES.put(BiomeCategory.Type.DEEP_LUKEWARM_OCEAN, DEEP_LUKEWARM_OCEAN);
        BIOMES.put(BiomeCategory.Type.BOG, BOG);
        BIOMES.put(BiomeCategory.Type.RIVER, RIVER);
        BIOMES.put(BiomeCategory.Type.TAIGA, TAIGA);
        BIOMES.put(BiomeCategory.Type.EXTREME_HILLS, EXTREME_HILLS);
        BIOMES.put(BiomeCategory.Type.MOUNTAIN, MOUNTAIN);
        BIOMES.put(BiomeCategory.Type.BEACH, BEACH);
        BIOMES.put(BiomeCategory.Type.FOREST, FOREST);
        BIOMES.put(BiomeCategory.Type.SWAMP, SWAMP);
        BIOMES.put(BiomeCategory.Type.UNDERGROUND, UNDERGROUND);
        BIOMES.put(BiomeCategory.Type.MUSHROOM, MUSHROOM);
        BIOMES.put(BiomeCategory.Type.PLAINS, PLAINS);
        BIOMES.put(BiomeCategory.Type.LUSH_DESERT, LUSH_DESERT);
        BIOMES.put(BiomeCategory.Type.DRYLAND, DRYLAND);
        BIOMES.put(BiomeCategory.Type.RAINFOREST, RAINFOREST);
        BIOMES.put(BiomeCategory.Type.JUNGLE, JUNGLE);
        BIOMES.put(BiomeCategory.Type.VOLCANIC, VOLCANIC);
        BIOMES.put(BiomeCategory.Type.DEAD_SEA, DEAD_SEA);
        BIOMES.put(BiomeCategory.Type.SAVANNA, SAVANNA);
        BIOMES.put(BiomeCategory.Type.MESA, MESA);
        BIOMES.put(BiomeCategory.Type.DESERT, DESERT);
        BIOMES.put(BiomeCategory.Type.NONE, NONE);
        BIOMES.put(BiomeCategory.Type.THEEND, THEEND);
        BIOMES.put(BiomeCategory.Type.NETHER, NETHER);
    }
}

