/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import net.minecraft.world.level.biome.Biome;

public class BiomeData {
    public static final float FROZEN_OFFSET = -0.31f;
    public static final float SNOW_OFFSET = -0.446f;
    public static final float MC_DEGREE = 0.022289157f;
    private final float temperature;
    private double humidity;
    private final float seasonVariation;
    private final float dayNightOffset;
    private final boolean isFrozen;

    BiomeData(float temperature, double humidity, double seasonVariation, double dayNightOffset, boolean isFrozen) {
        this.humidity = humidity;
        this.seasonVariation = (float)seasonVariation * 0.022289157f;
        this.dayNightOffset = (float)dayNightOffset * 0.022289157f;
        this.temperature = temperature;
        this.isFrozen = isFrozen;
    }

    public float getTemperature(Biome.Precipitation precipitation) {
        float temperature = this.temperature;
        if (this.isFrozen) {
            temperature += -0.31f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            temperature += -0.446f;
        }
        return temperature;
    }

    public double getHumidity(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            this.humidity = 20.0;
        }
        return this.humidity;
    }

    public float getSeasonVariation(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            return this.seasonVariation / 2.0f;
        }
        return this.seasonVariation;
    }

    public float getDayNightOffset(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            return this.dayNightOffset / 2.0f;
        }
        return this.dayNightOffset;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public String toString() {
        return "BiomeData{temperature=" + this.temperature + ", humidity=" + this.humidity + ", seasonVariation=" + this.seasonVariation + ", dayNightOffset=" + this.dayNightOffset + "}";
    }
}

