/*
 * Decompiled with CFR 0.152.
 */
package homeostatic;

import homeostatic.Custom.GUI.ItemRepairScreen;
import homeostatic.Custom.GUI.KeroseneMenus;
import homeostatic.Custom.Register;
import homeostatic.Custom.event.ForgeEventHandler;
import homeostatic.Custom.event.ServerEventListener_Kerosene;
import homeostatic.Homeostatic;
import homeostatic.HomeostaticClientForge;
import homeostatic.common.CreativeTabs;
import homeostatic.common.HomeostaticModule;
import homeostatic.common.biome.BiomeCategory;
import homeostatic.common.biome.BiomeCategoryManager;
import homeostatic.common.biome.BiomeData;
import homeostatic.common.biome.BiomeRegistry;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.ForgeFluidType;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.potions.HomeostaticPotions;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.common.temperature.IBodyTemperature;
import homeostatic.event.CapabilityEventHandler;
import homeostatic.event.ServerEventListener;
import homeostatic.network.NetworkHandler;
import homeostatic.util.RegistryHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="homeostatic")
public class HomeostaticForge {
    private IBodyTemperature handle;

    public HomeostaticForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Register.register(bus);
        KeroseneMenus.MENUS.register(bus);
        this.registryInit();
        bus.register(RegistryListener.class);
        bus.register(CapabilityRegistry.class);
        bus.addListener(this::setup);
        bus.addListener(this::ClientSetUp);
        Homeostatic.init();
        Homeostatic.initConfig();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStart);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ForgeEventHandler.class);
        MinecraftForge.EVENT_BUS.register(ServerEventListener.class);
        MinecraftForge.EVENT_BUS.register(ServerEventListener_Kerosene.class);
        MinecraftForge.EVENT_BUS.register(CapabilityEventHandler.class);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> HomeostaticClientForge::new);
        event.enqueueWork(() -> NetworkHandler.init());
    }

    private void ClientSetUp(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Register.KEROSENE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            MenuScreens.m_96206_((MenuType)((MenuType)KeroseneMenus.ITEM_REPAIR_MENU.get()), ItemRepairScreen::new);
        });
    }

    private void registryInit() {
        HomeostaticForge.bind(ForgeRegistries.BLOCKS.getRegistryKey(), HomeostaticBlocks::init);
        HomeostaticForge.bind(ForgeRegistries.MOB_EFFECTS.getRegistryKey(), HomeostaticEffects::init);
        HomeostaticForge.bind(ForgeRegistries.FLUIDS.getRegistryKey(), HomeostaticFluids::init);
        HomeostaticForge.bind(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), HomeostaticRecipes::init);
        HomeostaticForge.bind(ForgeRegistries.ITEMS.getRegistryKey(), HomeostaticItems::init);
        HomeostaticForge.bind(ForgeRegistries.POTIONS.getRegistryKey(), HomeostaticPotions::init);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public void serverStart(ServerStartedEvent event) {
        Registry biomeRegistry = RegistryHelper.getRegistry(event.getServer(), Registries.f_256952_);
        for (Map.Entry entry : biomeRegistry.m_6579_()) {
            ResourceKey biomeResourceKey = (ResourceKey)entry.getKey();
            ResourceLocation biomeName = biomeResourceKey.m_135782_();
            Holder.Reference biomeHolder = biomeRegistry.m_246971_(biomeResourceKey);
            BiomeCategory.Type biomeCategory = BiomeCategoryManager.getBiomeCategory((Holder<Biome>)biomeHolder);
            BiomeData biomeData = BiomeRegistry.getDataForBiome((Holder<Biome>)biomeHolder);
            Biome biome = (Biome)biomeHolder.m_203334_();
            Biome.Precipitation precipitation = this.getPrecipitation(biome);
            String temperatureModifier = biomeData.isFrozen() ? "FROZEN" : "NONE";
            float dayNightOffset = biomeData.getDayNightOffset(precipitation);
            double humidity = biomeData.getHumidity(precipitation);
            if (biomeName.toString().equals("terrablender:deferred_placeholder")) continue;
            if (biomeCategory == BiomeCategory.Type.MISSING) {
                Homeostatic.LOGGER.warn("Missing biome in registry, will set to neutral temperature for: {}", (Object)biomeName);
            }
            Homeostatic.LOGGER.debug("Biome: " + biomeName + "\nprecipitation_type=" + precipitation + "\ntemperature=" + biomeData.getTemperature(precipitation) + "\ntemperatureModifier=" + temperatureModifier + "\ndownfall=" + biome.getModifiedClimateSettings().f_47683_() + "\ndayNightOffset=" + dayNightOffset + "\nhumidity=" + humidity + "\nbiomeCategory=" + biomeCategory);
        }
    }

    private Biome.Precipitation getPrecipitation(Biome biome) {
        if (!biome.m_264473_()) {
            return Biome.Precipitation.NONE;
        }
        return biome.m_47554_() <= 0.15f ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static final class RegistryListener {
        private static boolean setupDone = false;

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getRegistryKey(), ForgeFluidType::initTypes);
            CreativeTabs.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void setupRegistries(FMLConstructModEvent event) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            if (setupDone) {
                return;
            }
            setupDone = true;
            HomeostaticModule.initRegistries(bus);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256869_ || event.getTab() == CreativeTabs.ALL_ITEMS_TAB.get()) {
                for (Map.Entry<ResourceLocation, Item> entry : HomeostaticItems.getAll().entrySet()) {
                    Item item = entry.getValue();
                    event.m_246342_(new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

