/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.Custom.recipe;

import homeostatic.Custom.Register;
import homeostatic.Custom.recipe.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ToolRepairRecipe
extends CustomRecipe {
    public ToolRepairRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean hasKerosene = false;
        boolean hasCoal = false;
        boolean hasDamagedTool = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == Register.KEROSENE.get()) {
                if (hasKerosene) {
                    return false;
                }
                hasKerosene = true;
                continue;
            }
            if (stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_) {
                if (hasCoal) {
                    return false;
                }
                hasCoal = true;
                continue;
            }
            if (stack.m_41763_() && stack.m_41768_()) {
                if (hasDamagedTool) {
                    return false;
                }
                hasDamagedTool = true;
                continue;
            }
            return false;
        }
        return hasKerosene && hasCoal && hasDamagedTool;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack toolToRepair = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41763_() || !stack.m_41768_()) continue;
            toolToRepair = stack;
            break;
        }
        if (toolToRepair == null) {
            return ItemStack.f_41583_;
        }
        ItemStack repairedTool = toolToRepair.m_41777_();
        int maxDamage = repairedTool.m_41776_();
        int repairAmount = (int)((double)maxDamage * 0.25);
        int newDamage = Math.max(repairedTool.m_41773_() - repairAmount, 0);
        repairedTool.m_41721_(newDamage);
        return repairedTool;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.TOOL_REPAIR.get();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == Register.KEROSENE.get() || stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_) {
                remaining.set(i, (Object)ItemStack.f_41583_);
                continue;
            }
            remaining.set(i, (Object)stack.m_41777_());
        }
        return remaining;
    }
}

