/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.Custom.recipe;

import homeostatic.Custom.Register;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RepairRecipeHandler {
    static Item KeroseneItem = (Item)Register.KEROSENE.get();

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack toolToRepair;
        ItemStack result = event.getCrafting();
        CraftingContainer craftingInventory = (CraftingContainer)event.getInventory();
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (RepairRecipeHandler.isRepairRecipe(craftingInventory, result) && !(toolToRepair = RepairRecipeHandler.findDamagedTool(craftingInventory)).m_41619_() && toolToRepair.m_41768_()) {
            int repairAmount = RepairRecipeHandler.calculateRepairAmount(toolToRepair);
            RepairRecipeHandler.repairItem(result, repairAmount);
        }
    }

    private static boolean isRepairRecipe(CraftingContainer inventory, ItemStack result) {
        boolean hasRepairItem = false;
        boolean hasCoal = false;
        boolean hasTool = false;
        ItemStack toolStack = ItemStack.f_41583_;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == KeroseneItem) {
                if (hasRepairItem) {
                    return false;
                }
                hasRepairItem = true;
                continue;
            }
            if (stack.m_41720_() == Items.f_42413_ || stack.m_41720_() == Items.f_42414_) {
                if (hasCoal) {
                    return false;
                }
                hasCoal = true;
                continue;
            }
            if (!stack.m_41763_()) continue;
            if (!toolStack.m_41619_()) {
                return false;
            }
            toolStack = stack;
        }
        return hasRepairItem && hasCoal && toolStack.m_41619_();
    }

    private static ItemStack findDamagedTool(CraftingContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41763_() || !stack.m_41768_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static int calculateRepairAmount(ItemStack tool) {
        return (int)((double)tool.m_41776_() * 0.2);
    }

    private static void repairItem(ItemStack result, int amount) {
        if (result.m_41763_()) {
            int newDamage = Math.max(result.m_41773_() - amount, 0);
            result.m_41721_(newDamage);
        }
    }
}

