/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.Custom.event;

import homeostatic.Custom.Items.Kerosene;
import homeostatic.Custom.Register;
import homeostatic.Custom.event.PlayerEventHandler_Kerosene;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEventListener_Kerosene {
    private static final Set<Item> WATCHED_ITEMS = new HashSet<Item>();

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!event.player.m_9236_().m_5776_()) {
            PlayerEventHandler_Kerosene.onPlayerTickEvent((ServerPlayer)event.player);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stackMain = event.getEntity().m_21120_(InteractionHand.MAIN_HAND);
        ItemStack stackOff = event.getEntity().m_21120_(InteractionHand.OFF_HAND);
        Item itemInOffHand = stackOff.m_41720_();
        Item itemInMainHand = stackMain.m_41720_();
        ServerEventListener_Kerosene.addWatchedItem((Item)Register.KEROSENE.get());
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof EntityBlock || block instanceof DoorBlock || state.m_155947_()) {
            return;
        }
        if (!WATCHED_ITEMS.contains(itemInOffHand)) {
            return;
        }
        event.setCanceled(true);
        if (stackMain.m_41619_()) {
            return;
        }
        UseOnContext useContext = new UseOnContext(event.getEntity(), InteractionHand.MAIN_HAND, new BlockHitResult(event.getHitVec().m_82450_(), event.getFace(), event.getPos(), event.getHitVec().m_82436_()));
        stackMain.m_41661_(useContext);
    }

    @SubscribeEvent
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().m_6144_() && event.getEntity().m_21205_().m_41619_() && event.getItemStack().m_41720_() == Register.KEROSENE.get()) {
            ItemStack aimItem = event.getItemStack();
            if (Kerosene.isOverload(aimItem)) {
                Kerosene.setOverload(aimItem, false);
            } else {
                Kerosene.setOverload(aimItem, true);
            }
        }
    }

    public static void addWatchedItem(Item item) {
        WATCHED_ITEMS.add(item);
    }

    public static void removeWatchedItem(Item item) {
        WATCHED_ITEMS.remove(item);
    }
}

