/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.Custom.event;

import homeostatic.Custom.Items.Kerosene;
import homeostatic.Custom.Register;
import homeostatic.common.capabilities.ITemperature;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.temperature.BodyTemperature;
import homeostatic.common.temperature.EnvironmentData;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class PlayerEventHandler_Kerosene {
    public static float NOMAL = TemperatureThreshold.NORMAL.temperature;
    public static float WARNING_HIGH = TemperatureThreshold.WARNING_HIGH.temperature;
    public static float HIGH = TemperatureThreshold.HIGH.temperature;
    public static float SCALDING_WARNING = TemperatureThreshold.SCALDING_WARNING.temperature;
    public static float LOW = TemperatureThreshold.LOW.temperature;
    public static float SCALDING = TemperatureThreshold.SCALDING.temperature;
    public static int payed_fuel = 0;
    private static int playertickCount = 0;

    public static void onPlayerTickEvent(ServerPlayer sp) {
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        ServerLevel world = sp.m_284548_();
        ProfilerFiller profilerfiller = world.m_46473_();
        Services.PLATFORM.getTemperatureData((Player)sp).ifPresent(data -> {
            if (sp.f_19797_ % 2 == 0) {
                data.checkTemperatureLevel((Player)sp);
            }
            if (sp.f_19797_ % 20 == 0) {
                Vec3 spPos = sp.m_20299_(1.0f);
                BlockPos pos = new BlockPos((int)spPos.m_7096_(), (int)spPos.m_7098_(), (int)spPos.m_7094_());
                Holder biome = world.m_204166_(pos);
                EnvironmentData environmentData = new EnvironmentData(sp, pos, (Holder<Biome>)biome, world);
                BodyTemperature bodyTemperature = new BodyTemperature(sp, environmentData, (ITemperature)data);
                PlayerEventHandler_Kerosene.checkHandAndReduceDurability(sp, environmentData, data, bodyTemperature);
                data.setTemperatureData(environmentData.getLocalTemperature(), bodyTemperature);
                Services.PLATFORM.syncTemperatureData(sp, environmentData, bodyTemperature);
            }
        });
        profilerfiller.m_7238_();
    }

    public static void checkHandAndReduceDurability(ServerPlayer sp, EnvironmentData environmentData, ITemperature data, BodyTemperature bodyTemperature) {
        ItemStack ItemInMHand = PlayerEventHandler_Kerosene.CheckHandItem(sp, InteractionHand.MAIN_HAND);
        ItemStack ItemInOHand = PlayerEventHandler_Kerosene.CheckHandItem(sp, InteractionHand.OFF_HAND);
        ResourceLocation targetId = new ResourceLocation("homeostatic", "kerosene");
        Item KEROSENE = (Item)Register.KEROSENE.get();
        if (ItemInOHand.m_41720_() == KEROSENE && !ItemInOHand.m_41619_() && ItemInOHand.m_41763_()) {
            if (ItemInOHand.m_41773_() >= ItemInOHand.m_41776_()) {
                sp.m_5496_(SoundEvents.f_11937_, 0.8f, 1.0f);
            } else {
                if (payed_fuel <= 1) {
                    ItemInOHand.m_220157_(12, sp.m_217043_(), null);
                    payed_fuel = 2;
                    playertickCount = sp.f_19797_;
                } else if ((sp.f_19797_ - playertickCount) % 200 == 0 && payed_fuel == 2) {
                    payed_fuel = 1;
                }
                PlayerEventHandler_Kerosene.ChangeSkinTemp(sp, bodyTemperature, data, ItemInOHand);
            }
        }
        if (ItemInMHand.m_41720_() == KEROSENE && !ItemInMHand.m_41619_()) {
            if (ItemInMHand.m_41763_()) {
                if (ItemInMHand.m_41773_() + 12 >= ItemInMHand.m_41776_()) {
                    sp.m_5496_(SoundEvents.f_11937_, 0.8f, 1.0f);
                } else {
                    if (payed_fuel <= 1) {
                        ItemInMHand.m_220157_(12, sp.m_217043_(), null);
                        payed_fuel = 2;
                        playertickCount = sp.f_19797_;
                    } else if ((sp.f_19797_ - playertickCount) % 200 == 0 && payed_fuel == 2) {
                        payed_fuel = 1;
                    }
                    PlayerEventHandler_Kerosene.ChangeSkinTemp(sp, bodyTemperature, data, ItemInMHand);
                }
            }
        } else if (ItemInOHand.m_41720_() != KEROSENE || ItemInOHand.m_41619_()) {
            payed_fuel = 0;
        }
    }

    private static void ChangeSkinTemp(ServerPlayer sp, BodyTemperature bodyTemperature, ITemperature data, ItemStack kerosene) {
        if (bodyTemperature.getCoreTemperature() < NOMAL) {
            if (Kerosene.isOverload(kerosene)) {
                bodyTemperature.setSkinTemperature(sp, (float)((double)SCALDING + 0.25), true);
                MobEffectInstance effectInstance = new MobEffectInstance(HomeostaticEffects.FROST_RESISTANCE, 20);
                sp.m_7292_(effectInstance);
                return;
            }
            bodyTemperature.setSkinTemperature(sp, SCALDING_WARNING, true);
        } else if (bodyTemperature.getCoreTemperature() > NOMAL) {
            // empty if block
        }
    }

    private static ItemStack CheckHandItem(ServerPlayer sp, InteractionHand hand) {
        ItemStack HandItem = sp.m_21120_(hand);
        return HandItem;
    }
}

