/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.Custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemConfigLoader {
    public static final Map<ResourceLocation, ItemConfig> CONFIGS = new HashMap<ResourceLocation, ItemConfig>();
    private static final Gson GSON = new GsonBuilder().create();

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(GSON, "data/homeostatic/config/items"){

            protected void apply(Map<ResourceLocation, JsonElement> configs, ResourceManager manager, ProfilerFiller profiler) {
                CONFIGS.clear();
                configs.forEach((id, json) -> {
                    try {
                        ItemConfig config = (ItemConfig)GSON.fromJson(json, ItemConfig.class);
                        CONFIGS.put((ResourceLocation)id, config);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
    }

    public static class ItemConfig {
        private float capacity;

        public float getDamage() {
            return this.capacity;
        }
    }
}

