/*
 * Decompiled with CFR 0.152.
 */
package net.depression.world;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import net.depression.block.ModBlocks;
import net.depression.mixin.StructureTemplatePoolAccess;
import net.depression.sound.ModSounds;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class VillageAdditions {
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((String)"depression", (ResourceKey)Registries.f_256749_);
    public static final ResourceKey<PoiType> COMPUTER_POI_KEY = VillageAdditions.createKey("computer_poi");
    public static final RegistrySupplier<VillagerProfession> PSYCHOLOGIST = VILLAGER_PROFESSIONS.register("psychologist", () -> new VillagerProfession("psychologist", x -> ((PoiType)x.m_203334_()).m_148692_(((Block)ModBlocks.COMPUTER.get()).m_49966_()), x -> ((PoiType)x.m_203334_()).m_148692_(((Block)ModBlocks.COMPUTER.get()).m_49966_()), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)ModSounds.TYPING.get()));

    public static void init(RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        for (int i = 0; i < 8; ++i) {
            VillageAdditions.addClinic((Registry<StructureTemplatePool>)registry, "plains", 16);
            VillageAdditions.addClinic((Registry<StructureTemplatePool>)registry, "desert", 16);
            VillageAdditions.addClinic((Registry<StructureTemplatePool>)registry, "savanna", 16);
            VillageAdditions.addClinic((Registry<StructureTemplatePool>)registry, "taiga", 16);
            VillageAdditions.addClinic((Registry<StructureTemplatePool>)registry, "snowy", 16);
        }
    }

    public static void addClinic(Registry<StructureTemplatePool> registry, String biome, int weight) {
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)registry.m_7745_(new ResourceLocation("village/" + biome + "/houses"));
        if (structureTemplatePool == null) {
            throw new IllegalStateException("Failed to find village pool " + biome + "/houses");
        }
        StructureTemplatePoolAccess poolAccess = (StructureTemplatePoolAccess)structureTemplatePool;
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = poolAccess.getRawTemplates() instanceof ArrayList ? poolAccess.getRawTemplates() : new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccess.getRawTemplates());
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.m_210526_((String)new ResourceLocation("depression", "village/" + biome + "/houses/" + biome + "_psychological_clinic").toString()).apply(StructureTemplatePool.Projection.RIGID);
        rawTemplates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)addedElement, (Object)weight));
        poolAccess.getTemplates().add((Object)addedElement);
        poolAccess.setRawTemplates(rawTemplates);
    }

    private static ResourceKey<PoiType> createKey(String path) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)new ResourceLocation("depression", path));
    }

    public static void register() {
        VILLAGER_PROFESSIONS.register();
    }
}

