/*
 * Decompiled with CFR 0.152.
 */
package net.depression.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.depression.client.DepressionClient;
import net.depression.mental.MentalStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Tools {
    public static final ArrayList<Double> harmonicSeries = new ArrayList();

    public static void init() {
        harmonicSeries.add(0.0);
        harmonicSeries.add(1.0);
        for (int i = 2; i < 65; ++i) {
            harmonicSeries.add(harmonicSeries.get(i - 1) + 1.0 / (double)(i / 2));
        }
    }

    public static double getHarmonic(int n) {
        if (n >= harmonicSeries.size()) {
            for (int i = harmonicSeries.size(); i <= n; ++i) {
                harmonicSeries.add(harmonicSeries.get(i - 1) + 1.0 / (double)(i / 2));
            }
        }
        return harmonicSeries.get(n);
    }

    public static int getPlayerMentalHealthLevel(Player player) {
        if (player instanceof ServerPlayer) {
            MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
            return mentalStatus.mentalIllness.mentalHealthId;
        }
        return DepressionClient.clientMentalStatus.mentalHealthId;
    }

    public static Date getGameDate(long worldTime) {
        return new Date(worldTime * 3600L - 62167420800000L);
    }

    public static String textDateFormat(String rawText, long worldTime) {
        Date date = Tools.getGameDate(worldTime);
        String replacement = new SimpleDateFormat("yy").format(date);
        rawText = rawText.replace("yy", replacement);
        replacement = new SimpleDateFormat("MM").format(date);
        rawText = rawText.replace("MM", replacement);
        replacement = new SimpleDateFormat("dd").format(date);
        rawText = rawText.replace("dd", replacement);
        return rawText;
    }
}

