/*
 * Decompiled with CFR 0.152.
 */
package net.depression.util;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.depression.Depression;
import net.depression.screen.rhythmcraft.SongProgressSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.sounds.SoundSource;

public class OggStreamPlayer {
    public SongProgressSlider slider;
    private SourceDataLine sourceLine;
    private AudioInputStream audioInputStream;
    private AudioFormat decodedFormat;
    private AudioFormat fileFormat;
    public boolean isPlaying = false;
    public boolean isPaused = false;
    public boolean isEscPaused = false;
    public boolean isSpacePaused = false;
    private Thread playThread;
    private long totalBytesRead = 0L;
    private long bytesToSkip = 0L;
    private double soughtTime = 0.0;
    private String filePath;
    private FloatControl volumeControl;
    private float initialVolume;
    private float midVolume;
    private float minVolume;
    private float maxVolume;
    private double durationInSeconds;
    private long bytesToIgnore;
    private boolean wasPaused;
    public boolean isForwarding;
    private Thread forwardThread;

    public void load(String filePath, double durationInSeconds) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.filePath = filePath;
        AudioInputStream in = AudioSystem.getAudioInputStream(new File(filePath));
        AudioFormat baseFormat = in.getFormat();
        this.fileFormat = AudioSystem.getAudioFileFormat(new File(filePath)).getFormat();
        this.durationInSeconds = durationInSeconds;
        this.decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
        this.audioInputStream = AudioSystem.getAudioInputStream(this.decodedFormat, in);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.decodedFormat);
        this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
        this.sourceLine.open(this.decodedFormat);
        if (this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.volumeControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            Options options = Minecraft.m_91087_().f_91066_;
            this.initialVolume = options.m_92147_(SoundSource.MUSIC);
            this.midVolume = this.volumeControl.getValue();
            float gap = Math.min(this.midVolume - this.volumeControl.getMinimum(), this.volumeControl.getMaximum() - this.midVolume);
            this.minVolume = this.midVolume - gap;
            this.maxVolume = this.midVolume + gap;
        } else {
            Depression.LOGGER.error("Volume control not supported");
        }
    }

    public void play() {
        this.isPlaying = true;
        this.isPaused = false;
        this.sourceLine.start();
        this.playThread = new Thread(() -> {
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            this.totalBytesRead = 0L;
            try {
                while (this.isPlaying && (bytesRead = this.audioInputStream.read(buffer, 0, buffer.length)) != -1) {
                    while (this.isPaused) {
                        Thread.sleep(100L);
                    }
                    bytesRead -= bytesRead % this.decodedFormat.getFrameSize();
                    this.sourceLine.write(buffer, 0, bytesRead);
                    this.totalBytesRead += (long)bytesRead;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.sourceLine.drain();
                this.sourceLine.stop();
                this.sourceLine.close();
                try {
                    this.audioInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.isPlaying = false;
                this.isPaused = false;
            }
        });
        this.playThread.start();
    }

    public void pause() {
        this.isPaused = true;
        this.sourceLine.stop();
    }

    public void resume() {
        if (this.isEscPaused || this.isSpacePaused) {
            return;
        }
        this.isPaused = false;
        this.sourceLine.start();
    }

    public void stop() {
        this.isPlaying = false;
        this.isPaused = false;
        if (this.playThread != null && this.playThread.isAlive()) {
            try {
                this.playThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void seek(long ticks) {
        boolean wasPaused = this.isPaused;
        this.pause();
        this.sourceLine.stop();
        this.sourceLine.flush();
        this.sourceLine.close();
        double seconds = (double)ticks / 20.0;
        int frameSize = this.decodedFormat.getFrameSize();
        long bytesPerSecond = (long)((float)frameSize * this.decodedFormat.getFrameRate());
        long totalBytesToSkip = (long)(seconds * (double)bytesPerSecond);
        totalBytesToSkip -= totalBytesToSkip % (long)frameSize;
        this.bytesToIgnore = (long)(Math.min(1.0, seconds) * (double)bytesPerSecond);
        this.bytesToSkip = totalBytesToSkip - this.bytesToIgnore;
        try {
            long skipped;
            this.audioInputStream.close();
            AudioInputStream in = AudioSystem.getAudioInputStream(new File(this.filePath));
            this.audioInputStream = AudioSystem.getAudioInputStream(this.decodedFormat, in);
            this.totalBytesRead = 0L;
            while (this.totalBytesRead < this.bytesToSkip && (skipped = this.audioInputStream.skip(this.bytesToSkip - this.totalBytesRead)) > 0L) {
                this.totalBytesRead += skipped;
            }
            byte[] ignoreBuffer = new byte[4096];
            while (this.totalBytesRead < totalBytesToSkip) {
                long ignored;
                try {
                    int length = totalBytesToSkip - this.totalBytesRead < (long)ignoreBuffer.length ? (int)(totalBytesToSkip - this.totalBytesRead) : ignoreBuffer.length;
                    ignored = this.audioInputStream.read(ignoreBuffer, 0, length - length % frameSize);
                    if (length % frameSize > 0 && 0L < ignored && ignored < (long)ignoreBuffer.length) {
                        this.totalBytesRead += ignored;
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (ignored < 0L) break;
                this.totalBytesRead += ignored;
            }
            this.sourceLine.open(this.decodedFormat);
            this.soughtTime = (float)this.totalBytesRead / (this.decodedFormat.getFrameRate() * (float)this.decodedFormat.getFrameSize());
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            throw new RuntimeException(e);
        }
        this.isPaused = wasPaused;
        if (!this.isPaused) {
            this.sourceLine.start();
        }
    }

    public void forward(long ticks) {
        this.wasPaused = this.isPaused;
        this.isPaused = false;
        this.sourceLine.start();
        this.isForwarding = true;
        this.forwardThread = new Thread(() -> {
            try {
                Thread.sleep(ticks * 50L);
                if (this.wasPaused) {
                    this.pause();
                }
                this.isForwarding = false;
                this.forwardThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        this.forwardThread.start();
    }

    public double getElapsedTimeInSeconds() {
        return this.soughtTime + (double)this.sourceLine.getMicrosecondPosition() / 1000000.0;
    }

    public void setVolume(float value) {
        if (this.volumeControl != null) {
            value = Math.max(this.volumeControl.getMinimum(), Math.min(this.volumeControl.getMaximum(), value));
            this.volumeControl.setValue(value);
        }
    }

    public void setVolumeLinear(float volume) {
        if (this.volumeControl != null) {
            float dB = volume == 0.0f ? this.volumeControl.getMinimum() : (volume < 0.5f ? (this.midVolume - this.minVolume) * volume + this.minVolume : (this.maxVolume - this.midVolume) * (volume - 0.5f) + this.midVolume);
            this.volumeControl.setValue(dB);
        }
    }

    public double getDurationInSeconds() {
        return this.durationInSeconds;
    }
}

