/*
 * Decompiled with CFR 0.152.
 */
package net.depression.server;

import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.depression.mental.MentalStatus;
import net.depression.mental.MentalTrait;
import net.depression.network.DiaryUpdatePacket;
import net.depression.rhythmcraft.PlayingChart;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.server.StatManager;
import net.depression.world.ParticleFormulaInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Registry {
    public static final HashMap<UUID, MentalStatus> mentalStatus = new HashMap();
    public static final HashSet<UUID> quitPlayers = new HashSet();
    public static final HashMap<UUID, StatManager> statManager = new HashMap();
    public static final ConcurrentHashMap<UUID, RhythmCraftProfile> profileMap = new ConcurrentHashMap();
    private static final HashMap<UUID, ItemStack> diaryUpdateMap = new HashMap();
    private static final ConcurrentHashMap<UUID, ServerLevel> pendingLevels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, ServerPlayer> pendingPlayers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, ChunkMap> pendingChunkMaps = new ConcurrentHashMap();
    public static final HashMap<UUID, HashSet<UUID>> playerEventMap = new HashMap();
    public static final ConcurrentLinkedQueue<Player> addPlayerQueue = new ConcurrentLinkedQueue();
    public static HashMap<String, LinkedList<ParticleFormulaInstance>> particles = new HashMap();

    public static void init() {
        mentalStatus.clear();
        quitPlayers.clear();
        statManager.clear();
        diaryUpdateMap.clear();
        pendingLevels.clear();
        pendingPlayers.clear();
        pendingChunkMaps.clear();
        playerEventMap.clear();
        profileMap.clear();
        PlayingChart.playingCharts.clear();
        PlayingChart.playerData.clear();
    }

    public static void eventAddPlayer(ServerBossEvent event, ServerPlayer player) {
        if (!playerEventMap.containsKey(player.m_20148_())) {
            playerEventMap.put(player.m_20148_(), new HashSet());
        }
        playerEventMap.get(player.m_20148_()).add(event.m_18860_());
    }

    public static void eventRemovePlayer(ServerBossEvent event, ServerPlayer player) {
        HashSet<UUID> events = playerEventMap.get(player.m_20148_());
        if (events != null) {
            events.remove(event.m_18860_());
            if (events.isEmpty()) {
                playerEventMap.remove(player.m_20148_());
            }
        }
    }

    public static void addPendingPlayer(ServerLevel serverLevel, ServerPlayer player) {
        pendingLevels.put(player.m_20148_(), serverLevel);
        pendingPlayers.put(player.m_20148_(), player);
        while (pendingLevels.size() > 100) {
            pendingLevels.remove(((ConcurrentHashMap.KeySetView)pendingLevels.keySet()).iterator().next());
        }
        while (pendingPlayers.size() > 100) {
            pendingPlayers.remove(((ConcurrentHashMap.KeySetView)pendingPlayers.keySet()).iterator().next());
        }
    }

    public static void addPendingChunkMap(ServerPlayer player, ChunkMap chunkMap) {
        pendingChunkMaps.put(player.m_20148_(), chunkMap);
        while (pendingChunkMaps.size() > 100) {
            pendingChunkMaps.remove(((ConcurrentHashMap.KeySetView)pendingChunkMaps.keySet()).iterator().next());
        }
    }

    public static boolean isPending(Player player) {
        return pendingPlayers.containsKey(player.m_20148_());
    }

    public static void receiveMentalTraitPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        String id = buf.readCharSequence(buf.readableBytes(), DiaryUpdatePacket.charset).toString();
        Player player = packetContext.getPlayer();
        UUID uuid = player.m_20148_();
        MentalStatus mentalStatus = Registry.mentalStatus.get(uuid);
        mentalStatus.loadMentalTrait(MentalTrait.byId(id));
        addPlayerQueue.add(player);
    }

    public static void loadPendingPlayers() {
        for (Player player : addPlayerQueue) {
            UUID uuid = player.m_20148_();
            if (pendingChunkMaps.containsKey(uuid)) {
                pendingChunkMaps.get(uuid).m_140184_(pendingPlayers.get(uuid));
                pendingChunkMaps.remove(uuid);
            }
            if (!Registry.isPending(player)) continue;
            pendingLevels.get(uuid).m_8834_(pendingPlayers.get(uuid));
            pendingPlayers.remove(uuid);
            pendingLevels.remove(uuid);
        }
    }

    public static void diaryUpdate(ServerPlayer player, ItemStack diary) {
        diaryUpdateMap.put(player.m_20148_(), diary);
        DiaryUpdatePacket.sendToPlayer(player);
    }

    public static void receiveDiaryUpdatePacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ItemStack diary = diaryUpdateMap.get(packetContext.getPlayer().m_20148_());
        CharSequence rawContent = buf.readCharSequence(buf.readableBytes(), DiaryUpdatePacket.charset);
        CompoundTag compoundTag = diary.m_41784_();
        ListTag oldPages = compoundTag.m_128437_("pages", 8);
        ListTag pages = new ListTag();
        StringBuilder pageContent = new StringBuilder();
        for (int i = 0; i < rawContent.length(); ++i) {
            char c = rawContent.charAt(i);
            if (c == '/') {
                pages.add((Object)StringTag.m_129297_((String)pageContent.toString()));
                pageContent = new StringBuilder();
                continue;
            }
            pageContent.append(c);
        }
        pages.addAll((Collection)oldPages);
        while (pages.size() > 100) {
            pages.remove(pages.size() - 1);
        }
        compoundTag.m_128365_("pages", (Tag)pages);
        diary.m_41751_(compoundTag);
        diaryUpdateMap.remove(packetContext.getPlayer().m_20148_());
    }
}

