/*
 * Decompiled with CFR 0.152.
 */
package net.depression.screen.rhythmcraft;

import com.mojang.blaze3d.platform.Window;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.depression.network.RhythmCraftPacket;
import net.depression.util.OggStreamPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public class SongProgressSlider
extends AbstractSliderButton {
    public double xScale;
    public double yScale;
    public double widthScale;
    public double heightScale;
    public double playedSeconds;
    public int totalMinutes;
    public int totalSeconds;
    public OggStreamPlayer songPlayer;

    public SongProgressSlider(double xScale, double yScale, double widthScale, OggStreamPlayer songPlayer) throws UnsupportedAudioFileException, IOException {
        super(0, 0, 0, 20, (Component)Component.m_237113_((String)""), 0.0);
        this.xScale = xScale;
        this.yScale = yScale;
        this.widthScale = widthScale;
        this.songPlayer = songPlayer;
        this.totalMinutes = (int)songPlayer.getDurationInSeconds() / 60;
        this.totalSeconds = (int)songPlayer.getDurationInSeconds() % 60;
    }

    protected void m_5695_() {
    }

    protected void m_5697_() {
        this.playedSeconds = this.f_93577_ * this.songPlayer.getDurationInSeconds();
        long tick = (long)(this.playedSeconds * 20.0);
        this.songPlayer.seek(tick);
        RhythmCraftPacket.sendProgressChange(tick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        return false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.playedSeconds = this.songPlayer.getElapsedTimeInSeconds();
        this.f_93577_ = this.playedSeconds / this.songPlayer.getDurationInSeconds();
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        Font font = minecraft.f_91062_;
        int windowWidth = window.m_85445_();
        int windowHeight = window.m_85446_();
        this.m_252865_((int)((double)windowWidth * this.xScale));
        if (this.m_252754_() < 24) {
            this.m_252865_(24);
            this.m_93674_(windowWidth - 48);
        } else {
            this.m_93674_((int)((double)windowWidth * this.widthScale));
        }
        this.m_253211_((int)((double)windowHeight * this.yScale));
        super.m_87963_(guiGraphics, i, j, f);
        int minutes = (int)this.playedSeconds / 60;
        int seconds = (int)this.playedSeconds % 60;
        guiGraphics.m_280488_(font, minutes + ":" + seconds, this.m_252754_() - 24, this.m_252907_(), 0xEEEEEE);
        if (this.songPlayer.isSpacePaused) {
            long tick = Math.round((this.playedSeconds - (double)((int)this.playedSeconds)) * 20.0);
            String text = "(" + tick + " ticks)";
            guiGraphics.m_280488_(font, text, this.m_252754_() - font.m_92895_(text), this.m_252907_() + 10, 0xEEEEEE);
        }
        guiGraphics.m_280488_(font, this.totalMinutes + ":" + this.totalSeconds, this.m_252754_() + this.m_5711_() + 4, this.m_252907_(), 0xEEEEEE);
    }
}

