/*
 * Decompiled with CFR 0.152.
 */
package net.depression.screen.rhythmcraft;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.depression.Depression;
import net.depression.client.DepressionClient;
import net.depression.client.rhythmcraft.ClientPlayingChart;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.ProfileDataType;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.rhythmcraft.Song;
import net.depression.screen.ScaleButton;
import net.depression.screen.rhythmcraft.RCDrawer;
import net.depression.screen.rhythmcraft.RCLoadingScreen;
import net.depression.screen.rhythmcraft.RCMainScreen;
import net.depression.util.OggStreamPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RCSelectionScreen
extends Screen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("depression", "textures/rc_screen/selection/background.png");
    private static final ResourceLocation BEST_SCORE = new ResourceLocation("depression", "textures/rc_screen/selection/best_score.png");
    private static final ResourceLocation SELECTION_BAR = new ResourceLocation("depression", "textures/rc_screen/selection/selection_bar.png");
    private static final ResourceLocation SELECTION_SHADOW = new ResourceLocation("depression", "textures/rc_screen/selection/selection_shadow.png");
    public static final ResourceLocation COVER_FRAME = new ResourceLocation("depression", "textures/rc_screen/selection/cover_frame.png");
    private static final ResourceLocation DIFFICULTY_LABEL = new ResourceLocation("depression", "textures/rc_screen/selection/difficulty_label.png");
    private static final ResourceLocation DIFFICULTY_SHADOW = new ResourceLocation("depression", "textures/rc_screen/selection/difficulty_shadow.png");
    private static final ResourceLocation START_BUTTON = new ResourceLocation("depression", "textures/rc_screen/selection/start_button.png");
    private static final ResourceLocation BACK_BUTTON = new ResourceLocation("depression", "textures/rc_screen/selection/back_button.png");
    private static final ResourceLocation EDIT_CHART_BUTTON = new ResourceLocation("depression", "textures/rc_screen/selection/edit_chart_button.png");
    public static final int black = 0x202020;
    public static final int white = 0xEEEEEE;
    private static RCSelectionScreen instance;
    private ScaleButton startButton;
    private ScaleButton backButton;
    private ScaleButton editChartButton;
    private Song curSong;
    public ArrayList<ScaleButton> songButtons = new ArrayList<ScaleButton>(6){
        {
            for (int i = 0; i < 6; ++i) {
                this.add(null);
            }
        }
    };
    public ArrayList<ScaleButton> difficultyButtons = new ArrayList<ScaleButton>(5){
        {
            for (int i = 0; i < 5; ++i) {
                this.add(null);
            }
        }
    };

    public RCSelectionScreen() {
        super((Component)Component.m_237113_((String)""));
    }

    public void m_7856_() {
        instance = this;
        RhythmCraftPacket.sendProfileRequest();
        this.startButton = new ScaleButton(0.7583333333333333, 0.8074074074074075, 0.24166666666666667, 0.14074074074074075, 1, null, button -> {
            RhythmCraftPacket.sendReadChart(this.curSong.id, DepressionClient.rcProfile.difficulty, false);
            DepressionClient.playingChart = new ClientPlayingChart(this.curSong, DepressionClient.rcProfile.difficulty, false);
            this.loadChart();
        });
        this.backButton = new ScaleButton(0.0, 0.7777777777777778, 0.0875, 0.17037037037037037, 3, BACK_BUTTON, button -> Minecraft.m_91087_().m_91152_((Screen)new RCMainScreen()));
        this.editChartButton = new ScaleButton(0.8, 0.022222222222222223, 0.2, 0.1111111111111111, 3, EDIT_CHART_BUTTON, button -> RhythmCraftPacket.sendReadChart(this.curSong.id, DepressionClient.rcProfile.difficulty, true));
        this.m_142416_((GuiEventListener)this.startButton);
        this.m_142416_((GuiEventListener)this.backButton);
        this.m_142416_((GuiEventListener)this.editChartButton);
    }

    private void loadChart() {
        Minecraft.m_91087_().m_91397_().m_120186_();
        try {
            OggStreamPlayer oggPlayer = new OggStreamPlayer();
            oggPlayer.load(this.curSong.path.toString(), this.curSong.durationInSeconds);
            DepressionClient.oggStreamPlayer = oggPlayer;
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            Depression.LOGGER.error("Failed to load song file: " + this.curSong.path.toString());
            e.printStackTrace();
        }
        Minecraft.m_91087_().m_91152_((Screen)new RCLoadingScreen(this.curSong, DepressionClient.rcProfile.difficulty));
    }

    public static void receiveAcceptEditPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        DepressionClient.playingChart = new ClientPlayingChart(RCSelectionScreen.instance.curSong, DepressionClient.rcProfile.difficulty, true);
        Minecraft.m_91087_().execute(() -> instance.loadChart());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Window window = Minecraft.m_91087_().m_91268_();
        int x = window.m_85445_();
        int y = window.m_85446_();
        float xScale = (float)x / 240.0f;
        float yScale = (float)y / 135.0f;
        guiGraphics.m_280398_(BACKGROUND, 0, 0, -1, 0.0f, 0.0f, x, y, x, y);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(xScale, yScale, 1.0f);
        RhythmCraftProfile profile = DepressionClient.rcProfile;
        if (profile.sortType != null) {
            ArrayList<Song> songList = null;
            switch (profile.sortType) {
                case NAME: {
                    songList = Song.nameList;
                    break;
                }
                case DIFFICULTY: {
                    songList = Song.difficultyList.get(profile.difficulty);
                }
            }
            if (songList == null || songList.isEmpty()) {
                return;
            }
            this.curSong = songList.get(profile.index);
            int frameX = 11;
            int frameY = 53;
            int levelX = 110;
            int levelY = 59;
            int frameDeltaY = 21;
            int frameLength = 102;
            int frameHeight = 19;
            int barLength = 204;
            int barHeight = 152;
            for (int i = -2; i < 4; ++i) {
                int widgetIndex = i + 2;
                ScaleButton button = this.songButtons.get(widgetIndex);
                if (profile.index + i < 0 || profile.index + i >= songList.size()) {
                    if (button == null) continue;
                    this.m_169411_((GuiEventListener)button);
                    this.songButtons.set(widgetIndex, null);
                    continue;
                }
                if (i != 0) {
                    if (button == null) {
                        int finalI = i;
                        this.m_142416_((GuiEventListener)new ScaleButton(0.04583333333333333, (double)(11 + widgetIndex * 21) / 135.0, 0.425, 0.14074074074074075, 0, null, scaleButton -> {
                            profile.index += finalI;
                            RhythmCraftPacket.sendProfileUpdateC2S(profile, ProfileDataType.INDEX);
                        }));
                    }
                    Song song = songList.get(profile.index + i);
                    ArrayList<Integer> scores = profile.chartScores.get(song.id);
                    int rankNum = 0;
                    if (scores != null && scores.size() > profile.difficulty) {
                        rankNum = RhythmCraftProfile.getRankNumber(scores.get(profile.difficulty));
                    }
                    guiGraphics.m_280398_(SELECTION_BAR, frameX, frameY + i * frameDeltaY, 0, 0.0f, (float)(19 * rankNum), frameLength, frameHeight, barLength, barHeight);
                    if (i == 3) continue;
                    RCDrawer.drawChartLevel(guiGraphics, levelX, levelY + i * frameDeltaY, 0, song, profile.difficulty);
                    continue;
                }
                ArrayList<Integer> scores = profile.chartScores.get(this.curSong.id);
                int rankNum = 0;
                if (scores != null && scores.size() > profile.difficulty) {
                    rankNum = RhythmCraftProfile.getRankNumber(scores.get(profile.difficulty));
                }
                guiGraphics.m_280398_(SELECTION_BAR, 19, frameY, 0, 102.0f, (float)(19 * rankNum), frameLength, frameHeight, barLength, barHeight);
            }
            int nameX = 20;
            int nameY = 59;
            Font font = Minecraft.m_91087_().f_91062_;
            for (int i = -2; i < 4; ++i) {
                if (profile.index + i < 0 || profile.index + i >= songList.size()) continue;
                if (i != 0) {
                    Song song = songList.get(profile.index + i);
                    guiGraphics.m_280056_(font, song.name, nameX, nameY + i * frameDeltaY, 0xEEEEEE, false);
                    continue;
                }
                guiGraphics.m_280056_(font, this.curSong.name, 28, nameY, 0x202020, false);
            }
            RenderSystem.enableBlend();
            guiGraphics.m_280398_(SELECTION_SHADOW, frameX, 103, 0, 0.0f, 0.0f, 102, 32, 102, 32);
            int coverX = 132;
            int coverY = 12;
            int coverLength = 96;
            int coverHeight = 60;
            guiGraphics.m_280398_(this.curSong.cover, coverX, coverY, 0, 0.0f, 0.0f, coverLength, coverHeight, coverLength, coverHeight);
            guiGraphics.m_280398_(COVER_FRAME, coverX, coverY, 0, 0.0f, 0.0f, coverLength, coverHeight, coverLength, coverHeight);
            int difficultyX = 128;
            int difficultyY = 76;
            int rankY = 82;
            int chartLevelX = 133;
            int chartLevelY = 96;
            int deltaX = 21;
            int labelLength = 19;
            int labelHeight = 7;
            int labelTextureHeight = 42;
            int rankLength = 19;
            int rankHeight = 19;
            int rankTextureLength = 38;
            int rankTextureHeight = 152;
            int shadowLength = 19;
            int shadowHeight = 27;
            ArrayList<Integer> scores = profile.chartScores.get(this.curSong.id);
            for (int i = 1; i < this.curSong.charts.size(); ++i) {
                int index = i - 1;
                Chart chart = this.curSong.charts.get(i);
                ScaleButton button = this.difficultyButtons.get(index);
                if (chart == null) {
                    if (button == null) continue;
                    this.m_169411_((GuiEventListener)button);
                    this.difficultyButtons.set(index, null);
                    continue;
                }
                if (button == null) {
                    int finalI = i;
                    this.m_142416_((GuiEventListener)new ScaleButton((double)(128 + index * 21) / 240.0, 0.562962962962963, 0.07916666666666666, 0.2, 1, null, scaleButton -> {
                        profile.difficulty = finalI;
                        RhythmCraftPacket.sendProfileUpdateC2S(profile, ProfileDataType.DIFFICULTY);
                    }));
                }
                guiGraphics.m_280398_(DIFFICULTY_LABEL, difficultyX + index * deltaX, difficultyY, 0, 0.0f, (float)(7 * i), labelLength, labelHeight, labelLength, labelTextureHeight);
                int rankNum = 0;
                if (scores != null) {
                    rankNum = scores.size() <= i ? 0 : RhythmCraftProfile.getRankNumber(scores.get(i));
                }
                guiGraphics.m_280398_(RCDrawer.RANKINGS, difficultyX + index * deltaX, rankY, 0, 0.0f, (float)(19 * rankNum), rankLength, rankHeight, rankTextureLength, rankTextureHeight);
                RCDrawer.drawChartLevel(guiGraphics, chartLevelX + index * deltaX, chartLevelY, 0, this.curSong, i);
                if (i == profile.difficulty) continue;
                RenderSystem.enableBlend();
                guiGraphics.m_280398_(DIFFICULTY_SHADOW, difficultyX + index * deltaX, difficultyY, 0, 0.0f, 0.0f, shadowLength, shadowHeight, shadowLength, shadowHeight);
            }
            int bestScoreLength = 43;
            int bestScoreHeight = 22;
            guiGraphics.m_280398_(BEST_SCORE, 133, 106, 1, 0.0f, 0.0f, bestScoreLength, bestScoreHeight, bestScoreLength, bestScoreHeight);
            Integer score = 0;
            if (scores != null && scores.size() > profile.difficulty) {
                score = scores.get(profile.difficulty);
            }
            RCDrawer.drawRegularNumber(guiGraphics, 133, 116, 1, score, 7, profile.difficulty);
            int startButtonLength = 58;
            guiGraphics.m_280398_(START_BUTTON, 182, 105, 1, 0.0f, (float)(23 * profile.difficulty), startButtonLength, 23, startButtonLength, 138);
        }
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

