/*
 * Decompiled with CFR 0.152.
 */
package net.depression.screen.rhythmcraft;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.Song;
import net.depression.screen.UncloseableScreen;
import net.depression.screen.rhythmcraft.RCSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RCLoadingScreen
extends UncloseableScreen {
    private static final ResourceLocation BLACK_LOADING_BAR = new ResourceLocation("depression", "textures/rc_screen/loading/black_loading_bar.png");
    private static final ResourceLocation WHITE_LOADING_BAR = new ResourceLocation("depression", "textures/rc_screen/loading/white_loading_bar.png");
    private static final int loadingBarX = 195;
    private Song song;
    private Chart chart;
    private long startTime;
    private boolean loadingBarColor = false;
    private int loadingBarSplitX = 0;

    public RCLoadingScreen(Song song, int difficulty) {
        super((Component)Component.m_237113_((String)""));
        this.song = song;
        this.chart = song.charts.get(difficulty);
    }

    public void m_7856_() {
        super.m_7856_();
        this.startTime = System.currentTimeMillis();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (System.currentTimeMillis() - this.startTime > 3000L) {
            RhythmCraftPacket.sendReady();
            Minecraft.m_91087_().m_91152_(null);
        }
        Window window = Minecraft.m_91087_().m_91268_();
        int x = window.m_85445_();
        int y = window.m_85446_();
        float xScale = (float)x / 240.0f;
        float yScale = (float)y / 135.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(xScale, yScale, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280163_(RCSelectionScreen.BACKGROUND, 0, 0, 0.0f, 0.0f, 240, 135, 240, 135);
        guiGraphics.m_280056_(font, "Song: " + this.song.author, 11, 72, 0xEEEEEE, true);
        guiGraphics.m_280056_(font, "Chart: " + this.chart.author, 11, 84, 0xEEEEEE, true);
        if (this.song.illustrator != null) {
            guiGraphics.m_280056_(font, "Illustrator: " + this.song.illustrator, 11, 96, 0xEEEEEE, true);
        }
        guiGraphics.m_280398_(this.song.cover, 132, 12, 1, 0.0f, 0.0f, 96, 60, 96, 60);
        guiGraphics.m_280398_(RCSelectionScreen.COVER_FRAME, 132, 12, 1, 0.0f, 0.0f, 96, 60, 96, 60);
        int newSplitX = (int)((double)(System.currentTimeMillis() % 1000L) / 1000.0 * 45.0);
        if (newSplitX < this.loadingBarSplitX) {
            this.loadingBarColor = !this.loadingBarColor;
        }
        this.loadingBarSplitX = newSplitX;
        guiGraphics.m_280398_(this.loadingBarColor ? WHITE_LOADING_BAR : BLACK_LOADING_BAR, 195, 111, 1, 0.0f, 0.0f, this.loadingBarSplitX, 15, 45, 15);
        guiGraphics.m_280398_(!this.loadingBarColor ? WHITE_LOADING_BAR : BLACK_LOADING_BAR, 195 + this.loadingBarSplitX, 111, 1, (float)this.loadingBarSplitX, 0.0f, 45 - this.loadingBarSplitX, 15, 45, 15);
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

