/*
 * Decompiled with CFR 0.152.
 */
package net.depression.screen.rhythmcraft;

import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.Song;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class RCDrawer {
    public static final ResourceLocation RC_FONT_SMALL = new ResourceLocation("depression", "textures/rc_screen/font_3_5.png");
    public static final ResourceLocation RANKINGS = new ResourceLocation("depression", "textures/rc_screen/rankings.png");
    public static final ResourceLocation RANKINGS_WITH_TEXT = new ResourceLocation("depression", "textures/rc_screen/rankings_with_text.png");
    private static final ResourceLocation SMALL_NUMBERS = new ResourceLocation("depression", "textures/rc_screen/small_numbers.png");
    private static final ResourceLocation REGULAR_NUMBERS = new ResourceLocation("depression", "textures/rc_screen/regular_numbers.png");
    private static final ResourceLocation SETTLEMENT_SMALL_NUMBERS = new ResourceLocation("depression", "textures/rc_screen/settlement_small_numbers.png");
    private static final ResourceLocation SETTLEMENT_LARGE_NUMBERS = new ResourceLocation("depression", "textures/rc_screen/settlement_large_numbers.png");

    public static void drawStringSmall(GuiGraphics guiGraphics, String string, int x, int y, int k) {
        string = string.toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            int c = string.charAt(i) - 32;
            int textureY = c / 16;
            int textureX = c - textureY * 16;
            guiGraphics.m_280398_(RC_FONT_SMALL, x + 4 * i, y, k, (float)(textureX * 5), (float)(textureY * 7), 5, 7, 80, 42);
        }
    }

    public static void drawStringRightAligned(GuiGraphics guiGraphics, String string, int x, int y, int k) {
        int stringWidth = 4 * string.length() + 1;
        for (int i = 0; i < string.length(); ++i) {
            int c = string.charAt(i) - 32;
            int textureY = c / 16;
            int textureX = c - textureY * 16;
            guiGraphics.m_280398_(RC_FONT_SMALL, x - stringWidth + i * 4, y, k, (float)(textureX * 5), (float)(textureY * 7), 5, 7, 80, 42);
        }
    }

    public static void drawSettlementSmallNumber(GuiGraphics guiGraphics, int x, int y, int k, int number, int color) {
        int n1 = number / 10;
        int n2 = number % 10;
        int numberWidth = 7;
        int numberHeight = 7;
        int textureWidth = 70;
        int textureHeight = 42;
        float colorOffset = color * 7;
        guiGraphics.m_280398_(SETTLEMENT_SMALL_NUMBERS, x, y, k, (float)(n1 * numberWidth), colorOffset, numberWidth, numberHeight, textureWidth, textureHeight);
        guiGraphics.m_280398_(SETTLEMENT_SMALL_NUMBERS, x + numberWidth, y, k, (float)(n2 * numberWidth), colorOffset, numberWidth, numberHeight, textureWidth, textureHeight);
    }

    public static void drawSettlementLargeNumber(GuiGraphics guiGraphics, int x, int y, int k, int number, int color) {
        String string = String.valueOf(number);
        for (int i = 0; i < string.length(); ++i) {
            int digit = string.charAt(i) - 48;
            int textureY = color * 15;
            int textureX = digit * 12;
            guiGraphics.m_280398_(SETTLEMENT_LARGE_NUMBERS, x + i * 12, y, k, (float)textureX, (float)textureY, 12, 15, 120, 90);
        }
    }

    public static void drawChartLevel(GuiGraphics guiGraphics, int x, int y, int k, Song song, int difficulty) {
        for (int i = difficulty; i > 0; --i) {
            Chart chart = song.charts.get(i);
            if (chart == null) continue;
            int level = chart.level;
            RCDrawer.drawSmallNumber(guiGraphics, x, y, k, level, i);
            return;
        }
    }

    public static void drawSmallNumber(GuiGraphics guiGraphics, int x, int y, int k, int number, int color) {
        int n1 = number / 10;
        int n2 = number % 10;
        int numberWidth = 5;
        int numberHeight = 7;
        int textureWidth = 50;
        int textureHeight = 42;
        float colorOffset = color * 7;
        guiGraphics.m_280398_(SMALL_NUMBERS, x, y, k, (float)(n1 * 5), colorOffset, numberWidth, numberHeight, textureWidth, textureHeight);
        guiGraphics.m_280398_(SMALL_NUMBERS, x + 4, y, k, (float)(n2 * 5), colorOffset, numberWidth, numberHeight, textureWidth, textureHeight);
    }

    public static void drawRegularNumber(GuiGraphics guiGraphics, int x, int y, int k, int number, int digits, int color) {
        int numberWidth = 7;
        int numberHeight = 9;
        int textureWidth = 70;
        int textureHeight = 54;
        int deltaX = 6;
        float colorOffset = color * 9;
        int divisor = (int)Math.pow(10.0, digits - 1);
        if (divisor % 10 == 9) {
            ++divisor;
        }
        for (int i = 0; i < digits; ++i) {
            int n = number / divisor;
            number %= divisor;
            divisor /= 10;
            guiGraphics.m_280398_(REGULAR_NUMBERS, x + i * deltaX, y, k, (float)(n * 7), colorOffset, numberWidth, numberHeight, textureWidth, textureHeight);
        }
    }
}

