/*
 * Decompiled with CFR 0.152.
 */
package net.depression.screen.rhythmcraft;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.depression.Depression;
import net.depression.client.DepressionClient;
import net.depression.client.rhythmcraft.ClientPlayingChart;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.rhythmcraft.Song;
import net.depression.screen.ScaleButton;
import net.depression.screen.UncloseableScreen;
import net.depression.screen.rhythmcraft.RCDrawer;
import net.depression.screen.rhythmcraft.RCLoadingScreen;
import net.depression.screen.rhythmcraft.RCSelectionScreen;
import net.depression.util.OggStreamPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GameEndScreen
extends UncloseableScreen {
    private static final ResourceLocation TEXT_AUTHORS = new ResourceLocation("depression", "textures/rc_screen/settlement/text_authors.png");
    private static final ResourceLocation RETRY_BUTTON = new ResourceLocation("depression", "textures/rc_screen/settlement/retry_button.png");
    private static final ResourceLocation TEXT_YOUR_SCORE = new ResourceLocation("depression", "textures/rc_screen/settlement/text_your_score.png");
    private static final ResourceLocation TEXT_NEW_BEST_SCORE = new ResourceLocation("depression", "textures/rc_screen/settlement/text_new_best_score.png");
    private static final ResourceLocation TEXT_NOT_BEST_SCORE = new ResourceLocation("depression", "textures/rc_screen/settlement/text_not_best_score.png");
    private static final ResourceLocation TEXT_STAT = new ResourceLocation("depression", "textures/rc_screen/settlement/text_stat.png");
    private static final ResourceLocation CONTINUE_BUTTON = new ResourceLocation("depression", "textures/rc_screen/settlement/continue_button.png");
    ClientPlayingChart playingChart;
    int score;
    int blockMined;
    int blockMissed;
    int prevScore;
    private long startTime;
    private ScaleButton retryButton;
    private ScaleButton continueButton;

    public GameEndScreen(ClientPlayingChart playingChart, int score, int blockMined, int prevScore) {
        super((Component)Component.m_237113_((String)""));
        this.playingChart = playingChart;
        this.score = score;
        this.blockMined = blockMined;
        this.blockMissed = playingChart.chart.notes.size() - blockMined;
        this.prevScore = prevScore;
        this.startTime = System.currentTimeMillis();
    }

    public void m_7856_() {
        this.retryButton = new ScaleButton(0.0, 0.7777777777777778, 0.1, 0.17037037037037037, 3, null, button -> {
            Song song = this.playingChart.song;
            Chart chart = this.playingChart.chart;
            RhythmCraftPacket.sendReadChart(song.id, chart.difficulty, this.playingChart.isEditMode);
            DepressionClient.playingChart = new ClientPlayingChart(this.playingChart.song, DepressionClient.rcProfile.difficulty, this.playingChart.isEditMode);
            Minecraft.m_91087_().m_91397_().m_120186_();
            try {
                OggStreamPlayer oggPlayer = new OggStreamPlayer();
                oggPlayer.load(song.path.toString(), song.durationInSeconds);
                DepressionClient.oggStreamPlayer = oggPlayer;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                Depression.LOGGER.error("Failed to load song file: " + song.path.toString());
                e.printStackTrace();
            }
            Minecraft.m_91087_().m_91152_((Screen)new RCLoadingScreen(song, chart.difficulty));
        });
        this.continueButton = new ScaleButton(0.6833333333333333, 0.8074074074074075, 0.31666666666666665, 0.14074074074074075, 3, null, button -> {
            RhythmCraftPacket.sendLoadBack();
            Minecraft.m_91087_().m_91152_((Screen)new RCSelectionScreen());
        });
        this.m_142416_((GuiEventListener)this.retryButton);
        this.m_142416_((GuiEventListener)this.continueButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiGraphics.m_280182_();
        int y = guiGraphics.m_280206_();
        float xScale = (float)x / 240.0f;
        float yScale = (float)y / 135.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(xScale, yScale, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        long timeElapsed = System.currentTimeMillis() - this.startTime;
        Song song = this.playingChart.song;
        Chart chart = this.playingChart.chart;
        guiGraphics.m_280398_(RCSelectionScreen.BACKGROUND, 0, 0, -1, 0.0f, 0.0f, 240, 135, 240, 135);
        int coverX = (int)Math.min(16.0, -112.0 + (double)timeElapsed * 0.256);
        guiGraphics.m_280398_(song.cover, coverX, 20, 0, 0.0f, 0.0f, 96, 60, 96, 60);
        guiGraphics.m_280398_(RCSelectionScreen.COVER_FRAME, coverX, 20, 0, 0.0f, 0.0f, 96, 60, 96, 60);
        guiGraphics.m_280488_(font, song.name, coverX + 3, 68, 0xEEEEEE);
        guiGraphics.m_280398_(TEXT_AUTHORS, coverX - 18, 0, 0, 0.0f, 0.0f, 240, 135, 240, 135);
        RCDrawer.drawStringSmall(guiGraphics, song.author, coverX + 23, 82, 2);
        RCDrawer.drawStringSmall(guiGraphics, chart.author, coverX + 27, 90, 2);
        int retryX = (int)Math.min(0.0, -23.0 + (double)timeElapsed * 0.046);
        guiGraphics.m_280398_(RETRY_BUTTON, retryX, 105, 2, 0.0f, 0.0f, 24, 23, 24, 23);
        int scoreX = (int)Math.max(120.0, 240.0 - (double)(timeElapsed - 500L) * 0.24);
        guiGraphics.m_280398_(TEXT_YOUR_SCORE, scoreX, 20, 1, 0.0f, (float)(14 * chart.difficulty), 84, 14, 84, 84);
        RCDrawer.drawSettlementSmallNumber(guiGraphics, scoreX + 19, 27, 2, chart.level, chart.difficulty);
        RCDrawer.drawSettlementLargeNumber(guiGraphics, scoreX, 38, 2, this.playingChart.score.get(), chart.difficulty);
        guiGraphics.m_280398_(RCDrawer.RANKINGS_WITH_TEXT, scoreX + 82, 28, 2, 0.0f, (float)(25 * RhythmCraftProfile.getRankNumber(this.score)), 19, 25, 38, 200);
        int statX = (int)Math.max(120.0, 240.0 - (double)(timeElapsed - 1000L) * 0.24);
        if (this.score > this.prevScore) {
            guiGraphics.m_280398_(TEXT_NEW_BEST_SCORE, statX, 65, 2, 0.0f, 0.0f, 59, 14, 59, 14);
            RCDrawer.drawStringRightAligned(guiGraphics, "(+" + (this.score - this.prevScore) + ")", statX + 104, 65, 2);
            RCDrawer.drawStringRightAligned(guiGraphics, String.valueOf(this.prevScore), statX + 104, 72, 2);
        } else if (this.score < 1000000) {
            guiGraphics.m_280398_(TEXT_NOT_BEST_SCORE, statX, 65, 2, 0.0f, 0.0f, 59, 14, 59, 14);
            RCDrawer.drawStringRightAligned(guiGraphics, String.valueOf(this.prevScore), statX + 104, 72, 2);
        }
        guiGraphics.m_280398_(TEXT_STAT, statX, 80, 2, 0.0f, 0.0f, 105, 18, 105, 18);
        RCDrawer.drawStringRightAligned(guiGraphics, String.valueOf(this.blockMined), statX + 104, 84, 2);
        RCDrawer.drawStringRightAligned(guiGraphics, String.valueOf(this.blockMissed), statX + 104, 91, 2);
        int continueX = (int)Math.max(164.0, 240.0 - (double)(timeElapsed - 1000L) * 0.152);
        guiGraphics.m_280398_(CONTINUE_BUTTON, continueX, 109, 2, 0.0f, 0.0f, 76, 19, 76, 19);
        poseStack.m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

