/*
 * Decompiled with CFR 0.152.
 */
package net.depression.rhythmcraft;

import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.ProfileDataType;
import net.depression.rhythmcraft.SongSortType;
import net.depression.server.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RhythmCraftProfile {
    public HashMap<String, ArrayList<Integer>> chartScores = new HashMap();
    public SongSortType sortType = SongSortType.DIFFICULTY;
    public int difficulty = 1;
    public int index = 0;

    public void newScore(String id, int difficulty, int score) {
        ArrayList<Integer> scores = this.chartScores.get(id);
        if (scores != null && scores.get(difficulty) >= score) {
            return;
        }
        if (scores == null) {
            scores = new ArrayList();
            this.chartScores.put(id, scores);
        }
        while (scores.size() <= difficulty) {
            scores.add(0);
        }
        scores.set(difficulty, score);
    }

    public void readNbt(CompoundTag tag) {
        CompoundTag profile = tag.m_128469_("rc_profile");
        CompoundTag scores = profile.m_128469_("scores");
        for (String key : scores.m_128431_()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i : scores.m_128465_(key)) {
                list.add(i);
            }
            this.chartScores.put(key, list);
        }
        if (profile.m_128441_("initial_sort_type")) {
            this.sortType = SongSortType.valueOf(profile.m_128461_("initial_sort_type"));
        }
        if (profile.m_128441_("initial_difficulty")) {
            this.difficulty = profile.m_128451_("initial_difficulty");
        }
        if (profile.m_128441_("initial_index")) {
            this.index = profile.m_128451_("initial_index");
        }
    }

    public void writeNbt(CompoundTag tag) {
        CompoundTag profile = new CompoundTag();
        CompoundTag scores = new CompoundTag();
        for (Map.Entry<String, ArrayList<Integer>> entry : this.chartScores.entrySet()) {
            scores.m_128408_(entry.getKey(), (List)entry.getValue());
        }
        profile.m_128365_("scores", (Tag)scores);
        profile.m_128359_("initial_sort_type", this.sortType.name());
        profile.m_128405_("initial_difficulty", this.difficulty);
        profile.m_128405_("initial_index", this.index);
        tag.m_128365_("rc_profile", (Tag)profile);
    }

    public static int getRankNumber(Integer score) {
        if (score == 1000000) {
            return 7;
        }
        if (score >= 950000) {
            return 6;
        }
        if (score >= 900000) {
            return 5;
        }
        if (score >= 800000) {
            return 4;
        }
        if (score >= 600000) {
            return 3;
        }
        if (score >= 300000) {
            return 2;
        }
        if (score > 0) {
            return 1;
        }
        return 0;
    }

    public static RhythmCraftProfile getProfileByServerPlayer(Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalArgumentException("Player is not a ServerPlayer");
        }
        UUID uuid = player.m_20148_();
        RhythmCraftProfile profile = Registry.profileMap.get(uuid);
        if (profile == null) {
            profile = new RhythmCraftProfile();
            Registry.profileMap.put(uuid, profile);
        }
        return profile;
    }

    public static void onReceiveRequest(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        RhythmCraftProfile profile = RhythmCraftProfile.getProfileByServerPlayer((Player)player);
        RhythmCraftPacket.sendProfileS2C(profile, player);
    }

    public static void onReceiveProfileUpdate(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        Player player = packetContext.getPlayer();
        RhythmCraftProfile profile = RhythmCraftProfile.getProfileByServerPlayer(player);
        int stringSize = buf.readInt();
        ProfileDataType type = ProfileDataType.valueOf(buf.readCharSequence(stringSize, StandardCharsets.UTF_8).toString());
        switch (type) {
            case SORT_TYPE: {
                profile.sortType = SongSortType.valueOf(buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString());
                break;
            }
            case DIFFICULTY: {
                profile.difficulty = buf.readInt();
                break;
            }
            case INDEX: {
                profile.index = buf.readInt();
                break;
            }
            case CHART_SCORE: {
                stringSize = buf.readInt();
                String songId = buf.readCharSequence(stringSize, StandardCharsets.UTF_8).toString();
                int difficulty = buf.readInt();
                int score = buf.readInt();
                profile.newScore(songId, difficulty, score);
            }
        }
    }
}

