/*
 * Decompiled with CFR 0.152.
 */
package net.depression.rhythmcraft;

import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.depression.Depression;
import org.apache.commons.io.IOUtils;

public class ResourceWriter {
    public static void write() {
        block25: {
            String chartProtocol;
            block24: {
                File chartFolder = new File(Platform.getGameFolder() + "/rc_charts");
                URL chartURL = ResourceWriter.class.getResource("/assets/depression/rc_charts/");
                if (chartURL == null) {
                    Depression.LOGGER.error("Failed to copy Rhythmcraft resources. Chart folder not found in jar file.");
                    return;
                }
                chartFolder.mkdirs();
                chartProtocol = chartURL.getProtocol();
                try {
                    if (chartProtocol.equals("file")) {
                        File chartFolderFile = new File(chartURL.toURI());
                        ResourceWriter.copyDirectory(chartFolderFile, chartFolder);
                        break block24;
                    }
                    if (chartProtocol.equals("jar") || chartProtocol.equals("union")) {
                        String jarPath = ResourceWriter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                        try (JarFile jar = new JarFile(jarPath.substring(0, jarPath.lastIndexOf(".jar") + 4));){
                            Enumeration<JarEntry> entries = jar.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                String entryName = entry.getName();
                                if (!entryName.startsWith("assets/depression/rc_charts/")) continue;
                                if (entry.isDirectory()) {
                                    ResourceWriter.copyFile(jar, entry, chartFolder);
                                    continue;
                                }
                                String fileName = entryName.substring("assets/depression/rc_charts/".length());
                                if (!fileName.contains("/")) continue;
                                File parent = new File(chartFolder, fileName.substring(0, fileName.lastIndexOf(47)));
                                if (!parent.exists()) {
                                    parent.mkdirs();
                                }
                                ResourceWriter.copyFile(jar, entry, new File(parent, fileName.substring(fileName.lastIndexOf(47) + 1)));
                            }
                            break block24;
                        }
                    }
                    Depression.LOGGER.error("Failed to copy Chart resources. Unknown protocol: " + chartURL.getProtocol());
                }
                catch (Exception e) {
                    Depression.LOGGER.error("Failed to copy Chart resources.", (Throwable)e);
                }
            }
            File songFolder = new File(Platform.getGameFolder() + "/rc_songs");
            URL songURL = ResourceWriter.class.getResource("/assets/depression/rc_songs/");
            if (songURL == null) {
                Depression.LOGGER.error("Failed to copy Rhythmcraft resources. Songs folder not found in jar file.");
                return;
            }
            songFolder.mkdirs();
            try {
                if (songURL.getProtocol().equals("file")) {
                    File songFolderFile = new File(songURL.toURI());
                    ResourceWriter.copyDirectory(songFolderFile, songFolder);
                    break block25;
                }
                if (songURL.getProtocol().equals("jar") || chartProtocol.equals("union")) {
                    String jarPath = ResourceWriter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                    try (JarFile jar = new JarFile(jarPath.substring(0, jarPath.lastIndexOf(".jar") + 4));){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String entryName = entry.getName();
                            if (entry.isDirectory() || !entryName.startsWith("assets/depression/rc_songs/")) continue;
                            String fileName = entryName.substring("assets/depression/rc_songs/".length());
                            ResourceWriter.copyFile(jar, entry, new File(songFolder, fileName));
                        }
                        break block25;
                    }
                }
                Depression.LOGGER.error("Failed to copy Rhythmcraft resources. Unknown protocol: " + songURL.getProtocol());
            }
            catch (Exception e) {
                Depression.LOGGER.error("Failed to copy Rhythmcraft resources.", (Throwable)e);
            }
        }
    }

    public static void copyFile(JarFile jar, JarEntry entry, File outputFile) throws IOException {
        if (outputFile.exists()) {
            return;
        }
        try (InputStream inputStream = jar.getInputStream(entry);
             FileOutputStream outputStream = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        if (!destDir.exists()) {
            return;
        }
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File file : files) {
                File destFile = new File(destDir, file.getName());
                if (file.isDirectory()) {
                    ResourceWriter.copyDirectory(file, destFile);
                    continue;
                }
                Files.copy(file.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

