/*
 * Decompiled with CFR 0.152.
 */
package net.depression.rhythmcraft;

import com.electronwill.nightconfig.core.file.FileConfig;
import dev.architectury.platform.Platform;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import net.depression.Depression;
import net.depression.config.ServerConfig;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.Song;

public class ResourceReader {
    public static void read() {
        File songFolder = new File(Platform.getGameFolder() + "/rc_songs");
        Path songFolderPath = songFolder.toPath();
        for (File file : songFolder.listFiles()) {
            if (!file.getName().endsWith(".toml")) continue;
            String id = file.getName().substring(0, file.getName().length() - 5);
            try {
                FileConfig config = FileConfig.of((File)file);
                config.load();
                String name = (String)config.get("name");
                String author = (String)config.get("author");
                String illustrator = (String)config.get("illustrator");
                double duration = ServerConfig.readDouble(config, "duration");
                Song song = new Song(songFolderPath, id, name, author, illustrator);
                song.durationInSeconds = duration;
                song.durationInTicks = (long)(duration * 20.0);
                Song.idMap.put(id, song);
                Song.nameList.add(song);
            }
            catch (Exception e) {
                Depression.LOGGER.error("Failed to load song " + file.getName());
                e.printStackTrace();
            }
        }
        File chartFolder = new File(Platform.getGameFolder() + "/rc_charts");
        for (File idDirectory : chartFolder.listFiles()) {
            if (!idDirectory.isDirectory()) continue;
            String id = idDirectory.getName();
            Song song = Song.idMap.get(id);
            if (song == null) {
                Depression.LOGGER.error("Failed to load song " + id + ": song not found");
                continue;
            }
            for (File chartFile : idDirectory.listFiles()) {
                if (!chartFile.getName().endsWith(".toml")) continue;
                try {
                    Chart chart = new Chart(FileConfig.of((File)chartFile), idDirectory, song);
                    song.charts.set(chart.difficulty, chart);
                    Song.difficultyList.get(chart.difficulty).add(chart.song);
                }
                catch (Exception e) {
                    Depression.LOGGER.error("Failed to load chart " + chartFile.getName());
                    e.printStackTrace();
                }
            }
        }
        Song.nameList.sort(Comparator.comparing(a -> a.name));
        for (int i = 0; i < 5; ++i) {
            int finalI = i;
            Song.difficultyList.get(i).sort(Comparator.comparing(a -> a.charts.get((int)finalI).level));
        }
    }
}

