/*
 * Decompiled with CFR 0.152.
 */
package net.depression.rhythmcraft;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.depression.mental.MentalStatus;
import net.depression.mixin.rhythmcraft.PlayerListAccessor;
import net.depression.mixin.rhythmcraft.PrimaryLevelDataAccessor;
import net.depression.network.RhythmCraftPacket;
import net.depression.rhythmcraft.Chart;
import net.depression.rhythmcraft.RCMinecart;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.rhythmcraft.Song;
import net.depression.server.Registry;
import net.depression.world.dimension.ModDimensions;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayingChart
extends ServerLevel {
    public static MinecraftServer server;
    public static Executor executor;
    public static LevelStorageSource levelStorageSource;
    public static WorldData worldData;
    public static LevelStem chartStem;
    public static ChunkProgressListener chunkProgressListener;
    public static RandomSequences randomSequences;
    public static LinkedHashMap<UUID, PlayingChart> playingCharts;
    public static HashMap<UUID, CompoundTag> playerData;
    public boolean isEditMode;
    public boolean isPaused;
    public Boolean isJustStarted;
    public ServerPlayer player;
    public Chart chart;
    public RCMinecart minecart;
    public Vec3 speed = Vec3.f_82478_;
    public ConcurrentSkipListSet<BlockPos> remainingNotes;
    public double score = 0.0;
    public int scoreInt = 0;
    public int combo = 0;
    public long tickCount = 0L;
    public int prevTick = 0;
    public boolean isEnded;
    public File levelFile;
    public TreeMap<Long, Double> speedIntegration = new TreeMap();

    public PlayingChart(ServerPlayer player, Chart chart, boolean isEditMode) throws IOException {
        super(player.f_8924_, executor, levelStorageSource.m_78260_(chart.song.id + "/" + chart.levelPath), (ServerLevelData)new PrimaryLevelData(worldData.m_5926_(), worldData.m_246337_(), PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable()), ModDimensions.CHART, chartStem, chunkProgressListener, false, 0L, (List)ImmutableList.of(), false, randomSequences);
        this.player = player;
        this.chart = chart;
        this.isEditMode = isEditMode;
        this.remainingNotes = new ConcurrentSkipListSet<BlockPos>(chart.notes.comparator());
        if (!isEditMode) {
            this.remainingNotes.addAll(chart.notes);
        }
        if (isEditMode) {
            player.m_143403_(GameType.CREATIVE);
        } else {
            player.m_143403_(GameType.SURVIVAL);
        }
        BlockPos pos = chart.startingPos;
        player.m_8999_((ServerLevel)this, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        if (chart.isNeedMinecart) {
            this.minecart = new RCMinecart((Level)this, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_() + 0.5);
            this.m_7967_((Entity)this.minecart);
            player.m_7998_((Entity)this.minecart, true);
        }
        Vec3 eyePos = player.m_146892_();
        Vec3i direction = chart.direction.m_122436_();
        player.m_7618_(EntityAnchorArgument.Anchor.EYES, eyePos.m_82520_((double)direction.m_123341_(), (double)direction.m_123342_(), (double)direction.m_123343_()));
        this.levelFile = Platform.getGameFolder().resolve("rc_charts/" + chart.song.id + "/" + chart.levelPath + "/level.dat").toFile();
        CompoundTag playerTag = NbtIo.m_128937_((File)this.levelFile).m_128469_("Data").m_128469_("Player");
        ListTag inventoryTag = playerTag.m_128437_("Inventory", 10);
        player.m_150109_().m_36035_(inventoryTag);
        this.integrate(0L);
    }

    public void start() {
        this.isJustStarted = true;
    }

    public EventResult onBlockBreak(BlockPos pos) {
        if (this.chart.notes.contains(pos)) {
            ++this.scoreInt;
            ++this.combo;
            this.score = (double)this.scoreInt / (double)this.chart.notes.size() * 1000000.0;
            this.remainingNotes.remove(pos);
            RhythmCraftPacket.sendNoteChange(this.player, pos, false);
            RhythmCraftPacket.sendGameplayChange(this.player, (int)Math.round(this.score), this.combo);
            if (this.isEditMode) {
                this.chart.notes.remove(pos);
                this.chart.isEdited = true;
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
        if (this.isEditMode) {
            return EventResult.pass();
        }
        return EventResult.interruptFalse();
    }

    public void integrate(long startingTick) {
        Map.Entry<Long, Double> curEntry = this.chart.speedMap.ceilingEntry(startingTick);
        if (curEntry == null) {
            return;
        }
        do {
            Map.Entry<Long, Double> prevEntry;
            if ((prevEntry = this.chart.speedMap.lowerEntry(curEntry.getKey())) == null) {
                this.speedIntegration.put(curEntry.getKey(), 0.0);
                continue;
            }
            this.speedIntegration.put(curEntry.getKey(), this.speedIntegration.get(prevEntry.getKey()) + prevEntry.getValue() / 1200.0 * (double)(curEntry.getKey() - prevEntry.getKey()));
        } while ((curEntry = this.chart.speedMap.higherEntry(curEntry.getKey())) != null);
    }

    public void seek(long tick) {
        BlockPos pos = this.chart.startingPos;
        Vec3 start = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_() + 0.5);
        Vec3i normalInt = this.chart.direction.m_122436_();
        Vec3 normal = new Vec3((double)normalInt.m_123341_(), (double)normalInt.m_123342_(), (double)normalInt.m_123343_());
        Long lastKey = this.chart.speedMap.floorKey(tick);
        if (lastKey == null) {
            return;
        }
        Vec3 dest = start.m_82549_(normal.m_82490_(this.speedIntegration.get(lastKey) + this.chart.speedMap.get(lastKey) / 1200.0 * (double)(tick - lastKey)));
        this.player.f_8924_.execute(() -> this.minecart.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_));
        this.speed = new Vec3((double)normalInt.m_123341_(), (double)normalInt.m_123342_(), (double)normalInt.m_123343_()).m_82490_(this.chart.speedMap.get(lastKey) / 1200.0);
        if (this.chart.isNeedMinecart && !this.isPaused) {
            this.minecart.setLockedDeltaMovement(this.speed);
        }
        this.tickCount = tick;
    }

    public void m_8793_(BooleanSupplier booleanSupplier) {
        ((PrimaryLevelDataAccessor)this.m_6106_()).invokeSetGameTime(server.m_129783_().m_46467_());
        if (this.isEnded) {
            return;
        }
        if (!this.isPaused) {
            if (this.isJustStarted == null) {
                this.minecart.setLockedDeltaMovement(Vec3.f_82478_);
                super.m_8793_(booleanSupplier);
                return;
            }
            if (this.isJustStarted.booleanValue()) {
                RhythmCraftPacket.sendPlaySong(this.player, this.chart.song.id);
                this.isJustStarted = false;
            }
            BlockPos playerPos = this.player.m_20183_();
            if (!this.isEditMode) {
                for (BlockPos pos : this.remainingNotes) {
                    if (this.chart.notes.comparator().compare(pos, playerPos) >= 0 || !(this.player.m_146892_().m_82554_(pos.m_252807_()) >= 5.0)) break;
                    this.combo = 0;
                    this.remainingNotes.remove(pos);
                    RhythmCraftPacket.sendGameplayChange(this.player, (int)Math.round(this.score), this.combo);
                }
            }
            if (this.chart.speedMap.containsKey(this.tickCount)) {
                Vec3i direction = this.chart.direction.m_122436_();
                this.speed = new Vec3((double)direction.m_123341_(), (double)direction.m_123342_(), (double)direction.m_123343_()).m_82490_(this.chart.speedMap.get(this.tickCount) / 1200.0);
                if (this.chart.isNeedMinecart) {
                    this.minecart.setLockedDeltaMovement(this.speed);
                }
            } else {
                this.player.m_20256_(this.speed);
            }
            if (this.chart.timeMap.containsKey(this.tickCount)) {
                long time = this.chart.timeMap.get(this.tickCount);
                this.m_8615_(time);
                RhythmCraftPacket.sendTimeChange(this.player, time);
            }
            ++this.tickCount;
            if (this.tickCount > this.chart.song.durationInTicks) {
                this.minecart.setLockedDeltaMovement(Vec3.f_82478_);
                RhythmCraftProfile profile = RhythmCraftProfile.getProfileByServerPlayer((Player)this.player);
                int prevScore = 0;
                ArrayList<Integer> scores = profile.chartScores.get(this.chart.song.id);
                if (scores != null && scores.size() > this.chart.difficulty) {
                    prevScore = scores.get(this.chart.difficulty);
                }
                double mentalHealValue = 0.0;
                if (this.score == 1000000.0) {
                    mentalHealValue = Math.max(mentalHealValue, (double)this.chart.level / 16.0);
                }
                if (this.score > (double)prevScore) {
                    mentalHealValue = Math.max(mentalHealValue, (this.score - (double)prevScore) * (double)this.chart.level / 6400000.0);
                }
                if (mentalHealValue > 0.0) {
                    MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer((Player)this.player);
                    mentalStatus.mentalHeal("rhythmcraft", mentalHealValue);
                }
                RhythmCraftPacket.sendGameEnd(this.player, (int)Math.round(this.score), this.scoreInt, prevScore);
                profile.newScore(this.chart.song.id, this.chart.difficulty, (int)Math.round(this.score));
                this.isEnded = true;
            }
        }
        super.m_8793_(booleanSupplier);
    }

    public void m_8643_(@Nullable ProgressListener progressListener, boolean bl, boolean bl2) {
        if (this.isEditMode) {
            super.m_8643_(progressListener, bl, bl2);
            this.chart.save();
            try {
                CompoundTag levelTag = NbtIo.m_128937_((File)this.levelFile);
                levelTag.m_128469_("Data").m_128365_("Player", (Tag)this.player.m_20240_(new CompoundTag()));
                NbtIo.m_128944_((CompoundTag)levelTag, (File)this.levelFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onReceiveReadChart(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        String songId = buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString();
        int difficulty = buf.readInt();
        boolean isEditMode = buf.readBoolean();
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        if (isEditMode) {
            if (player.m_20310_(2)) {
                RhythmCraftPacket.sendAcceptEdit(player);
            } else {
                return;
            }
        }
        player.f_8924_.execute(() -> {
            Song song = Song.idMap.get(songId);
            if (song == null) {
                return;
            }
            Chart chart = song.charts.get(difficulty);
            if (chart == null) {
                return;
            }
            try {
                PlayerListAccessor accessor = (PlayerListAccessor)player.f_8924_.m_6846_();
                accessor.invokeSave(player);
                playerData.put(player.m_20148_(), player.m_20240_(new CompoundTag()));
                PlayingChart playingChart = new PlayingChart(player, chart, isEditMode);
                playingCharts.put(player.m_20148_(), playingChart);
            }
            catch (IOException e) {
                playerData.remove(player.m_20148_());
                playingCharts.remove(player.m_20148_());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    public static void onReceiveReady(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        player.f_8924_.execute(() -> {
            PlayingChart playingChart = playingCharts.get(player.m_20148_());
            if (playingChart == null) {
                return;
            }
            playingChart.start();
        });
    }

    public static void onReceiveLoadBack(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        player.f_8924_.execute(() -> {
            UUID uuid = player.m_20148_();
            if (!playerData.containsKey(uuid)) {
                return;
            }
            CompoundTag compoundTag = playerData.get(uuid);
            player.m_20258_(compoundTag);
            DataResult dataResult = DimensionType.m_63911_((Dynamic)new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("Dimension")));
            ResourceKey resourceKey = dataResult.result().orElse(Level.f_46428_);
            ServerLevel serverLevel = server.m_129880_(resourceKey);
            player.m_8999_(serverLevel, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
            playingCharts.remove(uuid);
            playerData.remove(uuid);
            Registry.particles.remove(uuid.toString());
        });
    }

    public static void onReceivePauseChange(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        PlayingChart playingChart = playingCharts.get(packetContext.getPlayer().m_20148_());
        long tick = buf.readLong();
        playingChart.isPaused = !playingChart.isPaused;
        playingChart.player.f_8924_.execute(() -> {
            if (playingChart.isPaused) {
                playingChart.seek(tick);
                playingChart.minecart.setLockedDeltaMovement(Vec3.f_82478_);
            } else {
                playingChart.minecart.setLockedDeltaMovement(playingChart.speed);
            }
        });
    }

    public static void onReceiveProgressChange(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        long tick;
        PlayingChart playingChart = playingCharts.get(packetContext.getPlayer().m_20148_());
        playingChart.tickCount = tick = buf.readLong();
        playingChart.seek(tick);
    }

    static {
        levelStorageSource = new LevelStorageSource(Platform.getGameFolder().resolve("rc_charts"), Platform.getGameFolder().resolve("rc_charts"), null, null);
        playingCharts = new LinkedHashMap();
        playerData = new HashMap();
    }
}

