/*
 * Decompiled with CFR 0.152.
 */
package net.depression.rhythmcraft;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.depression.rhythmcraft.Song;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;

public class Chart {
    public FileConfig config;
    public boolean isEdited;
    public Song song;
    public String author;
    public int difficulty;
    public int level;
    public BlockPos startingPos;
    public Direction direction;
    public boolean isNeedMinecart = true;
    public String levelPath;
    public TreeSet<BlockPos> notes;
    public TreeMap<Long, Double> speedMap = new TreeMap();
    public HashMap<Long, Long> timeMap = new HashMap();

    public Chart(FileConfig config, File idDirectory, Song song) throws IOException {
        Integer value;
        Number value2;
        Object object;
        long key;
        Config map;
        this.config = config;
        this.song = song;
        config.load();
        this.author = (String)config.get("author");
        this.difficulty = (Integer)config.get("difficulty");
        this.level = (Integer)config.get("level");
        List list = (List)config.get("starting_pos");
        this.startingPos = new BlockPos(((Integer)list.get(0)).intValue(), ((Integer)list.get(1)).intValue(), ((Integer)list.get(2)).intValue());
        this.direction = Direction.m_122402_((String)((String)config.get("direction")));
        if (this.direction == null) {
            throw new IllegalArgumentException("Invalid direction");
        }
        switch (this.direction) {
            case NORTH: {
                this.notes = new TreeSet((pos1, pos2) -> {
                    int z = Integer.compare(pos2.m_123343_(), pos1.m_123343_());
                    if (z != 0) {
                        return z;
                    }
                    int x = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
                });
                break;
            }
            case SOUTH: {
                this.notes = new TreeSet((pos1, pos2) -> {
                    int z = Integer.compare(pos1.m_123343_(), pos2.m_123343_());
                    if (z != 0) {
                        return z;
                    }
                    int x = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
                });
                break;
            }
            case WEST: {
                this.notes = new TreeSet((pos1, pos2) -> {
                    int x = Integer.compare(pos2.m_123341_(), pos1.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    int z = Integer.compare(pos1.m_123343_(), pos2.m_123343_());
                    if (z != 0) {
                        return z;
                    }
                    return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
                });
                break;
            }
            case EAST: {
                this.notes = new TreeSet((pos1, pos2) -> {
                    int x = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    int z = Integer.compare(pos1.m_123343_(), pos2.m_123343_());
                    if (z != 0) {
                        return z;
                    }
                    return Integer.compare(pos1.m_123342_(), pos2.m_123342_());
                });
                break;
            }
            case DOWN: {
                this.isNeedMinecart = false;
                this.notes = new TreeSet((pos1, pos2) -> {
                    int y = Integer.compare(pos2.m_123342_(), pos1.m_123342_());
                    if (y != 0) {
                        return y;
                    }
                    int x = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    return Integer.compare(pos1.m_123343_(), pos2.m_123343_());
                });
                break;
            }
            case UP: {
                this.isNeedMinecart = false;
                this.notes = new TreeSet((pos1, pos2) -> {
                    int y = Integer.compare(pos1.m_123342_(), pos2.m_123342_());
                    if (y != 0) {
                        return y;
                    }
                    int x = Integer.compare(pos1.m_123341_(), pos2.m_123341_());
                    if (x != 0) {
                        return x;
                    }
                    return Integer.compare(pos1.m_123343_(), pos2.m_123343_());
                });
            }
        }
        this.levelPath = (String)config.get("level_file");
        for (ArrayList note : (ArrayList)config.get("notes")) {
            this.notes.add(new BlockPos(((Integer)note.get(0)).intValue(), ((Integer)note.get(1)).intValue(), ((Integer)note.get(2)).intValue()));
        }
        Iterator iterator = config.get("speed");
        if (iterator instanceof Config) {
            map = (Config)iterator;
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Config.Entry entry = (Config.Entry)iterator.next();
                key = Long.parseLong(entry.getKey());
                object = entry.getValue();
                if (object instanceof Double) {
                    value2 = (Double)object;
                    this.speedMap.put(key, (Double)value2);
                    continue;
                }
                object = entry.getValue();
                if (!(object instanceof Integer)) continue;
                value = (Integer)object;
                this.speedMap.put(key, (double)value);
            }
        }
        if ((iterator = config.get("time")) instanceof Config) {
            map = (Config)iterator;
            for (Config.Entry entry : map.entrySet()) {
                key = Long.parseLong(entry.getKey());
                object = entry.getValue();
                if (object instanceof Long) {
                    value2 = (Long)object;
                    this.timeMap.put(key, (Long)value2);
                    continue;
                }
                object = entry.getValue();
                if (!(object instanceof Integer)) continue;
                value = (Integer)object;
                this.timeMap.put(key, (long)value);
            }
        }
    }

    public BlockPos getMinBoundary(ChunkPos chunkPos) {
        return switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new BlockPos(0, 0, chunkPos.m_45609_() + 1);
            case Direction.SOUTH -> new BlockPos(0, 0, chunkPos.m_45605_() - 1);
            case Direction.WEST -> new BlockPos(chunkPos.m_45608_() + 1, 0, 0);
            case Direction.EAST -> new BlockPos(chunkPos.m_45604_() - 1, 0, 0);
            case Direction.DOWN -> new BlockPos(0, Minecraft.m_91087_().f_91073_.m_151558_() + 1, 0);
            case Direction.UP -> new BlockPos(0, Minecraft.m_91087_().f_91073_.m_141937_() - 1, 0);
        };
    }

    public BlockPos getMaxBoundary(ChunkPos chunkPos) {
        return switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new BlockPos(0, 0, chunkPos.m_45605_() - 1);
            case Direction.SOUTH -> new BlockPos(0, 0, chunkPos.m_45609_() + 1);
            case Direction.WEST -> new BlockPos(chunkPos.m_45604_() - 1, 0, 0);
            case Direction.EAST -> new BlockPos(chunkPos.m_45608_() + 1, 0, 0);
            case Direction.DOWN -> new BlockPos(0, Minecraft.m_91087_().f_91073_.m_141937_() - 1, 0);
            case Direction.UP -> new BlockPos(0, Minecraft.m_91087_().f_91073_.m_151558_() + 1, 0);
        };
    }

    public void save() {
        if (!this.isEdited) {
            return;
        }
        this.isEdited = false;
        this.config.set("author", (Object)this.author);
        this.config.set("difficulty", (Object)this.difficulty);
        this.config.set("starting_pos", Arrays.asList(this.startingPos.m_123341_(), this.startingPos.m_123342_(), this.startingPos.m_123343_()));
        this.config.set("direction", (Object)this.direction.m_122433_());
        this.config.set("level_file", (Object)this.levelPath);
        ArrayList<List<Integer>> notesList = new ArrayList<List<Integer>>();
        for (BlockPos blockPos : this.notes) {
            notesList.add(Arrays.asList(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
        }
        this.config.set("notes", notesList);
        Config speedMapTable = Config.of((ConfigFormat)this.config.configFormat());
        for (Map.Entry<Long, Double> entry : this.speedMap.entrySet()) {
            speedMapTable.add(entry.getKey().toString(), (Object)entry.getValue());
        }
        this.config.set("speed", (Object)speedMapTable);
        Config config = Config.of((ConfigFormat)this.config.configFormat());
        for (Map.Entry<Long, Long> entry : this.timeMap.entrySet()) {
            config.add(entry.getKey().toString(), (Object)entry.getValue());
        }
        this.config.set("time", (Object)config);
        this.config.save();
    }
}

