/*
 * Decompiled with CFR 0.152.
 */
package net.depression.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.depression.rhythmcraft.ProfileDataType;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class RhythmCraftPacket {
    public static final ResourceLocation READ_CHART_PACKET = new ResourceLocation("depression", "rc_read_chart_packet");
    public static final ResourceLocation READY_PACKET = new ResourceLocation("depression", "rc_ready_packet");
    public static final ResourceLocation PLAY_SONG_PACKET = new ResourceLocation("depression", "rc_play_song_packet");
    public static final ResourceLocation PROFILE_REQUEST_PACKET = new ResourceLocation("depression", "rc_profile_request_packet");
    public static final ResourceLocation PROFILE_PACKET = new ResourceLocation("depression", "rc_profile_packet");
    public static final ResourceLocation ACCEPT_EDIT_PACKET = new ResourceLocation("depression", "rc_accept_edit_packet");
    public static final ResourceLocation NOTE_CHANGE_PACKET = new ResourceLocation("depression", "rc_note_change_packet");
    public static final ResourceLocation PAUSE_CHANGE_PACKET = new ResourceLocation("depression", "rc_pause_packet");
    public static final ResourceLocation PROGRESS_CHANGE_PACKET = new ResourceLocation("depression", "rc_progress_change_packet");
    public static final ResourceLocation GAMEPLAY_CHANGE_PACKET = new ResourceLocation("depression", "rc_gameplay_change_packet");
    public static final ResourceLocation SPACE_CHANGE_PACKET = new ResourceLocation("depression", "rc_space_change_packet");
    public static final ResourceLocation TIME_CHANGE_PACKET = new ResourceLocation("depression", "rc_time_change_packet");
    public static final ResourceLocation GAME_END_PACKET = new ResourceLocation("depression", "rc_game_end_packet");
    public static final ResourceLocation LOAD_BACK_PACKET = new ResourceLocation("depression", "rc_load_back_packet");

    public static void sendReadChart(String songId, int difficulty, boolean isEditMode) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(songId.length());
        buf.writeCharSequence((CharSequence)songId, StandardCharsets.UTF_8);
        buf.writeInt(difficulty);
        buf.writeBoolean(isEditMode);
        NetworkManager.sendToServer((ResourceLocation)READ_CHART_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendReady() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkManager.sendToServer((ResourceLocation)READY_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendPlaySong(ServerPlayer player, String id) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeCharSequence((CharSequence)id, StandardCharsets.UTF_8);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)PLAY_SONG_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendProfileRequest() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkManager.sendToServer((ResourceLocation)PROFILE_REQUEST_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendProfileS2C(RhythmCraftProfile profile, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(profile.sortType.name().length());
        buf.writeCharSequence((CharSequence)profile.sortType.name(), StandardCharsets.UTF_8);
        buf.writeInt(profile.difficulty);
        buf.writeInt(profile.index);
        for (String key : profile.chartScores.keySet()) {
            buf.writeInt(key.length());
            buf.writeCharSequence((CharSequence)key, StandardCharsets.UTF_8);
            ArrayList<Integer> scores = profile.chartScores.get(key);
            buf.writeInt(scores.size());
            for (int score : scores) {
                buf.writeInt(score);
            }
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)PROFILE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendProfileUpdateC2S(RhythmCraftProfile profile, ProfileDataType type) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(type.name().length());
        buf.writeCharSequence((CharSequence)type.name(), StandardCharsets.UTF_8);
        switch (type) {
            case SORT_TYPE: {
                buf.writeInt(profile.sortType.name().length());
                buf.writeCharSequence((CharSequence)profile.sortType.name(), StandardCharsets.UTF_8);
                break;
            }
            case DIFFICULTY: {
                buf.writeInt(profile.difficulty);
                break;
            }
            case INDEX: {
                buf.writeInt(profile.index);
            }
        }
        NetworkManager.sendToServer((ResourceLocation)PROFILE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendAcceptEdit(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ACCEPT_EDIT_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendNoteChange(ServerPlayer player, BlockPos pos, boolean isAdd) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130064_(pos);
        buf.writeBoolean(isAdd);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NOTE_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendPauseChange(long tick) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeLong(tick);
        NetworkManager.sendToServer((ResourceLocation)PAUSE_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendProgressChange(long tick) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeLong(tick);
        NetworkManager.sendToServer((ResourceLocation)PROGRESS_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendTimeChange(ServerPlayer player, long tick) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeLong(tick);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)TIME_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendGameplayChange(ServerPlayer player, int score, int combo) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(score);
        buf.writeInt(combo);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)GAMEPLAY_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendGameEnd(ServerPlayer player, int score, int hits, int prevBest) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(score);
        buf.writeInt(hits);
        buf.writeInt(prevBest);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)GAME_END_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendLoadBack() {
        NetworkManager.sendToServer((ResourceLocation)LOAD_BACK_PACKET, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer()));
    }

    public static void sendSpaceChange(ServerPlayer player, int space) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(space);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)SPACE_CHANGE_PACKET, (FriendlyByteBuf)buf);
    }
}

