/*
 * Decompiled with CFR 0.152.
 */
package net.depression.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.depression.item.diary.ConditionComponents;
import net.depression.mental.MentalStatus;
import net.depression.server.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DiaryUpdatePacket {
    public static final ResourceLocation DIARY_UPDATE_PACKET = new ResourceLocation("depression", "diary_update_packet");
    public static Charset charset = StandardCharsets.UTF_8;

    public static void sendToServer(String content) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeCharSequence((CharSequence)content, charset);
        NetworkManager.sendToServer((ResourceLocation)DIARY_UPDATE_PACKET, (FriendlyByteBuf)buf);
    }

    public static void sendToPlayer(ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        MentalStatus mentalStatus = Registry.mentalStatus.get(player.m_20148_());
        double mentalHealthValue = mentalStatus == null ? 100.0 : mentalStatus.mentalHealthValue;
        Object content = "";
        if (85.0 <= mentalHealthValue && mentalHealthValue <= 100.0) {
            content = "    'diary.depression.healthy_1.1'\n    " + ConditionComponents.HEALTHY_1_WEATHER.get(player) + ConditionComponents.HEALTHY_1_BREED.get(player) + ConditionComponents.HEALTHY_1_EAT.get(player) + "\n    'diary.depression.healthy_1.2'" + ConditionComponents.HEALTHY_1_KILL_MOBS.get(player);
        } else if (70.0 <= mentalHealthValue && mentalHealthValue < 85.0) {
            content = "    'diary.depression.healthy_2.1'\n    " + ConditionComponents.HEALTHY_2_BREED.get(player) + ConditionComponents.HEALTHY_2_WEATHER.get(player) + ConditionComponents.HEALTHY_2_MOVE_IN_WEATHER.get(player) + "\n    'diary.depression.healthy_2.2'";
        } else if (55.0 <= mentalHealthValue && mentalHealthValue < 70.0) {
            content = "    'diary.depression.mild_depression_1.1'\n    " + ConditionComponents.MILD_DEPRESSION_1_WEATHER.get(player) + ConditionComponents.MILD_DEPRESSION_1_MOVE_IN_WEATHER.get(player) + "\n    'diary.depression.mild_depression_1.2'" + ConditionComponents.MILD_DEPRESSION_1_MOVE.get(player);
        } else if (40.0 <= mentalHealthValue && mentalHealthValue < 55.0) {
            content = "    'diary.depression.mild_depression_2.1'\n    " + ConditionComponents.MILD_DEPRESSION_2_WEATHER.get(player) + ConditionComponents.MILD_DEPRESSION_2_EAT.get(player) + "\n    'diary.depression.mild_depression_2.2'" + ConditionComponents.MILD_DEPRESSION_2_HURT.get(player);
        } else if (30.0 <= mentalHealthValue && mentalHealthValue < 40.0) {
            content = "    'diary.depression.moderate_depression_1.1'\n    " + ConditionComponents.MODERATE_DEPRESSION_1_KILL_ENTITIES.get(player) + ConditionComponents.MODERATE_DEPRESSION_1_WEATHER.get(player) + ConditionComponents.MODERATE_DEPRESSION_1_EAT.get(player) + ConditionComponents.MODERATE_DEPRESSION_1_HURT.get(player) + "\n    'diary.depression.moderate_depression_1.2'" + ConditionComponents.MODERATE_DEPRESSION_1_MOB_NEARBY.get(player);
        } else if (20.0 <= mentalHealthValue && mentalHealthValue < 30.0) {
            content = "    'diary.depression.moderate_depression_2.1'\n    'diary.depression.moderate_depression_2.2'" + ConditionComponents.MODERATE_DEPRESSION_2_EAT.get(player) + "\n    'diary.depression.moderate_depression_2.3'" + ConditionComponents.MODERATE_DEPRESSION_2_HURT.get(player);
        } else if (10.0 <= mentalHealthValue && mentalHealthValue < 20.0) {
            content = mentalStatus.isMania() ? "    'diary.depression.mania_1.1'" : "    'diary.depression.major_depressive_disorder_1.1'";
        } else if (0.0 <= mentalHealthValue && mentalHealthValue < 10.0) {
            content = mentalStatus.isMania() ? "    'diary.depression.mania_2.1'" : "    'diary.depression.major_depressive_disorder_2.1'" + ConditionComponents.MAJOR_DEPRESSIVE_DISORDER_2_EAT.get(player) + "\n    'diary.depression.major_depressive_disorder_2.2'";
        }
        buf.writeCharSequence((CharSequence)content, charset);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)DIARY_UPDATE_PACKET, (FriendlyByteBuf)buf);
    }
}

