/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mixin.client;

import java.util.ArrayList;
import net.depression.client.DepressionClient;
import net.depression.client.rhythmcraft.ClientPlayingChart;
import net.depression.mental.PTSDManager;
import net.depression.network.PlaySoundPacket;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin {
    @Shadow
    public abstract ClientChunkCache m_7726_();

    @Shadow
    protected abstract LevelEntityGetter<Entity> m_142646_();

    @Inject(method={"setDayTime"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickTime(CallbackInfo ci) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        if (playingChart != null && playingChart.isTimeFreeze) {
            ci.cancel();
        }
    }

    @Inject(method={"entitiesForRendering"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyEntitiesForRendering(CallbackInfoReturnable<Iterable<Entity>> cir) {
        ClientPlayingChart playingChart = DepressionClient.playingChart;
        if (playingChart != null) {
            ArrayList<Object> entities = new ArrayList<Object>();
            for (Entity entity : this.m_142646_().m_142273_()) {
                entities.add(entity);
            }
            entities.addAll(playingChart.highlightedNotes.values());
            cir.setReturnValue(entities);
        }
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    private void onChunkLoad(ChunkPos chunkPos, CallbackInfo ci) {
        if (DepressionClient.playingChart != null) {
            DepressionClient.playingChart.onChunkLoad(chunkPos);
        }
    }

    @Inject(method={"unload"}, at={@At(value="HEAD")})
    private void onChunkUnload(LevelChunk levelChunk, CallbackInfo ci) {
        if (DepressionClient.playingChart != null) {
            DepressionClient.playingChart.onChunkUnload(levelChunk.m_7697_());
        }
    }

    @Inject(method={"playLocalSound"}, at={@At(value="HEAD")})
    private void playLocalSound(double d, double e, double f, SoundEvent soundEvent, SoundSource soundSource, float g, float h, boolean bl, CallbackInfo ci) {
        String id = soundEvent.m_11660_().toString();
        if (PTSDManager.soundEventMap.containsKey(id)) {
            PlaySoundPacket.sendToServer(id);
        }
    }
}

