/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mixin.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.depression.client.screen.DiaryAccess;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public abstract class BookViewScreenMixin
extends Screen {
    @Unique
    private static final ResourceLocation DIARY_LOCATION = new ResourceLocation("depression", "textures/gui/diary.png");
    @Shadow
    private BookViewScreen.BookAccess f_98253_;
    @Shadow
    private int f_98256_;
    @Shadow
    private int f_98254_;
    @Shadow
    private List<FormattedCharSequence> f_98255_;
    @Shadow
    private Component f_98257_;

    @Shadow
    protected abstract int m_98300_();

    @Shadow
    @Nullable
    public abstract Style m_98268_(double var1, double var3);

    protected BookViewScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (!(this.f_98253_ instanceof DiaryAccess)) {
            return;
        }
        this.m_280273_(guiGraphics);
        int k = (this.f_96543_ - 192) / 2;
        guiGraphics.m_280218_(DIARY_LOCATION, k, 2, 0, 0, 192, 192);
        if (this.f_98256_ != this.f_98254_) {
            String text = this.f_98253_.m_98310_(this.f_98254_).getString();
            int spaceCount = 0;
            for (char c : text.toCharArray()) {
                if (c != ' ') continue;
                ++spaceCount;
            }
            boolean isLatin = spaceCount > 24;
            StringSplitter splitter = this.f_96547_.m_92865_();
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            while (!text.isEmpty()) {
                int displayIndex;
                int index;
                if (isLatin) {
                    displayIndex = index = splitter.m_168634_(text, 114, Style.f_131099_);
                } else {
                    displayIndex = index = splitter.m_168626_(text, 114, Style.f_131099_);
                    for (int l = 0; l < index; ++l) {
                        if (text.charAt(l) != '\n') continue;
                        index = l + 1;
                        displayIndex = l;
                        break;
                    }
                }
                if (index < text.length() && text.charAt(index) == '\n') {
                    ++index;
                }
                list.add(Language.m_128107_().m_5536_(FormattedText.m_130775_((String)text.substring(0, displayIndex))));
                text = text.substring(index);
            }
            this.f_98255_ = list;
            this.f_98257_ = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.f_98254_ + 1, Math.max(this.m_98300_(), 1)});
        }
        this.f_98256_ = this.f_98254_;
        int m = this.f_96547_.m_92852_((FormattedText)this.f_98257_);
        guiGraphics.m_280614_(this.f_96547_, this.f_98257_, k - m + 192 - 44, 18, 0, false);
        Objects.requireNonNull(this.f_96547_);
        int n = Math.min(14, this.f_98255_.size());
        for (int o = 0; o < n; ++o) {
            FormattedCharSequence formattedCharSequence = this.f_98255_.get(o);
            Font var10001 = this.f_96547_;
            int var10003 = k + 36;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(var10001, formattedCharSequence, var10003, 32 + o * 9, 0, false);
        }
        Style style = this.m_98268_(i, j);
        if (style != null) {
            guiGraphics.m_280304_(this.f_96547_, style, i, j);
        }
        super.m_88315_(guiGraphics, i, j, f);
        ci.cancel();
    }
}

