/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mixin;

import java.util.UUID;
import net.depression.effect.ModEffects;
import net.depression.item.MedicineItem;
import net.depression.mental.MentalIllness;
import net.depression.mental.MentalStatus;
import net.depression.network.MentalStatusPacket;
import net.depression.rhythmcraft.PlayingChart;
import net.depression.rhythmcraft.RhythmCraftProfile;
import net.depression.server.Registry;
import net.depression.server.StatManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        StatManager stat = Registry.statManager.get(player.m_20148_());
        if (stat == null) {
            stat = new StatManager();
            Registry.statManager.put(player.m_20148_(), stat);
        }
        if (player.m_9236_().m_46468_() % 24000L == 0L) {
            stat.updateStat((ServerPlayer)player);
        }
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        if (player.m_7500_() || player.m_5833_() || player.m_21224_()) {
            if (mentalStatus.ptsdManager.hasRemaining()) {
                mentalStatus.ptsdManager.clear((ServerPlayer)player);
            }
            return;
        }
        mentalStatus.tick((ServerPlayer)player);
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="TAIL")})
    private void stopSleepInBed(boolean bl, boolean bl2, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_() || bl || bl2 || player.m_7500_()) {
            return;
        }
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        mentalStatus.mentalIllness.medicineDelay.remove("depression:insomnia_tablet");
        Boolean isInsomnia = mentalStatus.mentalIllness.isInsomnia;
        boolean isSleepy = player.m_21023_((MobEffect)ModEffects.SLEEPINESS.get());
        if (isSleepy) {
            player.m_21195_((MobEffect)ModEffects.SLEEPINESS.get());
        }
        if (!isSleepy && isInsomnia != null && isInsomnia.booleanValue() || mentalStatus.isMania()) {
            return;
        }
        if (mentalStatus.emotionValue < -5.0 * Math.max(mentalStatus.mentalHealthValue, 10.0) / 100.0) {
            mentalStatus.emotionValue = 0.0;
        } else {
            mentalStatus.mentalHeal(5.0);
        }
        mentalStatus.mentalIllness.isInsomnia = null;
        mentalStatus.mentalIllness.sleepAttemptCount = 0;
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    private void eat(Level level, ItemStack itemStack, CallbackInfoReturnable<ItemStack> cir) {
        Item item;
        String id;
        if (level.m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this;
        StatManager stat = Registry.statManager.get(player.m_20148_());
        stat.hasAte = true;
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer((Player)player);
        MentalIllness mentalIllness = mentalStatus.mentalIllness;
        if (mentalIllness.mentalHealthId >= 3 && !mentalIllness.isMania && !(itemStack.m_41720_() instanceof MedicineItem)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        }
        if (MentalStatus.foodHealValue.containsKey(id = (item = itemStack.m_41720_()).arch$registryName().toString())) {
            mentalStatus.mentalHeal(id, MentalStatus.foodHealValue.get(id));
        } else {
            FoodProperties foodProperties = item.m_41473_();
            mentalStatus.mentalHeal(id, (double)((float)foodProperties.m_38744_() * (1.0f + foodProperties.m_38745_() * 2.0f) * foodProperties.m_38745_()) * MentalStatus.FOOD_HEAL_RATE);
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V")})
    private void actuallyHurt(DamageSource damageSource, float f, CallbackInfo ci) {
        boolean ifMentalHurt;
        Player player = (Player)this;
        if (player.m_7500_() || player.m_5833_() || Registry.playerEventMap.containsKey(player.m_20148_())) {
            return;
        }
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        f = Math.min(f, player.m_21223_());
        double damageRate = f / player.m_21233_() * 20.0f;
        double healthRate = player.m_21223_() / player.m_21233_();
        double minValue = healthRate * 3.0;
        boolean bl = ifMentalHurt = (damageRate -= minValue) > 0.0;
        if (ifMentalHurt) {
            damageRate *= Math.sqrt(damageRate);
        }
        Entity entity = damageSource.m_7639_();
        Entity directEntity = damageSource.m_7640_();
        try {
            if (entity != null) {
                if (entity instanceof Player) {
                    mentalStatus.triggerHurt(entity.m_5446_().getString());
                    if (ifMentalHurt) {
                        mentalStatus.mentalHurt(entity.m_5446_(), damageRate);
                    }
                } else {
                    String encodeId = entity.m_20078_();
                    String directEncodeId = directEntity.m_20078_();
                    if (encodeId == null) {
                        return;
                    }
                    if (!encodeId.equals(directEncodeId)) {
                        mentalStatus.triggerHurt(encodeId);
                        mentalStatus.triggerHurt(directEncodeId);
                        if (ifMentalHurt) {
                            mentalStatus.mentalHurt(encodeId, damageRate * 0.8);
                            mentalStatus.mentalHurt(directEncodeId, damageRate * 0.2);
                        }
                    } else {
                        mentalStatus.triggerHurt(encodeId);
                        if (ifMentalHurt) {
                            mentalStatus.mentalHurt(encodeId, damageRate);
                        }
                    }
                }
                if (mentalStatus.emotionValue <= 2.0) {
                    mentalStatus.combatCountdown = 10;
                }
            } else {
                mentalStatus.triggerHurt(damageSource.m_19385_());
                if (ifMentalHurt) {
                    mentalStatus.mentalHurt(damageSource.m_19385_(), damageRate);
                }
            }
            if (ifMentalHurt) {
                MentalStatusPacket.sendToPlayer((ServerPlayer)player, mentalStatus);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Inject(method={"wantsToStopRiding"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStopRiding(CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player;
        Player player2 = (Player)this;
        if (player2 instanceof ServerPlayer && PlayingChart.playingCharts.containsKey((player = (ServerPlayer)player2).m_20148_()) && !PlayingChart.playingCharts.get((Object)player.m_20148_()).isEditMode) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        mentalStatus.readNbt(tag);
        RhythmCraftProfile profile = RhythmCraftProfile.getProfileByServerPlayer(player);
        profile.readNbt(tag);
        StatManager statManager = Registry.statManager.get(player.m_20148_());
        if (statManager == null) {
            statManager = new StatManager();
            Registry.statManager.put(player.m_20148_(), statManager);
        }
        if (tag.m_128441_("old_stats")) {
            CompoundTag oldStats = tag.m_128469_("old_stats");
            statManager.readNbt(oldStats);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = player.m_20148_();
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        mentalStatus.writeNbt(tag);
        RhythmCraftProfile profile = RhythmCraftProfile.getProfileByServerPlayer(player);
        profile.writeNbt(tag);
        StatManager stat = Registry.statManager.get(uuid);
        if (stat == null) {
            return;
        }
        CompoundTag oldStats = tag.m_128441_("old_stats") ? tag.m_128469_("old_stats") : new CompoundTag();
        stat.writeNbt(oldStats);
        tag.m_128365_("old_stats", (Tag)oldStats);
        if (Registry.quitPlayers.contains(uuid)) {
            Registry.quitPlayers.remove(uuid);
            Registry.mentalStatus.remove(uuid);
            Registry.statManager.remove(uuid);
        }
    }
}

