/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mental;

import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.depression.mental.MentalStatus;
import net.depression.mixin.MobAccess;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.PTSDOnsetPacket;
import net.depression.server.Registry;
import net.depression.sound.ModSounds;
import net.depression.util.TempValues;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class PTSDManager {
    public static final double PTSD_MAX_VALUE = 40.0;
    public static final double PTSD_4_VALUE = 36.0;
    public static final double PTSD_3_VALUE = 32.0;
    public static final double PTSD_2_VALUE = 26.0;
    public static final double PTSD_1_VALUE = 20.0;
    public static double KILL_PTSD_DECREASE;
    public static double ONSET_EMOTION_DECREASE;
    public static HashMap<String, List<String>> soundEventMap;
    public static HashMap<String, List<SoundEvent>> damageSourceMap;
    private final MentalStatus mentalStatus;
    private final ConcurrentHashMap<String, Double> PTSD;
    private double currentMaxPTSDValue;
    private final ConcurrentHashMap<String, Integer> contactValue = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> remainingValue = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ArrayDeque<Entity>> entities = new ConcurrentHashMap();
    private Integer phonismCountdown;
    private Integer photismCountdown;
    public final LinkedHashSet<String> phonismId = new LinkedHashSet();
    public final LinkedHashSet<String> photismId = new LinkedHashSet();
    private final Random random = new Random();

    public PTSDManager(MentalStatus mentalStatus, ConcurrentHashMap<String, Double> PTSD) {
        this.mentalStatus = mentalStatus;
        this.PTSD = PTSD;
    }

    public static void addEntry(String damageSource, String soundEvent) {
        soundEventMap.computeIfAbsent(soundEvent, k -> new ArrayList()).add(damageSource);
        damageSourceMap.computeIfAbsent(damageSource, k -> new ArrayList()).add(SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(soundEvent)));
    }

    public synchronized void tick(ServerPlayer player) {
        boolean ifSendRelief = false;
        this.currentMaxPTSDValue = 0.0;
        for (String key : this.remainingValue.keySet()) {
            Object ptsdValue = this.PTSD.get(key);
            if (ptsdValue == null) {
                this.remainingValue.remove(key);
                this.contactValue.remove(key);
                this.entities.remove(key);
                continue;
            }
            Integer contactCount = this.contactValue.get(key);
            if (contactCount == null) {
                this.remainingValue.remove(key);
                this.entities.remove(key);
                continue;
            }
            double initialDecreaseValue = (Double)ptsdValue > 20.0 ? -0.1 : 0.0;
            double decreaseValue = initialDecreaseValue + (double)contactCount.intValue() * 0.005;
            ptsdValue = (Double)ptsdValue - Math.min(decreaseValue, 0.1);
            ptsdValue = Math.min((Double)ptsdValue, 40.0);
            this.PTSD.put(key, (Double)ptsdValue);
            if (decreaseValue > 0.05 && initialDecreaseValue + (double)(contactCount - 1) * 0.005 <= 0.05) {
                EntityType.m_20632_((String)key).ifPresentOrElse(entityType -> ActionbarHintPacket.sendPTSDRemissionPacket(player, entityType.m_20676_()), () -> {
                    if (this.mentalStatus.playerPTSDSet.contains(key)) {
                        ActionbarHintPacket.sendPTSDRemissionPacket(player, (Component)Component.m_237113_((String)key));
                    } else {
                        ActionbarHintPacket.sendPTSDRemissionPacket(player, (Component)Component.m_237115_((String)("message.depression.damagesource." + key)));
                    }
                });
            }
            if ((Double)ptsdValue < 0.0) {
                this.remainingValue.remove(key);
                this.contactValue.remove(key);
                this.entities.remove(key);
                this.mentalStatus.removePTSD(key);
                continue;
            }
            int remainingTime = this.remainingValue.get(key);
            if (remainingTime > 1) {
                this.remainingValue.put(key, remainingTime - 1);
                this.contactValue.put(key, this.contactValue.get(key) + 1);
                this.currentMaxPTSDValue = Math.max(this.currentMaxPTSDValue, (Double)ptsdValue);
                continue;
            }
            this.remainingValue.remove(key);
            this.contactValue.remove(key);
            this.entities.remove(key);
            this.currentMaxPTSDValue = 0.0;
            for (String key2 : this.remainingValue.keySet()) {
                double ptsdValue2 = this.PTSD.get(key2);
                if (!(ptsdValue2 > 20.0)) continue;
                this.currentMaxPTSDValue = Math.max(this.currentMaxPTSDValue, ptsdValue2);
            }
            if (!(this.currentMaxPTSDValue <= 20.0)) continue;
            ifSendRelief = true;
        }
        double distance = 24.0;
        if (!ifSendRelief) {
            for (String key : this.entities.keySet()) {
                ArrayDeque<Entity> list = this.entities.get(key);
                list.removeIf(entity -> entity == null || entity.m_213877_());
                for (Entity entity2 : list) {
                    double dis = player.m_20270_(entity2);
                    distance = Math.min(distance, dis);
                }
            }
        }
        if (this.currentMaxPTSDValue > 36.0) {
            this.mentalStatus.mentalHurt(ONSET_EMOTION_DECREASE * 4.0);
            if (this.photismCountdown == null) {
                this.photismCountdown = 30 + (int)this.mentalStatus.emotionValue;
            } else {
                this.photismCountdown = this.photismCountdown - 1;
                if (this.photismCountdown == 0) {
                    this.phonismOnset(player);
                    if (!this.photismId.isEmpty()) {
                        int index = this.random.nextInt(this.photismId.size());
                        for (String key : this.photismId) {
                            if (index-- != 0) continue;
                            PTSDOnsetPacket.sendPhotismPacket(player, key);
                            break;
                        }
                    }
                    this.photismCountdown = 30 + (int)this.mentalStatus.emotionValue;
                }
            }
            player.m_216990_((SoundEvent)ModSounds.PANT.get());
            PTSDOnsetPacket.sendToPlayer(player, 4, distance);
        } else if (this.currentMaxPTSDValue > 32.0) {
            this.mentalStatus.mentalHurt(ONSET_EMOTION_DECREASE * 3.0);
            if (this.phonismCountdown == null) {
                this.phonismCountdown = 60 + (int)this.mentalStatus.emotionValue * 2;
            } else {
                this.phonismCountdown = this.phonismCountdown - 1;
                if (this.phonismCountdown == 0) {
                    this.phonismOnset(player);
                    this.phonismCountdown = 60 + (int)this.mentalStatus.emotionValue * 2;
                }
            }
            player.m_216990_((SoundEvent)ModSounds.PANT.get());
            PTSDOnsetPacket.sendToPlayer(player, 3, distance);
        } else if (this.currentMaxPTSDValue > 26.0) {
            this.mentalStatus.mentalHurt(ONSET_EMOTION_DECREASE * 2.0);
            player.m_216990_((SoundEvent)ModSounds.PANT.get());
            PTSDOnsetPacket.sendToPlayer(player, 2, distance);
        } else if (this.currentMaxPTSDValue > 20.0) {
            this.mentalStatus.mentalHurt(ONSET_EMOTION_DECREASE * 1.0);
            player.m_5496_((SoundEvent)ModSounds.PANT.get(), 0.5f, 1.0f);
            PTSDOnsetPacket.sendToPlayer(player, 1, distance);
        } else if (ifSendRelief) {
            PTSDOnsetPacket.sendToPlayer(player, 0, -1.0);
        }
    }

    public void phonismOnset(ServerPlayer player) {
        if (this.phonismId.isEmpty()) {
            return;
        }
        int index = this.random.nextInt(this.phonismId.size());
        block0: for (String key : this.phonismId) {
            if (index-- != 0) continue;
            if (damageSourceMap.containsKey(key)) {
                List<SoundEvent> soundEvents = damageSourceMap.get(key);
                int index2 = this.random.nextInt(soundEvents.size());
                for (SoundEvent soundEvent : soundEvents) {
                    if (index2-- != 0) continue;
                    player.m_6330_(soundEvent, player.m_5720_(), 1.0f, 1.0f);
                    break block0;
                }
                break;
            }
            EntityType.m_20632_((String)key).ifPresent(entityType -> {
                SoundEvent soundEvent;
                if (Mob.class.isAssignableFrom(entityType.m_142225_()) && (soundEvent = ((MobAccess)entityType.m_20615_(player.m_9236_())).invokeGetAmbientSound()) != null) {
                    player.m_6330_(soundEvent, player.m_5720_(), 1.0f, 1.0f);
                }
            });
            break;
        }
    }

    public boolean hasRemaining() {
        return !this.remainingValue.isEmpty();
    }

    public void clear(ServerPlayer player) {
        this.contactValue.clear();
        this.remainingValue.clear();
        this.entities.clear();
        this.currentMaxPTSDValue = 0.0;
        this.phonismCountdown = null;
        this.photismCountdown = null;
        this.phonismId.clear();
        this.photismId.clear();
        PTSDOnsetPacket.sendToPlayer(player, 0, -1.0);
    }

    public void hurt(String key) {
        if (this.contactValue.containsKey(key)) {
            this.contactValue.put(key, 0);
            this.remainingValue.put(key, 30);
        }
    }

    public static void onPlaySound(ServerPlayer player) {
        MentalStatus mentalStatus;
        if (TempValues.broadcastEntity != null && (mentalStatus = Registry.mentalStatus.get(player.m_20148_())) != null) {
            mentalStatus.ptsdManager.trigger(TempValues.broadcastEntity);
        }
        if (TempValues.broadcastDamageSource != null && (mentalStatus = Registry.mentalStatus.get(player.m_20148_())) != null) {
            for (String damageSource : TempValues.broadcastDamageSource) {
                mentalStatus.ptsdManager.trigger(damageSource);
            }
        }
    }

    public static void receivePlaySoundPacket(FriendlyByteBuf buf, NetworkManager.PacketContext packetContext) {
        PTSDManager manager = Registry.mentalStatus.get((Object)packetContext.getPlayer().m_20148_()).ptsdManager;
        String soundEvent = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
        for (String damageSource : soundEventMap.get(soundEvent)) {
            manager.trigger(damageSource);
        }
    }

    public void trigger(String key) {
        if (this.remainingValue.containsKey(key)) {
            this.remainingValue.put(key, 30);
        } else if (this.PTSD.containsKey(key)) {
            Double value = this.PTSD.get(key);
            this.currentMaxPTSDValue = Math.max(this.currentMaxPTSDValue, value);
            if (value > 6.0) {
                if (!this.contactValue.containsKey(key)) {
                    this.contactValue.put(key, 0);
                }
                this.remainingValue.put(key, 30);
            }
        }
    }

    public void trigger(Entity entity) {
        String key = entity.m_20078_();
        if (key == null) {
            return;
        }
        if (this.remainingValue.containsKey(key)) {
            this.remainingValue.put(key, 30);
            this.entities.computeIfAbsent(key, k -> new ArrayDeque()).add(entity);
        } else if (this.PTSD.containsKey(key)) {
            Double value = this.PTSD.get(key);
            this.currentMaxPTSDValue = Math.max(this.currentMaxPTSDValue, value);
            if (value > 6.0) {
                if (!this.contactValue.containsKey(key)) {
                    this.contactValue.put(key, 0);
                    this.entities.computeIfAbsent(key, k -> new ArrayDeque()).add(entity);
                }
                this.remainingValue.put(key, 30);
            }
        }
    }

    public void readNbt(CompoundTag tag) {
        if (tag.m_128441_("contact_value")) {
            CompoundTag contactValueTag = tag.m_128469_("contact_value");
            for (String key : contactValueTag.m_128431_()) {
                this.contactValue.put(key, contactValueTag.m_128451_(key));
            }
        }
        if (tag.m_128441_("remaining_value")) {
            CompoundTag remainingValueTag = tag.m_128469_("remaining_value");
            for (String key : remainingValueTag.m_128431_()) {
                this.remainingValue.put(key, remainingValueTag.m_128451_(key));
            }
        }
        if (tag.m_128441_("phonism_countdown")) {
            this.phonismCountdown = tag.m_128451_("phonism_countdown");
        }
        if (tag.m_128441_("photism_countdown")) {
            this.photismCountdown = tag.m_128451_("photism_countdown");
        }
    }

    public void writeNbt(CompoundTag tag) {
        if (!this.contactValue.isEmpty()) {
            CompoundTag contactValueTag = new CompoundTag();
            for (String key : this.contactValue.keySet()) {
                contactValueTag.m_128405_(key, this.contactValue.get(key).intValue());
            }
            tag.m_128365_("contact_value", (Tag)contactValueTag);
        }
        if (!this.remainingValue.isEmpty()) {
            CompoundTag remainingValueTag = new CompoundTag();
            for (String key : this.remainingValue.keySet()) {
                remainingValueTag.m_128405_(key, this.remainingValue.get(key).intValue());
            }
            tag.m_128365_("remaining_value", (Tag)remainingValueTag);
        }
        if (this.phonismCountdown != null) {
            tag.m_128405_("phonism_countdown", this.phonismCountdown.intValue());
        } else {
            tag.m_128473_("phonism_countdown");
        }
        if (this.photismCountdown != null) {
            tag.m_128405_("photism_countdown", this.photismCountdown.intValue());
        } else {
            tag.m_128473_("photism_countdown");
        }
    }

    static {
        soundEventMap = new HashMap();
        damageSourceMap = new HashMap();
    }
}

