/*
 * Decompiled with CFR 0.152.
 */
package net.depression.mental;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.depression.effect.ModEffects;
import net.depression.mental.MentalIllness;
import net.depression.mental.MentalTrait;
import net.depression.mental.PTSDManager;
import net.depression.network.ActionbarHintPacket;
import net.depression.network.MentalStatusPacket;
import net.depression.server.Registry;
import net.depression.util.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class MentalStatus {
    public static double EMOTION_STABILIZE_RATE;
    public static double MENTAL_HEALTH_CHANGE_RATE;
    public static double PTSD_DAMAGE_RATE;
    public static double PTSD_DISPERSE_RATE;
    public static double FOOD_HEAL_RATE;
    public static int BOREDOM_DECREASE_TICK;
    public static boolean IS_RANDOM_CHOOSE_TRAIT;
    public static String DEFAULT_MENTAL_TRAIT;
    public static HashMap<String, String> nearbyHealBlockType;
    public static HashMap<String, Double> nearbyHealBlockValue;
    public static HashMap<String, Integer> nearbyHealBlockRadius;
    public static HashMap<String, Double> lootHealItem;
    public static HashMap<String, Double> foodHealValue;
    public static int radiusMaxValue;
    public static HashMap<String, Double> breakHealBlock;
    public static HashMap<String, Double> killHealEntity;
    public static HashMap<String, Double> smeltHealItem;
    public static HashMap<String, Double> healAdvancement;
    private final ConcurrentHashMap<String, Integer> boredom = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, Double> PTSD = new ConcurrentHashMap();
    public final PTSDManager ptsdManager = new PTSDManager(this, this.PTSD);
    private final ConcurrentHashMap<String, Long> PTSDTimeBuffer = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Double> PTSDValueBuffer = new ConcurrentHashMap();
    public final HashSet<String> playerPTSDSet = new HashSet();
    public double emotionValue;
    public double mentalHealthValue = 100.0;
    public MentalTrait mentalTrait;
    public int combatCountdown = 0;
    public MentalIllness mentalIllness;
    private ServerPlayer player;
    public long tickCount = -1L;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private AttributeModifier speedModifier;
    private AttributeModifier attributeModifier;

    public MentalStatus(ServerPlayer player) {
        this.player = player;
        this.mentalIllness = new MentalIllness(player, this);
    }

    public MentalStatus(ServerPlayer player, MentalTrait mentalTrait) {
        this.loadMentalTrait(mentalTrait);
        this.player = player;
        this.mentalIllness = new MentalIllness(player, this);
    }

    public void loadMentalTrait(MentalTrait mentalTrait) {
        this.mentalTrait = mentalTrait;
        if (mentalTrait.initialMentalHealthValue != null) {
            this.mentalHealthValue = mentalTrait.initialMentalHealthValue.intValue();
            this.mentalIllness.mentalHealthLevel = MentalIllness.getMentalHealthLevel(this.mentalHealthValue);
        }
        if (mentalTrait.initialMentalHealthId != null) {
            this.mentalIllness.mentalHealthId = mentalTrait.initialMentalHealthId;
        }
    }

    public synchronized void triggerHurt(String id) {
        this.ptsdManager.hurt(id);
    }

    public synchronized void tick(ServerPlayer player) {
        if (this.mentalTrait == null) {
            return;
        }
        this.player = player;
        ++this.tickCount;
        if (this.tickCount % (long)BOREDOM_DECREASE_TICK == 0L) {
            for (Map.Entry<String, Number> entry : this.boredom.entrySet()) {
                int n = (Integer)entry.getValue();
                if (n % 4 == 0) {
                    entry.setValue(n - n / 4);
                } else {
                    entry.setValue(n - (n / 4 + 1));
                }
                if ((Integer)entry.getValue() > 1) continue;
                this.boredom.remove(entry.getKey());
            }
        }
        for (Map.Entry<String, Number> entry : this.PTSDTimeBuffer.entrySet()) {
            if (this.tickCount - (Long)entry.getValue() < 200L) continue;
            String string = entry.getKey();
            Double damage = this.PTSDValueBuffer.get(string);
            if (damage == null) {
                this.PTSDTimeBuffer.remove(string);
                continue;
            }
            if (!string.equals(player.m_5446_().getString())) {
                Double originValue = this.PTSD.get(string);
                if (originValue == null) {
                    originValue = 0.0;
                    EntityType.m_20632_((String)string).ifPresentOrElse(entityType -> ActionbarHintPacket.sendPTSDFormPacket(player, entityType.m_20676_()), () -> {
                        if (this.playerPTSDSet.contains(string)) {
                            ActionbarHintPacket.sendPTSDFormPacket(player, (Component)Component.m_237113_((String)string));
                        } else {
                            ActionbarHintPacket.sendPTSDFormPacket(player, (Component)Component.m_237115_((String)("message.depression.damagesource." + string)));
                        }
                    });
                }
                this.PTSD.put(string, Math.min(originValue + damage, 40.0));
            }
            this.PTSDTimeBuffer.remove(string);
            this.PTSDValueBuffer.remove(string);
        }
        if (this.tickCount % 20L == 0L) {
            this.executor.submit(this::detectNearbyHealBlock);
            ServerLevel level = player.m_284548_();
            if (this.mentalIllness.isInsomnia != null && level.m_46468_() % 24000L < 12010L) {
                this.mentalIllness.isInsomnia = null;
            }
            if (player.m_5803_()) {
                if (this.mentalIllness.isInsomnia == null) {
                    this.mentalIllness.setIsInsomnia();
                }
                if (!this.mentalIllness.isInsomnia.booleanValue()) {
                    this.mentalHeal("sleeping", 1.0);
                }
            }
            for (Map.Entry<String, Double> entry : this.PTSD.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue() <= 20.0) {
                    value = entry.getValue();
                    entry.setValue(value - PTSD_DISPERSE_RATE * (11.0 - value / 2.0));
                } else {
                    value = entry.getValue() - PTSD_DISPERSE_RATE;
                    entry.setValue(value);
                    EntityType.m_20632_((String)key).ifPresentOrElse(entityType -> {
                        List list = level.m_143280_((EntityTypeTest)entityType, this::viewDetect);
                        for (Entity entity : list) {
                            this.ptsdManager.trigger(entity);
                        }
                        if (value > 36.0) {
                            this.ptsdManager.photismId.add(key);
                        } else {
                            this.ptsdManager.photismId.remove(key);
                        }
                    }, () -> {
                        for (ServerPlayer serverPlayer : level.m_6907_()) {
                            String name = serverPlayer.m_5446_().getString();
                            if (!name.equals(key) || !this.viewDetect((Entity)serverPlayer)) continue;
                            this.ptsdManager.trigger(key);
                        }
                    });
                    if (value > 32.0) {
                        this.ptsdManager.phonismId.add(key);
                    } else {
                        this.ptsdManager.phonismId.remove(key);
                    }
                }
                if (!(entry.getValue() <= 0.0)) continue;
                String id = entry.getKey();
                this.removePTSD(id);
            }
            if (!this.mentalIllness.isMania) {
                if (this.emotionValue < 0.0) {
                    if (this.mentalIllness.mentalHealthId == 4) {
                        MobEffect mobEffect = (MobEffect)ModEffects.ANTI_DEPRESSION.get();
                        MobEffect mobEffect2 = (MobEffect)ModEffects.ANTI_MANIA.get();
                        if (player.m_21023_(mobEffect) && player.m_21023_(mobEffect2) && player.m_21124_(mobEffect2).m_19564_() >= 2) {
                            this.mentalHealthValue += this.emotionValue * MENTAL_HEALTH_CHANGE_RATE * this.mentalTrait.mentalHurtMultiplier / 4.0;
                        }
                    } else {
                        this.mentalHealthValue += this.emotionValue * MENTAL_HEALTH_CHANGE_RATE * this.mentalTrait.mentalHurtMultiplier;
                    }
                } else {
                    this.mentalHealthValue += this.emotionValue * MENTAL_HEALTH_CHANGE_RATE;
                }
            }
            this.mentalHealthValue = Math.max(0.0, this.mentalHealthValue);
            this.mentalHealthValue = Math.min(100.0, this.mentalHealthValue);
            if (this.mentalIllness.mentalHealthId < 4) {
                if (this.emotionValue < 0.0) {
                    double d = 1.0;
                    BlockPos respawnPos = player.m_8961_();
                    if (respawnPos != null && Math.sqrt(respawnPos.m_203193_((Position)player.m_20182_())) <= 20.0) {
                        d *= 1.5;
                    }
                    if (player.m_9236_().m_45517_(LightLayer.SKY, player.m_20183_()) >= 13) {
                        d *= 1.5;
                    }
                    this.emotionValue += EMOTION_STABILIZE_RATE * Math.abs(this.emotionValue) / 20.0 * d;
                    this.emotionValue = Math.min(0.0, this.emotionValue);
                } else {
                    this.emotionValue -= EMOTION_STABILIZE_RATE * Math.abs(this.emotionValue) / 20.0;
                    this.emotionValue = Math.max(0.0, this.emotionValue);
                }
            }
            AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
            AttributeInstance attributeInstance2 = player.m_21051_(Attributes.f_22281_);
            AttributeInstance attackSpeed = player.m_21051_(Attributes.f_22283_);
            if (this.attributeModifier != null) {
                attributeInstance.m_22130_(this.speedModifier);
                attributeInstance2.m_22130_(this.attributeModifier);
                attackSpeed.m_22130_(this.attributeModifier);
            }
            double emotionModifier = this.emotionValue * 1.5 / 100.0;
            this.speedModifier = this.combatCountdown > 0 && emotionModifier < 0.0 ? new AttributeModifier("depression:speed_modifier", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL) : new AttributeModifier("depression:speed_modifier", emotionModifier - this.getMentalHealthModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (emotionModifier < 0.0 && !this.mentalTrait.isBadEmotionLowerCombat) {
                emotionModifier = 0.0;
            }
            if (emotionModifier > 0.0 && !this.mentalTrait.isGoodEmotionHigherCombat) {
                emotionModifier = 0.0;
            }
            this.attributeModifier = new AttributeModifier("depression:emotion_modifier", emotionModifier - this.getMentalHealthModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            attributeInstance.m_22118_(this.speedModifier);
            attributeInstance2.m_22118_(this.attributeModifier);
            attackSpeed.m_22118_(this.attributeModifier);
            MentalStatusPacket.sendToPlayer(player, this);
            if (this.combatCountdown > 0) {
                --this.combatCountdown;
            }
            this.ptsdManager.tick(player);
        }
        this.mentalIllness.tick(player);
    }

    private double getMentalHealthModifier() {
        if (this.mentalIllness.mentalHealthId < 4) {
            return (double)this.mentalIllness.mentalHealthId / 10.0;
        }
        if (this.isMania()) {
            return 0.0;
        }
        return 0.3;
    }

    public synchronized boolean viewDetect(Entity entity) {
        Vec3 vec3 = this.player.m_20252_(1.0f).m_82541_();
        Vec3 vec32 = new Vec3(entity.m_20185_() - this.player.m_20185_(), entity.m_20188_() - this.player.m_20188_(), entity.m_20189_() - this.player.m_20189_());
        double d = vec32.m_82553_();
        double e = vec3.m_82526_(vec32 = vec32.m_82541_());
        return e > 1.0 - 0.5 / d ? this.player.m_142582_(entity) : false;
    }

    public synchronized void removePTSD(String id) {
        this.PTSD.remove(id);
        EntityType.m_20632_((String)id).ifPresentOrElse(entityType -> ActionbarHintPacket.sendPTSDDispersePacket(this.player, entityType.m_20676_()), () -> {
            if (this.playerPTSDSet.contains(id)) {
                ActionbarHintPacket.sendPTSDDispersePacket(this.player, (Component)Component.m_237113_((String)id));
                this.playerPTSDSet.remove(id);
            } else {
                ActionbarHintPacket.sendPTSDDispersePacket(this.player, (Component)Component.m_237115_((String)("message.depression.damagesource." + id)));
            }
        });
    }

    public synchronized double mentalHeal(double value) {
        if (this.getMentalHealthId() == 4) {
            return 0.0;
        }
        double toReturn = value * this.mentalHealthValue / 100.0;
        this.emotionValue += toReturn;
        this.emotionValue = Math.min(20.0, this.emotionValue);
        return toReturn;
    }

    public synchronized double mentalHeal(String string, double value, int count) {
        Integer i = this.boredom.get(string);
        if (i == null) {
            i = 0;
        }
        this.boredom.put(string, i + count);
        return this.mentalHeal((Tools.getHarmonic(i + count) - Tools.getHarmonic(i)) * value);
    }

    public synchronized double mentalHeal(String string, double value) {
        if (this.boredom.containsKey(string)) {
            this.boredom.put(string, this.boredom.get(string) + 1);
        } else {
            this.boredom.put(string, 2);
        }
        return this.mentalHeal(value /= (double)this.boredom.get(string).intValue() / 2.0);
    }

    public synchronized void mentalHurt(double value) {
        if (this.player.m_7500_() || this.player.m_5833_()) {
            return;
        }
        this.emotionValue -= value;
        this.emotionValue = Math.max(-20.0, this.emotionValue);
    }

    public synchronized void mentalHurt(Component component, double damage) {
        this.playerPTSDSet.add(component.getString());
        this.mentalHurt(component.getString(), damage);
    }

    public synchronized void mentalHurt(String string, double damage) {
        if (string == null) {
            return;
        }
        if (!string.equals(this.player.m_5446_().getString())) {
            BlockPos pos;
            Level level = this.player.m_9236_();
            int brightness = Math.max(level.m_45517_(LightLayer.BLOCK, pos = this.player.m_20183_()), level.m_45517_(LightLayer.SKY, pos));
            if (brightness <= 7 && this.mentalTrait.isDarknessAffectEmotion) {
                damage *= 1.3 + (7.0 - (double)brightness) / 7.0 * 0.2;
            }
            if (this.PTSDTimeBuffer.containsKey(string)) {
                Double originValue = this.PTSDValueBuffer.get(string);
                if (originValue == null) {
                    originValue = 0.0;
                }
                this.PTSDTimeBuffer.put(string, this.tickCount);
                this.PTSDValueBuffer.put(string, originValue + damage);
            } else {
                Double PTSDValue = this.PTSD.get(string);
                if (PTSDValue != null) {
                    this.mentalHurt(PTSDValue * PTSD_DAMAGE_RATE);
                }
                this.PTSDTimeBuffer.put(string, this.tickCount);
                this.PTSDValueBuffer.put(string, damage);
            }
        }
        this.mentalHurt(damage);
    }

    public void detectNearbyHealBlock() {
        BlockPos pos = this.player.m_20183_();
        Level level = this.player.m_9236_();
        int r = radiusMaxValue;
        HashMap<MutableComponent, Integer> detectedBlocksCount = new HashMap<MutableComponent, Integer>();
        HashMap<String, Double> detectedTypesHealValue = new HashMap<String, Double>();
        double totalHealValue = 0.0;
        for (int x = -r; x <= r; ++x) {
            int yLimit = (int)Math.sqrt(r * r - x * x);
            for (int y = -yLimit; y <= yLimit; ++y) {
                int zLimit = (int)Math.sqrt(r * r - x * x - y * y);
                for (int z = -zLimit; z <= zLimit; ++z) {
                    int distance;
                    BlockPos blockPos = pos.m_7918_(x, y, z);
                    if (!level.m_46865_(blockPos).m_6415_().m_62427_(ChunkStatus.f_62326_)) continue;
                    Block block = level.m_8055_(blockPos).m_60734_();
                    if (block instanceof FlowerPotBlock) {
                        block = ((FlowerPotBlock)block).m_53560_();
                    }
                    String id = block.arch$registryName().toString();
                    MutableComponent name = block.m_49954_();
                    Double value = this.getTypeHealValue(id);
                    Integer radius = nearbyHealBlockRadius.get(id);
                    if (radius == null || value == null || (distance = (int)Math.sqrt(x * x + y * y + z * z)) > radius) continue;
                    detectedBlocksCount.put(name, detectedBlocksCount.getOrDefault(name, 0) + 1);
                    String type = nearbyHealBlockType.get(id);
                    if (type == null) {
                        type = id;
                    }
                    detectedTypesHealValue.put(type, detectedTypesHealValue.getOrDefault(type, 0.0) + value / (double)((Integer)detectedBlocksCount.get(name)).intValue());
                }
            }
        }
        for (Map.Entry entry : detectedTypesHealValue.entrySet()) {
            totalHealValue += this.mentalHeal((String)entry.getKey(), (Double)entry.getValue());
        }
        if (totalHealValue > 0.25) {
            Component maxHealName = null;
            int mostHealCount = 0;
            for (Map.Entry entry : detectedBlocksCount.entrySet()) {
                if ((Integer)entry.getValue() <= mostHealCount) continue;
                mostHealCount = (Integer)entry.getValue();
                maxHealName = (Component)entry.getKey();
            }
            if (maxHealName != null) {
                ActionbarHintPacket.sendNearbyBlockHealPacket(this.player, maxHealName);
            }
        }
    }

    private Double getTypeHealValue(String id) {
        Double value = nearbyHealBlockValue.get(id);
        if (value == null) {
            return null;
        }
        if (nearbyHealBlockType.containsKey(id)) {
            String type = nearbyHealBlockType.get(id);
            if (this.boredom.containsKey(type)) {
                return value / ((double)this.boredom.get(type).intValue() / 2.0);
            }
            return value;
        }
        if (this.boredom.containsKey(id)) {
            return value / ((double)this.boredom.get(id).intValue() / 2.0);
        }
        return value;
    }

    public boolean isMania() {
        return this.mentalIllness.isMania;
    }

    public int getMentalHealthId() {
        return this.mentalIllness.mentalHealthId;
    }

    public void readNbt(CompoundTag tag) {
        if (tag.m_128441_("mental_trait")) {
            this.mentalTrait = MentalTrait.mentalTraits.getOrDefault(tag.m_128461_("mental_trait"), new MentalTrait("normal"));
        }
        CompoundTag boredomTag = tag.m_128469_("boredom");
        for (Object key : boredomTag.m_128431_()) {
            this.boredom.put((String)key, boredomTag.m_128451_((String)key));
        }
        CompoundTag ptsd = tag.m_128469_("PTSD");
        for (Object key : ptsd.m_128431_()) {
            this.PTSD.put((String)key, ptsd.m_128459_((String)key));
        }
        CompoundTag ptsdTimeBuffer = tag.m_128469_("PTSD_time_buffer");
        for (Object key : ptsdTimeBuffer.m_128431_()) {
            this.PTSDTimeBuffer.put((String)key, this.tickCount - ptsdTimeBuffer.m_128454_((String)key));
        }
        CompoundTag ptsdValueBuffer = tag.m_128469_("PTSD_value_buffer");
        for (String key : ptsdValueBuffer.m_128431_()) {
            this.PTSDValueBuffer.put(key, ptsdValueBuffer.m_128459_(key));
        }
        if (tag.m_128441_("player_ptsd_buffer")) {
            ListTag playerPTSDBufferTag = tag.m_128437_("player_ptsd_buffer", 8);
            for (int i = 0; i < playerPTSDBufferTag.size(); ++i) {
                this.playerPTSDSet.add(playerPTSDBufferTag.m_128778_(i));
            }
        }
        if (tag.m_128441_("emotion_value")) {
            this.emotionValue = tag.m_128459_("emotion_value");
        }
        if (tag.m_128441_("mental_health_value")) {
            this.mentalHealthValue = tag.m_128459_("mental_health_value");
        }
        if (tag.m_128441_("combat_countdown")) {
            this.combatCountdown = tag.m_128451_("combat_countdown");
        }
        CompoundTag mentalIllnessTag = tag.m_128469_("mental_illness");
        this.mentalIllness.readNbt(mentalIllnessTag);
        CompoundTag ptsdManagerTag = tag.m_128469_("ptsd_manager");
        this.ptsdManager.readNbt(ptsdManagerTag);
    }

    public void writeNbt(CompoundTag tag) {
        if (this.mentalTrait != null) {
            tag.m_128359_("mental_trait", this.mentalTrait.id);
        }
        CompoundTag boredomTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.boredom.entrySet()) {
            boredomTag.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        tag.m_128365_("boredom", (Tag)boredomTag);
        CompoundTag ptsd = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.PTSD.entrySet()) {
            ptsd.m_128347_(entry.getKey(), entry.getValue().doubleValue());
        }
        tag.m_128365_("PTSD", (Tag)ptsd);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<String, Long> entry : this.PTSDTimeBuffer.entrySet()) {
            compoundTag.m_128356_(entry.getKey(), this.tickCount - entry.getValue());
        }
        tag.m_128365_("PTSD_time_buffer", (Tag)compoundTag);
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.PTSDValueBuffer.entrySet()) {
            compoundTag2.m_128347_(entry.getKey(), entry.getValue().doubleValue());
        }
        tag.m_128365_("PTSD_value_buffer", (Tag)compoundTag2);
        if (!this.playerPTSDSet.isEmpty()) {
            ListTag listTag = new ListTag();
            for (String string : this.playerPTSDSet) {
                listTag.add((Object)StringTag.m_129297_((String)string));
            }
            tag.m_128365_("player_ptsd_buffer", (Tag)listTag);
        }
        tag.m_128347_("emotion_value", this.emotionValue);
        tag.m_128347_("mental_health_value", this.mentalHealthValue);
        tag.m_128347_("combat_countdown", (double)this.combatCountdown);
        CompoundTag compoundTag3 = new CompoundTag();
        this.mentalIllness.writeNbt(compoundTag3);
        tag.m_128365_("mental_illness", (Tag)compoundTag3);
        CompoundTag compoundTag4 = new CompoundTag();
        this.ptsdManager.writeNbt(compoundTag4);
        tag.m_128365_("ptsd_manager", (Tag)compoundTag4);
    }

    public static MentalStatus getMentalStatusByServerPlayer(Player player) {
        UUID uuid = player.m_20148_();
        MentalStatus instance = Registry.mentalStatus.get(uuid);
        if (instance == null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            instance = new MentalStatus(serverPlayer);
            Registry.mentalStatus.put(uuid, instance);
        } else if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("You are not a ServerPlayer");
        }
        return instance;
    }

    public static double onLoot(Player player, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        String id = item.arch$registryName().toString();
        MentalStatus mentalStatus = MentalStatus.getMentalStatusByServerPlayer(player);
        double idHealValue = 0.0;
        double enchantmentHealValue = 0.0;
        if (lootHealItem.containsKey(id)) {
            idHealValue = mentalStatus.mentalHeal(id, lootHealItem.get(id), itemStack.m_41613_());
        }
        if (itemStack.m_41793_()) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (enchantment.m_6589_()) {
                    enchantmentHealValue -= (double)((Integer)entry.getValue()).intValue() / (double)enchantment.m_44699_().m_44716_() * (double)level;
                    continue;
                }
                enchantmentHealValue += (double)((Integer)entry.getValue()).intValue() / (double)enchantment.m_44699_().m_44716_() * (double)level;
            }
            if (enchantmentHealValue > 0.0) {
                mentalStatus.mentalHeal(enchantmentHealValue);
            }
        }
        return idHealValue + enchantmentHealValue;
    }

    static {
        nearbyHealBlockType = new HashMap();
        nearbyHealBlockValue = new HashMap();
        nearbyHealBlockRadius = new HashMap();
        lootHealItem = new HashMap();
        foodHealValue = new HashMap();
        breakHealBlock = new HashMap();
        killHealEntity = new HashMap();
        smeltHealItem = new HashMap();
        healAdvancement = new HashMap();
    }
}

